ChooseMSL1 =
{
	{ type = "mslo", pos = CPos.New(70, 63), cost = 2500 }
}

BuildMSL1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseMSL1) do
		if not v.exists then
			PlaceMSL1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildMSL1)
end

PlaceMSL1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildMSL1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildMSL1)
	end)
end

CheckHealthForMSL1 = function()
	Trigger.OnDamaged(MSL1, function()
		if MSL1.Owner == Player1 and MSL1.Health < MSL1.MaxHealth * 3/4 then
			MSL1.StartBuildingRepairs()
		end
		if MSL1.Owner == Player1 and MSL1.Health < MSL1.MaxHealth * 1/4 then
			MSL1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(MSL1, BuildMSL1)
end