ChooseSTE1 =
{
	{ type = "stek", pos = CPos.New(65, 62), cost = 1500 }
}

BuildSTE1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseSTE1) do
		if not v.exists then
			PlaceSTE1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildSTE1)
end

PlaceSTE1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildSTE1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildSTE1)
	end)
end

CheckHealthForSTE1 = function()
	Trigger.OnDamaged(STE1, function()
		if STE1.Owner == Player1 and STE1.Health < STE1.MaxHealth * 3/4 then
			STE1.StartBuildingRepairs()
		end
		if STE1.Owner == Player1 and STE1.Health < STE1.MaxHealth * 1/4 then
			STE1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(STE1, BuildSTE1)
end