ChooseDOM1 =
{
	{ type = "dome", pos = CPos.New(80, 71), cost = 1800 }
}

BuildDOM1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseDOM1) do
		if not v.exists then
			PlaceDOM1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildDOM1)
end

PlaceDOM1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildDOM1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildDOM1)
	end)
end

CheckHealthForDOM1 = function()
	Trigger.OnDamaged(DOM1, function()
		if DOM1.Owner == Player1 and DOM1.Health < DOM1.MaxHealth * 3/4 then
			DOM1.StartBuildingRepairs()
		end
		if DOM1.Owner == Player1 and DOM1.Health < DOM1.MaxHealth * 1/4 then
			DOM1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(DOM1, BuildDOM1)
end