ChoosePDO1 =
{
	{ type = "pdox", pos = CPos.New(61, 71), cost = 1500 }
}

BuildPDO1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChoosePDO1) do
		if not v.exists then
			PlacePDO1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPDO1)
end

PlacePDO1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPDO1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPDO1)
	end)
end

CheckHealthForPDO1 = function()
	Trigger.OnDamaged(PDO1, function()
		if PDO1.Owner == Player1 and PDO1.Health < PDO1.MaxHealth * 3/4 then
			PDO1.StartBuildingRepairs()
		end
		if PDO1.Owner == Player1 and PDO1.Health < PDO1.MaxHealth * 1/4 then
			PDO1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(PDO1, BuildPDO1)
end