ChoosePBO1 =
{
	{ type = "pbox", pos = CPos.New(40, 88), cost = 600 }
}

BuildPBO1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChoosePBO1) do
		if not v.exists then
			PlacePBO1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPBO1)
end

PlacePBO1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPBO1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPBO1)
	end)
end

CheckHealthForPBO1 = function()
	Trigger.OnDamaged(PBO1, function()
		if PBO1.Owner == Player1 and PBO1.Health < PBO1.MaxHealth * 3/4 then
			PBO1.StartBuildingRepairs()
		end
		if PBO1.Owner == Player1 and PBO1.Health < PBO1.MaxHealth * 1/4 then
			PBO1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(PBO1, BuildPBO1)
end

ChoosePBO2 =
{
	{ type = "pbox", pos = CPos.New(153, 92), cost = 600 }
}

BuildPBO2 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChoosePBO2) do
		if not v.exists then
			PlacePBO2(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPBO2)
end

PlacePBO2 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPBO2)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPBO2)
	end)
end

CheckHealthForPBO2 = function()
	Trigger.OnDamaged(PBO2, function()
		if PBO2.Owner == Player1 and PBO2.Health < PBO2.MaxHealth * 3/4 then
			PBO2.StartBuildingRepairs()
		end
		if PBO2.Owner == Player1 and PBO2.Health < PBO2.MaxHealth * 1/4 then
			PBO2.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(PBO2, BuildPBO2)
end