ChooseKEN1 =
{
	{ type = "kenn", pos = CPos.New(123, 47), cost = 100 }
}

BuildKEN1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseKEN1) do
		if not v.exists then
			PlaceKEN1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildKEN1)
end

PlaceKEN1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildKEN1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildKEN1)
	end)
end

CheckHealthForKEN1 = function()
	Trigger.OnDamaged(KEN1, function()
		if KEN1.Owner == Player1 and KEN1.Health < KEN1.MaxHealth * 3/4 then
			KEN1.StartBuildingRepairs()
		end
		if KEN1.Owner == Player1 and KEN1.Health < KEN1.MaxHealth * 1/4 then
			KEN1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(KEN1, BuildKEN1)
end