ChooseATE1 =
{
	{ type = "atek", pos = CPos.New(70, 71), cost = 1500 }
}

BuildATE1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseATE1) do
		if not v.exists then
			PlaceATE1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildATE1)
end

PlaceATE1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildATE1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildATE1)
	end)
end

CheckHealthForATE1 = function()
	Trigger.OnDamaged(ATE1, function()
		if ATE1.Owner == Player1 and ATE1.Health < ATE1.MaxHealth * 3/4 then
			ATE1.StartBuildingRepairs()
		end
		if ATE1.Owner == Player1 and ATE1.Health < ATE1.MaxHealth * 1/4 then
			ATE1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(ATE1, BuildATE1)
end