ChooseAFL1 =
{
	{ type = "afld.ukraine", pos = CPos.New(84, 71), cost = 500 }
}

BuildAFL1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseAFL1) do
		if not v.exists then
			PlaceAFL1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildAFL1)
end

PlaceAFL1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildAFL1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildAFL1)
	end)
end

CheckHealthForAFL1 = function()
	Trigger.OnDamaged(AFL1, function()
		if AFL1.Owner == Player1 and AFL1.Health < AFL1.MaxHealth * 3/4 then
			AFL1.StartBuildingRepairs()
		end
		if AFL1.Owner == Player1 and AFL1.Health < AFL1.MaxHealth * 1/4 then
			AFL1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(AFL1, BuildAFL1)
end