ChooseFIX1 =
{
	{ type = "fix", pos = CPos.New(122, 36), cost = 1200 }
}

BuildFIX1 = function()
	if not CheckExistenceForFAC1() then
		return
	end

	for i,v in ipairs(ChooseFIX1) do
		if not v.exists then
			PlaceFIX1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildFIX1)
end

PlaceFIX1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildFIX1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		FIXExists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false FIXExists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildFIX1)
	end)
end

CheckHealthForFIX1 = function()
	Trigger.OnDamaged(FIX1, function()
		if FIX1.Owner == Player1 and FIX1.Health < FIX1.MaxHealth * 3/4 then
			FIX1.StartBuildingRepairs()
		end
		if FIX1.Owner == Player1 and FIX1.Health < FIX1.MaxHealth * 1/4 then
			FIX1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(FIX1, function() BuildFIX1() FIXExists = false end)
end