OrdosReinf1		= { "trooper", "trooper", "trooper", "light_inf", "light_inf", "light_inf", "raider" }
OrdosReinf2		= { "quad", "combat_tank_o", "combat_tank_o", "stealth_raider" }
OrdosReinf3		= { "siege_tank", "siege_tank", "deviator" }
OrdosReinf4		= { "harvester", "combat_tank_o" }

MercenaryReinf	= { "sniper", "sniper", "sniper", "sniper", "sniper" }

OrdosReinf1Locations	= { ordos_reinf1_entry.Location, ordos_reinf1_waypoint.Location }
OrdosReinf2Locations	= { ordos_reinf2_entry.Location, ordos_reinf2_waypoint.Location }
OrdosReinf3Locations	= { CargoVehicleEntry.Location, ordos_reinf3_waypoint.Location }

MercenaryReinfLocations = { mercenary_reinf_entry.Location, mercenary_reinf_waypoint.Location }

atr_barr1		= { name = "barracks",			pos = CPos.New(59, 72), prize = 225,	exists = true }
atr_barr2		= { name = "barracks",			pos = CPos.New(35, 69), prize = 225,	exists = true }
atr_ref1		= { name = "refinery",			pos = CPos.New(67, 77), prize = 1500,	exists = true }
atr_ref2		= { name = "refinery",			pos = CPos.New(35, 65), prize = 1500,	exists = true }
atr_outpost		= { name = "outpost",			pos = CPos.New(39, 77), prize = 750,	exists = true }
atr_starport	= { name = "starport",			pos = CPos.New(47, 70), prize = 1500,	exists = true }
atr_hfac		= { name = "heavy_factory",		pos = CPos.New(55, 69), prize = 1000,	exists = true }
atr_lfac1		= { name = "light_factory",		pos = CPos.New(37, 73), prize = 500,	exists = true }
atr_lfac2		= { name = "light_factory",		pos = CPos.New(43, 73), prize = 500,	exists = true }
atr_htec		= { name = "high_tech_factory",	pos = CPos.New(59, 76), prize = 1150,	exists = true }
atr_rpad		= { name = "repair_pad",		pos = CPos.New(51, 70), prize = 800,	exists = true }
atr_wind1		= { name = "wind_trap",			pos = CPos.New(55, 77), prize = 255,	exists = true }
atr_wind2		= { name = "wind_trap",			pos = CPos.New(48, 77), prize = 255,	exists = true }
atr_wind3		= { name = "wind_trap",			pos = CPos.New(62, 77), prize = 255,	exists = true }
atr_wind4		= { name = "wind_trap",			pos = CPos.New(64, 77), prize = 255,	exists = true }
atr_wind5		= { name = "wind_trap",			pos = CPos.New(63, 73), prize = 255,	exists = true }
atr_wind6		= { name = "wind_trap",			pos = CPos.New(42, 77), prize = 255,	exists = true }
atr_wind7		= { name = "wind_trap",			pos = CPos.New(44, 77), prize = 255,	exists = true }
atr_wind8		= { name = "wind_trap",			pos = CPos.New(37, 77), prize = 255,	exists = true }
atr_wind9		= { name = "wind_trap",			pos = CPos.New(35, 77), prize = 255,	exists = true }

emp_barr1		= { name = "barracks",			pos = CPos.New(22, 77), prize = 225,	exists = true }
emp_barr2		= { name = "barracks",			pos = CPos.New(2,  71), prize = 225,	exists = true }
emp_ref1		= { name = "refinery",			pos = CPos.New(2,  52), prize = 1500,	exists = true }
emp_ref2		= { name = "refinery",			pos = CPos.New(17, 66), prize = 1500,	exists = true }
emp_palace		= { name = "palace",			pos = CPos.New(2,  77), prize = 1600,	exists = true }
emp_outpost		= { name = "outpost",			pos = CPos.New(18, 77), prize = 750,	exists = true }
emp_starport	= { name = "starport.emparor",	pos = CPos.New(6,  71), prize = 1500,	exists = true }
emp_hfac		= { name = "heavy_factory",		pos = CPos.New(21, 67), prize = 1000,	exists = true }
emp_lfac		= { name = "light_factory",		pos = CPos.New(12, 73), prize = 500,	exists = true }
emp_rpad		= { name = "repair_pad",		pos = CPos.New(11, 69), prize = 800,	exists = true }
emp_wind1		= { name = "wind_trap",			pos = CPos.New(8,  77), prize = 255,	exists = true }
emp_wind2		= { name = "wind_trap",			pos = CPos.New(10, 77), prize = 255,	exists = true }
emp_wind3		= { name = "wind_trap",			pos = CPos.New(12, 77), prize = 255,	exists = true }
emp_wind4		= { name = "wind_trap",			pos = CPos.New(14, 77), prize = 255,	exists = true }
emp_wind5		= { name = "wind_trap",			pos = CPos.New(16, 77), prize = 255,	exists = true }
emp_wind6		= { name = "wind_trap",			pos = CPos.New(16, 73), prize = 255,	exists = true }
emp_wind7		= { name = "wind_trap",			pos = CPos.New(10, 73), prize = 255,	exists = true }
emp_wind8		= { name = "wind_trap",			pos = CPos.New(22, 73), prize = 255,	exists = true }
emp_wind9		= { name = "wind_trap",			pos = CPos.New(14, 69), prize = 255,	exists = true }

AtreidesBaseBuildings =
{ 
	atr_barr1, 
	atr_barr2,
	atr_ref1,
	atr_ref2,
	atr_outpost,
	atr_starport,
	atr_hfac,
	atr_lfac1,
	atr_lfac2,
	atr_htec,
	atr_rpad,
	atr_wind1,
	atr_wind2,
	atr_wind3,
	atr_wind4,
	atr_wind5,
	atr_wind6,
	atr_wind7,
	atr_wind8,
	atr_wind9
}

AtreidesInitialBase =
{ 
	atreides_barr1, 
	atreides_barr2,
	atreides_ref1,
	atreides_ref2,
	atreides_outpost,
	atreides_starport,
	atreides_hfac,
	atreides_lfac1,
	atreides_lfac2,
	atreides_htec,
	atreides_rpad,
	atreides_wind1,
	atreides_wind2,
	atreides_wind3,
	atreides_wind4,
	atreides_wind5,
	atreides_wind6,
	atreides_wind7,
	atreides_wind8,
	atreides_wind9
}

EmparorBaseBuildings =
{ 
	emp_barr1, 
	emp_barr2,
	emp_ref1,
	emp_ref2,
	emp_palace,
	emp_outpost,
	emp_starport,
	emp_hfac,
	emp_lfac,
	emp_rpad,
	emp_wind1,
	emp_wind2,
	emp_wind3,
	emp_wind4,
	emp_wind5,
	emp_wind6,
	emp_wind7,
	emp_wind8,
	emp_wind9
}

EmparorInitialBase =
{ 
	emparor_barr1, 
	emparor_barr2,
	emparor_ref1,
	emparor_ref2,
	emparor_palace,
	emparor_outpost,
	emparor_starport,
	emparor_hfac,
	emparor_lfac,
	emparor_rpad,
	emparor_wind1,
	emparor_wind2,
	emparor_wind3,
	emparor_wind4,
	emparor_wind5,
	emparor_wind6,
	emparor_wind7,
	emparor_wind8,
	emparor_wind9
}

SetDestroyedBuildings = function(init, buildings)
	for i,v in ipairs(init) do
		Trigger.OnRemovedFromWorld(v, function()
			buildings[i].exists = false
		end)
		Trigger.OnKilled(v, function()
			buildings[i].exists = false
		end)
	end
end

GetBuilding = function(player, buildings, conyard)
	for i,v in ipairs(buildings) do
		BuildBase(player, v, conyard)
	end
end

BuildBase = function(player, building, conyard)
	if not building.exists then
		BuildBuilding(player, building, conyard)
		return
	end

	Trigger.AfterDelay(DateTime.Seconds(10), function() BuildBase(player, building, conyard) end)
end

BuildBuilding = function(player, building, conyard)
	Trigger.AfterDelay(Actor.BuildTime(building.name) * 2, function()
		if conyard.IsDead or conyard.Owner ~= player then
			Trigger.AfterDelay(DateTime.Seconds(10), function() BuildBase(player, building, conyard) end)
			return
		end

		building.exists = true

		local actor = Actor.Create(building.name, true, { Owner = player, Location = building.pos })
		player.Cash = player.Cash - building.prize

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnKilled(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == player and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
		end)
		Trigger.AfterDelay(DateTime.Seconds(10), function() BuildBase(player, building, conyard) end)
	end)
end

SendCargoVehicle = function()
	local CargoVehicle = Actor.Create("cargo_vehicle", true, { Owner = Multi0, Location = CargoVehicleEntry.Location })

	CargoVehicle.Move(CargoVehicleWaypoint.Location)
	Media.DisplayMessage("A Cargo Vehicle has arrived.", "Mentat")
	Trigger.AfterDelay(DateTime.Seconds(60), SendCargoVehicle)
end

SendCarryallReinforcement = function(waypoint, units, side, t)
	Trigger.AfterDelay(DateTime.Seconds(t), function()
		Reinforcements.ReinforceWithTransport(side, "carryall.reinforce", units, waypoint, { waypoint[1] })
	end)
end

SetPlayerCash = function()
	Multi1.Cash = 10000
	Multi3.Cash = 6000
	Multi4.Cash = 6000
end

InitObjectives = function()
	MercenaryObjective	= Multi0.AddPrimaryObjective("Ensure the victory of Ordos.")
	OrdosObjective		= Multi1.AddPrimaryObjective("Destroy the Atreides and the Imperial Forces.")
	Atreides2Objective	= Multi2.AddPrimaryObjective("Destroy the Ordos forces and their Mercenaries.")
	Atreides1Objective	= Multi3.AddPrimaryObjective("Destroy the Ordos forces and their Mercenaries.")
	EmparorObjective	= Multi4.AddPrimaryObjective("Ensure the victory of Atreides.")

	Trigger.OnPlayerLost(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "Lose")
		end)
	end)
	Trigger.OnPlayerWon(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "Win")
		end)
	end)
	
end
	
Tick = function()
	if Multi0.HasNoRequiredUnits() then
		Multi0.MarkFailedObjective(MercenaryObjective)
		Multi1.MarkFailedObjective(OrdosObjective)
	end

	if Multi1.HasNoRequiredUnits() then
		Multi0.MarkFailedObjective(MercenaryObjective)
		Multi1.MarkFailedObjective(OrdosObjective)
		Multi2.MarkCompletedObjective(Atreides2Objective)
		Multi3.MarkCompletedObjective(Atreides1Objective)
		Multi4.MarkCompletedObjective(EmparorObjective)
	end

	if Multi2.HasNoRequiredUnits() and  Multi3.HasNoRequiredUnits() and Multi4.HasNoRequiredUnits() then
		Multi0.MarkCompletedObjective(MercenaryObjective)
		Multi1.MarkCompletedObjective(OrdosObjective)
		Multi2.MarkFailedObjective(Atreides2Objective)
		Multi3.MarkFailedObjective(Atreides1Objective)
		Multi4.MarkFailedObjective(EmparorObjective)
	end
end

WorldLoaded = function()
	Multi0		= Player.GetPlayer("Multi0")
	Multi1		= Player.GetPlayer("Multi1")
	Multi2		= Player.GetPlayer("Multi2")
	Multi3		= Player.GetPlayer("Multi3")
	Multi4		= Player.GetPlayer("Multi4")
	Ordos		= Player.GetPlayer("Ordos")
	Atreides	= Player.GetPlayer("Atreides")
	Emparor		= Player.GetPlayer("Emparor")
	
	SetDestroyedBuildings(AtreidesInitialBase, AtreidesBaseBuildings)
	SetDestroyedBuildings(EmparorInitialBase, EmparorBaseBuildings)
	
	GetBuilding(Multi3, AtreidesBaseBuildings, atreides_cyard)
	GetBuilding(Multi4, EmparorBaseBuildings, emparor_cyard)
	
	Trigger.OnCapture(atreides_cyard, atreides_cyard.Kill)
	
	Trigger.OnCapture(emparor_cyard, emparor_cyard.Kill)
	
	InitObjectives()
	SetPlayerCash()
	
	Actor.Create("upgrade.barracks", true, { Owner = Multi2 })
	
	SendCarryallReinforcement(OrdosReinf1Locations, OrdosReinf1, Ordos, 120)
	SendCarryallReinforcement(OrdosReinf2Locations, OrdosReinf2, Ordos, 150)
	SendCarryallReinforcement(OrdosReinf3Locations, OrdosReinf3, Ordos, 200)
	SendCarryallReinforcement(OrdosReinf3Locations, OrdosReinf4, Multi1, 100)

	SendCarryallReinforcement(MercenaryReinfLocations, MercenaryReinf, Multi0, 150)
	SendCarryallReinforcement(MercenaryReinfLocations, MercenaryReinf, Multi0, 300)
	
	Trigger.AfterDelay(DateTime.Seconds(105), function()
		Media.DisplayMessage("Ordos Reinforcements have arrived.", "Mentat")
	end)
	
	Trigger.AfterDelay(DateTime.Seconds(125), function()
		Media.DisplayMessage("Ordos Reinforcements have arrived.", "Mentat")
	end)

	Trigger.AfterDelay(DateTime.Seconds(155), function()
		Media.DisplayMessage("Ordos Reinforcements have arrived.", "Mentat")
		Media.DisplayMessage("Sniper Team has arrived.", "Mentat")
	end)

	Trigger.AfterDelay(DateTime.Seconds(205), function()
		Media.DisplayMessage("Ordos Reinforcements have arrived.", "Mentat")
	end)
	
	Trigger.AfterDelay(DateTime.Seconds(305), function()
		Media.DisplayMessage("Sniper Team has arrived.", "Mentat")
	end)

	Trigger.AfterDelay(DateTime.Seconds(60), SendCargoVehicle)
end
