DestroyOutpostTriggerActivator = { Actor343, RBarracks1, Actor370, Actor337, RWarFactory1, Actor346, Actor371, Actor372, Actor338, Actor339, Actor340, Actor341 }

DestroyOutpostCompleted = function()
    Player.MarkCompletedObjective(DestroyOutpost)
end

MissionAccomplished = function()
	Media.PlaySpeechNotification(player, "MissionAccomplished")
end

MissionFailed = function()
	Media.PlaySpeechNotification(player, "MissionFailed")
end

SetupRebels = function()
	Rebels.Cash = 1000
end

WorldLoaded = function()
  Rebels = Player.GetPlayer("Rebels")
	Player = Player.GetPlayer("England")
  
	Trigger.OnObjectiveCompleted(Player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(Player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)

Trigger.OnPlayerLost(Player, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Player, "MissionFailed")
		end)
	end)
	Trigger.OnPlayerWon(Player, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Player, "MissionAccomplished")
		end)
  end)

	DestroyOutpost = Player.AddPrimaryObjective("Destroy the outpost to the North.")
	
  Trigger.OnAllRemovedFromWorld(DestroyOutpostTriggerActivator, DestroyOutpostCompleted)
  
Camera.Position = EnglandBase.CenterPosition

  SetupRebels()
  ProduceInfantry()
  ProduceVehicles()
end