AttackGroup = { }
AttackGroupSize = 5
RebelInfantryTypes = { "e1", "e1", "e3" }
RebelVehicleTypes = { "2tnk", "jeep" }

SendAttackGroup = function()
	if #AttackGroup < AttackGroupSize then
		return
	end

	Utils.Do(AttackGroup, function(unit)
		if not unit.IsDead then
			Trigger.OnIdle(unit, unit.Hunt)
		end
	end)

	AttackGroup = { }
end

ProduceInfantry = function()
	if RBarracks1.IsDead or RBarracks1.Owner ~= Rebels then
		return
	end

	Rebels.Build({ Utils.Random(RebelInfantryTypes) }, function(units)
		table.insert(AttackGroup, units[1])
		SendAttackGroup()
    Trigger.AfterDelay(DateTime.Seconds(10), ProduceInfantry)
	end)
end

ProduceVehicles = function()
	if RWarFactory1.IsDead or RWarFactory1.Owner ~= Rebels then
		return
	end

	Rebels.Build({ Utils.Random(RebelVehicleTypes) }, function(units)
		table.insert(AttackGroup, units[1])
		SendAttackGroup()
    Trigger.AfterDelay(DateTime.Seconds(10), ProduceVehicles)
	end)
end