local trees = {"t02", "t06", "t10", "t11", "t13", "t14", "t15"}
local freq = Map.LobbyOption("Freq")
map = {}
local w = 128
local h = 128
local Neutral = Player.GetPlayer("Neutral")

local hash = {
	208,34,231,213,32,248,233,56,161,78,24,140,71,48,140,254,245,255,247,247,40,
	185,248,251,245,28,124,204,204,76,36,1,107,28,234,163,202,224,245,128,167,204,
	9,92,217,54,239,174,173,102,193,189,190,121,100,108,167,44,43,77,180,204,8,81,
	70,223,11,38,24,254,210,210,177,32,81,195,243,125,8,169,112,32,97,53,195,13,
	203,9,47,104,125,117,114,124,165,203,181,235,193,206,70,180,174,0,167,181,41,
	164,30,116,127,198,245,146,87,224,149,206,57,4,192,210,65,210,129,240,178,105,
	228,108,245,148,140,40,35,195,38,58,65,207,215,253,65,85,208,76,62,3,237,55,89,
	232,50,217,64,244,157,199,121,252,90,17,212,203,149,152,140,187,234,177,73,174,
	193,100,192,143,97,53,145,135,19,103,13,90,135,151,199,91,239,247,33,39,145,
	101,120,99,3,186,86,99,41,237,203,111,79,220,135,158,42,30,154,120,67,87,167,
	135,176,183,191,253,115,184,21,233,58,129,233,142,39,128,211,118,137,139,255,
	114,20,218,113,154,27,127,246,250,1,8,198,250,209,92,222,173,21,88,102,219
}



local function noise2(x, y, seed) 
	local tmp = hash[((y + seed) % 256)+1]
	return hash[((tmp + x) % 256)+1]
end



local function lin_inter(x, y, s) 
	return x + s * (y-x)
end



local function smooth_inter(x, y, s) 
	return lin_inter(x, y, s * s * (3-2*s))
end



local function noise2d(x, y, seed) 
	local x_int = math.floor(x)
	local y_int = math.floor(y)
	local x_frac = x - x_int
	local y_frac = y - y_int
	local s = noise2(x_int, y_int, seed)
	local t = noise2(x_int+1, y_int, seed)
	local u = noise2(x_int, y_int+1, seed)
	local v = noise2(x_int+1, y_int+1, seed)
	local low = smooth_inter(s, t, x_frac)
	local high = smooth_inter(u, v, x_frac)
	return smooth_inter(low, high, y_frac)
end



local function perlin2d(x, y, freq, depth, seed) 
	local xa = x*freq
	local ya = y*freq
	local amp = 1.0
	local fin = 0
	local div = 0.0

	local i = 0
	while i<depth do
    
		div = div + (256 * amp)
		fin = fin + (noise2d(xa, ya, seed) * amp)
		amp = amp / 2
		xa = xa * 2
		ya = ya * 2
    i=i+1
	end

	return fin/div
end

local function doit()
  Media.Debug("Freq: "..freq)
  if freq == "small" then
    freq = 0.1
  elseif freq == "medium" then
    freq = 0.5
  else 
    freq = 0.9
  end
  local seed = os.time()
  -- Fill map
  for x=1,w do
    map[x] = {}
    for y=1,h do
      map[x][y] = perlin2d(x, y, freq, 1, seed)
    end
  end

  
  Media.Debug("Perlin for 10,10: "..perlin2d(10, 10, freq, 1, seed))
  -- Render it
  for x=1, w do
    for y=1, h do
      if map[x][y] > 0.5  then
        local actor = Actor.Create(Utils.Random(trees), true, {
          Owner = Neutral,
          Location = CPos.New(x, y)
        })
      end
    end
  end
end

WorldLoaded = function()
  
  Trigger.AfterDelay(0.1, doit)
end
