
Explode = function(actor)
    local pos = actor.Location
    local owner = actor.Owner
	actor.Destroy()
end

DestoryCliffs = function()
    local actors = Utils.Where(Map.ActorsInWorld, function(self)
        return self.Type == "cliff01" or self.Type == "cliff02" or self.Type == "cliff03" or self.Type == "cliff04" or self.Type == "cliff05" or self.Type == "cliff06" or self.Type == "cliff07" or self.Type == "cliff08" or self.Type == "ground"
    end)
    Utils.Do(actors, function(actor)
        Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 10) / 10), function()
            Explode(actor)
        end)
	end)
end

Shake = function(duration, origin, multiplier)
    duration = duration - 0.05

    local min = -1000 * multiplier
    local max = 1000 * multiplier

    local x = Utils.RandomInteger(min, max)
    local y = Utils.RandomInteger(min, max)

    -- Perform shake effect.
    Camera.Position = origin + WVec.New(x, y, 0)

    -- Recusivly call method until shaked is finished.
    if duration > 0 then
        Trigger.AfterDelay(DateTime.Seconds(0.05), function()
            Shake(duration, origin, multiplier)
        end)
    end
end

DestoryMountain = function()
    -- Remove cliffs.
    DestoryCliffs()

    -- Shake camera.
    Shake(0.3, Camera.Position, 1.0)

    -- Play explosion sound.
    Media.PlaySound("kaboom12.aud")
end

FirstNotification = function()
    Media.DisplayMessage("Intel has been received that the central cliffs have a timed bomb on it.", "HQ")
    Trigger.AfterDelay(DateTime.Minutes(1), function()
        SecondNotification()
    end)
end

SecondNotification = function()
    Media.DisplayMessage("Cliffs are are going to collapse any minute now.", "HQ")
    Trigger.AfterDelay(DateTime.Minutes(1), function()
        DestoryMountain()
    end)
end

WorldLoaded = function()
    Trigger.AfterDelay(DateTime.Minutes(Utils.RandomInteger(8, 13)), function()
        FirstNotification()
    end)
end
