Light = 0.9

turnOn = function()
	Lighting.Ambient = Light
	if Light < 0.794 and Light > 0.793 then
		POWER.Destroy()
		Trigger.AfterDelay(100, function()
			PlayMusic()
		end)
	end
	if Light < 1.01 then
		Light = Light + 0.001
		Trigger.AfterDelay(8, function()
			turnOn()
		end)
	else
		Trigger.AfterDelay(5500, function()
			turnOff()
		end)
	end
end

turnOff = function()
	Lighting.Ambient = Light
	if Light < 0.794 and Light > 0.793 then
		GettingDark = true
		POWER = Actor.Create("dummypower", true, { Location = CPos.New(0,0), Owner = Neutral })
		Trigger.AfterDelay(100, function()
			PlayMusic()
		end)
	end
	if Light > 0.55 then
		Light = Light - 0.001
		Trigger.AfterDelay(8, function()
			turnOff()
		end)
	else
		Trigger.AfterDelay(3500, function()
			GettingDark = false
			turnOn()
		end)
	end
end

PlayMusic = function()
	if GettingDark then
		Media.PlaySound("SilentNight.wav")
	else
		Media.PlaySound("JingleBells.wav")
	end
end

ChristmasEnds = function()
	if Cam1.IsInWorld then Cam1.Destroy() end
	if Cam2.IsInWorld then Cam2.Destroy() end
	WarStarts = true
	Media.DisplayMessage("The villagers ended the christmas celebration, peacetime is over!", "Santa Clause", Red)
	allactors = Creeps.GetActors()
	Trigger.AfterDelay(30, function()
		for i,v in pairs(allactors) do
			if v.HasProperty("Health") then
				v.Destroy()
			end
		end
		if Multi0 ~= nil then Wartime = Actor.Create("wartime", true, { Location = (CPos.New(0,0)), Owner = Multi0 }) end
		if Multi1 ~= nil then Wartime = Actor.Create("wartime", true, { Location = (CPos.New(0,0)), Owner = Multi1 }) end
		if Multi2 ~= nil then Wartime = Actor.Create("wartime", true, { Location = (CPos.New(0,0)), Owner = Multi2 }) end
		if Multi3 ~= nil then Wartime = Actor.Create("wartime", true, { Location = (CPos.New(0,0)), Owner = Multi3 }) end
		if Multi4 ~= nil then Wartime = Actor.Create("wartime", true, { Location = (CPos.New(0,0)), Owner = Multi4 }) end
		if Multi5 ~= nil then Wartime = Actor.Create("wartime", true, { Location = (CPos.New(0,0)), Owner = Multi5 }) end
		if Multi6 ~= nil then Wartime = Actor.Create("wartime", true, { Location = (CPos.New(0,0)), Owner = Multi6 }) end
		if Multi7 ~= nil then Wartime = Actor.Create("wartime", true, { Location = (CPos.New(0,0)), Owner = Multi7 }) end
	end)
end

ChristmasStarts = function()
	if Map.LobbyOption("difficulty") == "5min" then
		PeaceTime = DateTime.Minutes(5)
	end
	if Map.LobbyOption("difficulty") == "10min" then
		PeaceTime = DateTime.Minutes(10)
	end
	if Map.LobbyOption("difficulty") == "15min" then
		PeaceTime = DateTime.Minutes(15)
	end
	if Map.LobbyOption("difficulty") == "20min" then
		PeaceTime = DateTime.Minutes(20)
	end
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("Ho Ho Ho Its Presenttime!", "Santa Clause", Red)
	end)
	Trigger.AfterDelay(DateTime.Seconds(11), function()
		Media.DisplayMessage("You can open the presents around the trees with harvesters!", "Santa Clause", Red)
	end)
	Trigger.AfterDelay(DateTime.Seconds(17), function()
		Media.DisplayMessage("Toxic rules...\nfast build with more buildings...\nUnlimited superweapons\n\nMerry X-Mass", "Santa Clause", HSLColor.Green)
	end)
	Trigger.AfterDelay(DateTime.Seconds(22), function()
		if Multi0 ~= nil then
			Cam1 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Multi0 })
		elseif Multi1 ~= nil then
			Cam1 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Multi1 })
		elseif Multi2 ~= nil then
			Cam1 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Multi2 })
		elseif Multi3 ~= nil then
			Cam1 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Multi3 })
		else
			Cam1 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Creeps })
		end
		if Multi4 ~= nil then
			Cam2 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Multi4 })
		elseif Multi5 ~= nil then
			Cam2 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Multi5 })
		elseif Multi6 ~= nil then
			Cam2 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Multi6 })
		elseif Multi7 ~= nil then
			Cam2 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Multi7 })
		else
			Cam2 = Actor.Create("camera", true, { Location = (CPos.New(46,36)), Owner = Creeps })
		end
		Camera.Position = Cam1.CenterPosition
		Media.DisplayMessage("The villagers want to celebrate a peaceful christmas, no attacks are allowed in that time.", "Santa Clause", Red)
	end)
	Trigger.AfterDelay(PeaceTime, function()
		ChristmasEnds()
	end)
end

SetupPlayers = function()
	Neutral = Player.GetPlayer("Neutral")
	Creeps = Player.GetPlayer("Creeps")
	Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Multi6 = Player.GetPlayer("Multi6")
	Multi7 = Player.GetPlayer("Multi7")
end

function WorldLoaded()
	SetupPlayers()
	Media.StopMusic()
	ChristmasStarts()
	turnOff()
end


Red = HSLColor.Red
White = HSLColor.White

Tick = function()
	if PeaceTime > DateTime.Minutes(1) then
		TimerColor = White
	else TimerColor = Red end

	if PeaceTime == DateTime.Minutes(5) and Map.LobbyOption("difficulty") ~= "5min" then
		Media.PlaySpeechNotification( allplayers, "WarningFiveMinutesRemaining")
	end
	if PeaceTime < DateTime.Seconds(300) and PeaceTime > DateTime.Seconds(298) and Map.LobbyOption("difficulty") ~= "5min" then
		TimerColor = Red
	end
	if PeaceTime == DateTime.Minutes(4) then
		Media.PlaySpeechNotification( allplayers, "WarningFourMinutesRemaining")
	end
	if PeaceTime < DateTime.Seconds(240) and PeaceTime > DateTime.Seconds(238) then
		TimerColor = Red
	end
	if PeaceTime == DateTime.Minutes(3) then
		Media.PlaySpeechNotification( allplayers, "WarningThreeMinutesRemaining")
	end
	if PeaceTime < DateTime.Seconds(180) and PeaceTime > DateTime.Seconds(178) then
		TimerColor = Red
	end
	if PeaceTime == DateTime.Minutes(2) then
		Media.PlaySpeechNotification( allplayers, "WarningTwoMinutesRemaining")
	end
	if PeaceTime < DateTime.Seconds(120) and PeaceTime > DateTime.Seconds(118) then
		TimerColor = Red
	end
	if PeaceTime == DateTime.Minutes(1) then
		Media.PlaySpeechNotification( allplayers, "WarningOneMinuteRemaining")
	end
	if PeaceTime >= 0 then
		UserInterface.SetMissionText("Christmas time ends in: " .. Utils.FormatTime(PeaceTime) .. " minutes", TimerColor)
		PeaceTime = PeaceTime - 1
	else
		UserInterface.SetMissionText(" ", TimerColor)
	end
end
