function addTriggers()
	for i, passenger in pairs(Map.NamedActors) do
		if (passenger.HasProperty("HasPassengers")) then
			print("[TRIGGERED]")
			Trigger.OnPassengerEntered(passenger, function(transport, passenger)
				transport.Owner = passenger.Owner
			end)
			Trigger.OnPassengerExited(passenger, function(transport, passenger)
				if (not transport.HasPassengers) then
					transport.Owner = neutralGarrison
				end
			end)
		end
	end
end

function WorldLoaded()
	neutralGarrison = Player.GetPlayer("NeutralGarrison")
	addTriggers()
end