EggMonsterEntryPoints = { MonsterWaypoint }
EggSpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "easy" then
	M = { "pvice" }
	A = { "bspi" }
	R = { "reve" }
	I = { "imp" }
	D = { "pinky" }
	Ma = { "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	M = { "pvice", "pvice" }
	A = { "bspi", "bspi" }
	R = { "reve", "reve" }
	I = { "imp", "imp" }
	D = { "pinky", "pinky" }
	Ma = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "hard" then
	M = { "pvice", "pvice", "pvice", "pvice" }
	A = { "bspi", "bspi", "bspi", "bspi" }
	R = { "reve", "reve", "reve", "reve" }
	I = { "imp", "imp", "imp", "imp" }
	D = { "pinky", "pinky", "pinky", "pinky" }
	Ma = { "manc", "manc", "manc", "manc" }
end


EggWave = 0
EggWaves =
{
	{ delay = 1, units = {  } },--00
	{ delay = 1, units = {  } },--12
	{ delay = 1, units = {  } },--24
	{ delay = 1, units = {  } },--36
	{ delay = 1, units = { M, M } },--48
	{ delay = 1, units = { M, M, M, M, M } },--60
	{ delay = 1, units = { } },--112
	{ delay = 1, units = { M } },--124
	{ delay = 1, units = { A, M, M } },--136
	{ delay = 1, units = {  } },--148
	{ delay = 1, units = { A, A, A, M, M, M } },--200
	{ delay = 1, units = { } },--212
	{ delay = 1, units = { M, M } },--224
	{ delay = 1, units = { M, M, M, M } },--236
	{ delay = 1, units = { A } },--248
	{ delay = 1, units = { A, R, M, M, M, M, M } },--300
	{ delay = 1, units = { } },--312
	{ delay = 1, units = { A, R, M } },--324
	{ delay = 1, units = { } },--336
	{ delay = 1, units = {  } },--348
	{ delay = 1, units = { A, R, R, M, M, R } },--400
	{ delay = 1, units = { } },--412
	{ delay = 1, units = {  } },--424
	{ delay = 1, units = { M, M, R, R, A, A } },--436
	{ delay = 1, units = {  } },--448
	{ delay = 1, units = { A, R, M, M } },--500
	{ delay = 1, units = { M } },--512
	{ delay = 1, units = { A } },--524
	{ delay = 1, units = { A, M, M } },--536
	{ delay = 1, units = { } },--548
	{ delay = 1, units = { M, M, R, R, A, A } },--600
	{ delay = 1, units = { } },--612
	{ delay = 1, units = { I } },--624
	{ delay = 1, units = { R } },--636
	{ delay = 1, units = { M } },--648
	{ delay = 1, units = { A } },--700
	{ delay = 1, units = {  } },--712
	{ delay = 1, units = {  } },--724
	{ delay = 1, units = { I, A, M, M } },--736
	{ delay = 1, units = {  } },--748
	{ delay = 1, units = { M, A, R, I } },--800
	{ delay = 1, units = {  } },--812
	{ delay = 1, units = {  } },--824
	{ delay = 1, units = {  } },--836
	{ delay = 1, units = {  } },--848
	{ delay = 1, units = { M, R, I, I, D } },--900
	{ delay = 1, units = { } },--912
	{ delay = 1, units = { M, R } },--924
	{ delay = 1, units = {  } },--936
	{ delay = 1, units = { M, A } },--948
	{ delay = 1, units = { M, M } },--1000
	{ delay = 1, units = { D } },--1012
	{ delay = 1, units = { M, M } },--1024
	{ delay = 1, units = { M, M, M, M } },--1036
	{ delay = 1, units = {  } },--1048
	{ delay = 1, units = { A, M, M, M, M, M } },--1100
	{ delay = 1, units = {  } },--1112
	{ delay = 1, units = {  } },--1124
	{ delay = 1, units = {  } },--1136
	{ delay = 1, units = {  } },--1148
	{ delay = 1, units = { Ma, M, R, R, I, I, D } },--1200
	{ delay = 1, units = {  } },--1212
	{ delay = 1, units = {  } },--1224
	{ delay = 1, units = {  } },--1236
	{ delay = 1, units = {  } },--1248
	{ delay = 1, units = {  } }--1300
}

--Wave Commands
EggIncreaseDifficulty = function()
	local additions = { A }
	Utils.Do(EggWaves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

EggSendWave = function()
	if Egg.IsDead then
		return
	end
	EggWave = EggWave + 1
	local wave = EggWaves[EggWave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(EggMonsterEntryPoints).Location
			local target = Utils.Random(EggSpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (EggWave < #EggWaves) then
			delayFirstTeam = 12
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				EggSendWave()
				Trigger.AfterDelay(DateTime.Minutes(13), EggIncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg1
Egg1MonsterEntryPoints = { MonsterWaypoint1 }
Egg1SpawnPoints = { Waypoint1, Waypoint3, Waypoint1, Waypoint }

--Arachnotron
Egg1Wave = 0
Egg1Waves =
{
	{ delay = 1, units = { } },--00
	{ delay = 1, units = {  } },--24
	{ delay = 1, units = { M } },--48
	{ delay = 1, units = {  } },--112
	{ delay = 1, units = { M, M, M, M } },--136
	{ delay = 1, units = { A, M } },--200
	{ delay = 1, units = {  } },--224
	{ delay = 1, units = { A } },--248
	{ delay = 1, units = {  } },--312
	{ delay = 1, units = { R } },--336
	{ delay = 1, units = { M, M, R } },--400
	{ delay = 1, units = { A } },--424
	{ delay = 1, units = { A } },--448
	{ delay = 1, units = {  } },--512
	{ delay = 1, units = { M, M, A } },--536
	{ delay = 1, units = { I, M } },--600
	{ delay = 1, units = { I, M } },--624
	{ delay = 1, units = { M } },--648
	{ delay = 1, units = { I, M, M, R } },--712
	{ delay = 1, units = {  } },--736
	{ delay = 1, units = { R, A, M } },--800
	{ delay = 1, units = { I } },--824
	{ delay = 1, units = {  } },--848
	{ delay = 1, units = { D, I } },--912
	{ delay = 1, units = {  } },--936
	{ delay = 1, units = {  } },--1000
	{ delay = 1, units = {  } },--1024
	{ delay = 1, units = {  } },--1048
	{ delay = 1, units = {  } },--1112
	{ delay = 1, units = { I } },--1136
	{ delay = 1, units = { Ma, R, A, M } },--1200
	{ delay = 1, units = { I } },--1224
	{ delay = 1, units = {  } },--1248
	{ delay = 1, units = { D, I } }--1212
}

Egg1IncreaseDifficulty = function()
	local additions = { R }
	Utils.Do(Egg1Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg1SendWave = function()
	if Egg1.IsDead then
		return
	end
	Egg1Wave = Egg1Wave + 1
	local wave = Egg1Waves[Egg1Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg1MonsterEntryPoints).Location
			local target = Utils.Random(Egg1SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg1Wave < #Egg1Waves) then
			delayFirstTeam = 24
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg1SendWave()
				Trigger.AfterDelay(DateTime.Minutes(13), Egg1IncreaseDifficulty)
			end)
		end
	end)
end


-----------Egg3
Egg3MonsterEntryPoints = { MonsterWaypoint3 }
Egg3SpawnPoints = { Waypoint2, Waypoint1, Waypoint3, Waypoint0 }

Egg3Wave = 0
Egg3Waves =
{
	{ delay = 1, units = { } },--00
	{ delay = 1, units = { M } },--36
	{ delay = 1, units = {  } },--112
	{ delay = 1, units = { M, M } },--148
	{ delay = 1, units = { A, A } },--224
	{ delay = 1, units = { M, M, A } },--300
	{ delay = 1, units = {  } },--336
	{ delay = 1, units = {  } },--412
	{ delay = 1, units = { R, A, M } },--448
	{ delay = 1, units = {  } },--524
	{ delay = 1, units = { I, M } },--600
	{ delay = 1, units = {  } },--636
	{ delay = 1, units = { M, A, I, R } },--712
	{ delay = 1, units = {  } },--748
	{ delay = 1, units = {  } },--824
	{ delay = 1, units = { M } },--900
	{ delay = 1, units = { D, A, I, R } },--936
	{ delay = 1, units = {  } },--1012
	{ delay = 1, units = { M } },--1048
	{ delay = 1, units = {  } },--1124
	{ delay = 1, units = { I, M } },--1200
	{ delay = 1, units = {  } },--1236
	{ delay = 1, units = { M, A, I, R } }--1312
}

Egg3IncreaseDifficulty = function()
	local additions = { I }
	Utils.Do(Egg3Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg3SendWave = function()
	if Egg3.IsDead then
		return
	end
	Egg3Wave = Egg3Wave + 1
	local wave = Egg3Waves[Egg3Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg3MonsterEntryPoints).Location
			local target = Utils.Random(Egg3SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg3Wave < #Egg3Waves) then
			delayFirstTeam = 45
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg3SendWave()
				Trigger.AfterDelay(DateTime.Minutes(13), Egg3IncreaseDifficulty)
			end)
		end
	end)
end



-----------Egg5
Egg5MonsterEntryPoints = { MonsterWaypoint5 }
Egg5SpawnPoints = { Waypoint3, Waypoint2, Waypoint1, Waypoint }

Egg5Wave = 0
Egg5Waves =
{
	{ delay = 1, units = { } },--00
	{ delay = 1, units = { M } },--48
	{ delay = 1, units = { M, M, M } },--136
	{ delay = 1, units = { A } },--224
	{ delay = 1, units = { R, A, M } },--312
	{ delay = 1, units = { R } },--400
	{ delay = 1, units = { A } },--448
	{ delay = 1, units = { A } },--536
	{ delay = 1, units = { I, R } },--624
	{ delay = 1, units = { R, A, M } },--712
	{ delay = 1, units = { I, D } },--800
	{ delay = 1, units = { A, R, M } },--848
	{ delay = 1, units = { M } },--936
	{ delay = 1, units = { I, R } },--1024
	{ delay = 1, units = { R, A } },--1112
	{ delay = 1, units = { I, D } },--1200
	{ delay = 1, units = { A, R, M } },--1248
	{ delay = 1, units = { Ma, D, M } }--1336
}


Egg5IncreaseDifficulty = function()
	local additions = { D }
	Utils.Do(Egg5Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg5SendWave = function()
	if Egg5.IsDead then
		return
	end
	Egg5Wave = Egg5Wave + 1
	local wave = Egg5Waves[Egg5Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg5MonsterEntryPoints).Location
			local target = Utils.Random(Egg5SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg5Wave < #Egg5Waves) then
			delayFirstTeam = 60
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg5SendWave()
				Trigger.AfterDelay(DateTime.Minutes(13), Egg5IncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg7
Egg7MonsterEntryPoints = { MonsterWaypoint7 }
Egg7SpawnPoints = { Waypoint1, Waypoint2, Waypoint, Waypoint3 }

Egg7Wave = 0
Egg7Waves =
{
	{ delay = 1, units = { } },--00
	{ delay = 1, units = { M } },--100
	{ delay = 1, units = { A } },--200
	{ delay = 1, units = { R } },--300
	{ delay = 1, units = { R, A, M } },--400
	{ delay = 1, units = {  } },--500
	{ delay = 1, units = { I } },--600
	{ delay = 1, units = { I } },--700
	{ delay = 1, units = { A, M, I, M, M } },--800
	{ delay = 1, units = { A, M, M, M } },--900
	{ delay = 1, units = { A, I, M, R, D } },--1000
	{ delay = 1, units = { D, A, M, M, M } },--1100
	{ delay = 1, units = { Ma, I, M } },--1200
	{ delay = 1, units = { D, A, M, M, M } },--1300

}

Egg7IncreaseDifficulty = function()
	local additions = { Ma }
	Utils.Do(Egg7Waves, function(wave)
		wave.units[#wave.units + 20] = Utils.Random(additions)
	end)
end

Egg7SendWave = function()
	if Egg7.IsDead then
		return
	end
	Egg7Wave = Egg7Wave + 1
	local wave = Egg7Waves[Egg7Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg7MonsterEntryPoints).Location
			local target = Utils.Random(Egg7SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg7Wave < #Egg7Waves) then
			delayFirstTeam = 90
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg7SendWave()
				Trigger.AfterDelay(DateTime.Minutes(13), Egg7IncreaseDifficulty)
			end)
		end
	end)
end

-----------AlienSpawns
AlienMonsterEntryPoints = { MotherShipWaypoint }
AlienSpawnPoints = { Waypoint2, Waypoint, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mechwarrior = { "mechwarrior", "mechwarrior", "mechwarrior", "mechwarrior" }
	Exciter = { "exciter", "exciter", "exciter" }
	Tripod = { "tripod", "tripod", "tripod", "tripod" }
end

AlienWave = 0
AlienWaves =
{
	{ delay = 1, units = { Tripod } },
	{ delay = 1, units = { Mechwarrior } },
	{ delay = 1, units = { Exciter, Exciter } },
	{ delay = 1, units = { Mechwarrior, Mechwarrior } },
	{ delay = 1, units = { Exciter, Exciter, Exciter, Exciter } },
	{ delay = 1, units = { Tripod, Tripod } },
	{ delay = 1, units = { Tripod } },
	{ delay = 1, units = { Mechwarrior } },
	{ delay = 1, units = { Exciter, Exciter } },
	{ delay = 1, units = { Mechwarrior, Mechwarrior } },
	{ delay = 1, units = { Exciter, Exciter, Exciter, Exciter } },
	{ delay = 1, units = { Tripod, Tripod } }
}

SendAlienUnits = function(entryCell, unitTypes, targetCell)
	Reinforcements.Reinforce(Aliens, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		a.AttackMove(targetCell)
		Trigger.OnIdle(a, function(a)
			a.Hunt()
		end)
	end)
end

AlienIncreaseDifficulty = function()
	local additions = { ExoMech, Exciter, ExoMech, Exciter, Tripod, Tripod }
	Utils.Do(AlienWaves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

AlienSendWave = function()
	if AlienMothership.IsDead then
		return
	end
	AlienWave = AlienWave + 1
	local wave = AlienWaves[AlienWave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(AlienMonsterEntryPoints).Location
			local target = Utils.Random(AlienSpawnPoints).Location
			SendAlienUnits(entry, units, target)
		end)
		if (AlienWave < #AlienWaves) then
			delayFirstTeam = 40
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				AlienSendWave()
				Trigger.AfterDelay(DateTime.Minutes(7), AlienIncreaseDifficulty)
			end)
		end
	end)
end
--hard difficulty check
MothershipChrono = function()
	if Map.LobbyOption("difficulty") == "easy" then
		EggsDestroyed()
		MothershipDestroyed()
		--CratePickup()
	elseif Map.LobbyOption("difficulty") == "normal" then
		EggsDestroyed()
		MothershipDestroyed()
	elseif Map.LobbyOption("difficulty") == "hard" then
		EggsDestroyed()
		Media.DisplayMessage("Incomming mothership detected...")
		Trigger.AfterDelay(DateTime.Seconds(7), function()
			Media.PlaySound("mothershipdeployed.aud")
			Trigger.AfterDelay(DateTime.Seconds(3), function()
				Media.PlaySound("Chrono.aud")
				Trigger.AfterDelay(DateTime.Seconds(4), function()
					Lightning()
					local delay = Utils.RandomInteger(20, 10)
					Lighting.Flash("LightningStrike", delay)
					Lighting.Flash("LightningStrike", delay)
					ChronoShift = Actor.Create(Mothership, true, { Owner = Aliens, Location = MotherShipWaypoint.Location })
					Trigger.AfterDelay(DateTime.Seconds(0.5), function()
						ChronoShift.Kill()
						AlienMothership = Actor.Create(Mothership, true, { Owner = Aliens, Location = MotherShipWaypoint.Location })
						--Smoke1 = Actor.Create(Smoke, true, { Owner = Neutral, Location = MotherShipWaypoint.Location })
						--Smoke2 = Actor.Create(Smoke, true, { Owner = Neutral, Location = WaypointMiddle.Location })
						Trigger.AfterDelay(DateTime.Seconds(5), function()
							AlienSendWave()
							Trigger.OnKilled(AlienMothership, MothershipDestroyed) 
						end)
					end)
				end)
			end)
		end)
	end
end

--Game Over check
MissionOverCheckMonster = { MonsterMissionAccomplished }
MissionOverCheckAlien = { AlienMissionAccomplished }

EggsDestroyed = function()
	Utils.Do(MissionOverCheckMonster, function(a)
		if not a.IsDead and a.Owner == Monsters then
			a.Destroy()
		end
	end)
end

MothershipDestroyed = function()
	if Map.LobbyOption("difficulty") == "hard" then
		Actor.Create(Weapons, true, { Owner = Aliens, Location = WaypointMiddle.Location })
	end
	Utils.Do(MissionOverCheckAlien, function(a)
		if not a.IsDead and a.Owner == Aliens then
			a.Destroy()
		end
	end)
end

--AI Behavior
SendUnits = function(entryCell, unitTypes, targetCell)
	Reinforcements.Reinforce(Monsters, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		a.AttackMove(targetCell)
		Trigger.OnIdle(a, function(a)
			a.Hunt()
		end)
	end)
end

--eggs
Eggs = { Egg, Egg1, Egg3, Egg5, Egg7 }
Fire = "boxes01"
Mothership = "mothership"
Smoke = "flare"
TechCrate = "techcrate"
Weapons = "weaponscrate"
WorldLoaded = function()
--factions
	Neutral = Player.GetPlayer("Neutral")
	Monsters = Player.GetPlayer("Monsters")
	Aliens = Player.GetPlayer("Aliens")
	Media.DisplayMessage("Destroy the Egg spawns in the middle!")
	Trigger.OnAllRemovedFromWorld(Eggs, function()
		MothershipChrono()
	end)
--egg spawn commands
	EggSendWave()
	Egg1SendWave()
	Egg3SendWave()
	Egg5SendWave()
	Egg7SendWave()

--endless spawn trigger
	Trigger.AfterDelay(DateTime.Minutes(14), function()
		EggIncreaseDifficulty()
		Egg1IncreaseDifficulty()
		Egg3IncreaseDifficulty()
		Egg5IncreaseDifficulty()
		Egg7IncreaseDifficulty()
	end)

--weather and effects
	local delay = Utils.RandomInteger(20, 10)
	Lighting.Flash("LightningStrike", delay)
	Lighting.Flash("LightningStrike", delay)
	Media.PlaySound("thunder3.aud")
end
Lightning = function() 
	local delay = Utils.RandomInteger(20, 10)
	Lighting.Flash("LightningStrike", delay)
	Lighting.Flash("LightningStrike", delay)
	Tick = function()
		if (Utils.RandomInteger(1, 200) == 10) then
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Trigger.AfterDelay(delay, function()
				Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
			end)
		end
		if (Utils.RandomInteger(1, 200) == 10) then
			Media.PlaySound("thunder-ambient.aud")
		end
	end
end

