OrdosReinf1 = { "trooper", "trooper", "trooper", "light_inf", "light_inf", "light_inf", "raider" }
OrdosReinf2 = { "quad", "combat_tank_o", "combat_tank_o", "stealth_raider" }
OrdosReinf3 = { "siege_tank", "siege_tank", "deviator" }
OrdosReinf4 = { "harvester", "combat_tank_o" }

MercenaryReinf1 = { "light_inf", "light_inf", "trooper", "trooper", "sniper", "siege_tank" }
MercenaryReinf2 = { "quad", "quad", "combat_tank_m", "combat_tank_m", "combat_tank_m" }
MercenaryReinf3 = { "bomb_buggy", "bomb_buggy" }

CorrinoReinf = { "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_c", "combat_tank_c" }

OrdosReinf1Locations = { ordos_reinf1_entry.Location, ordos_reinf1_waypoint.Location }
OrdosReinf2Locations = { ordos_reinf2_entry.Location, ordos_reinf2_waypoint.Location }
OrdosReinf3Locations = { ordos_reinf3_entry.Location, ordos_reinf3_waypoint.Location }

MercenaryReinf1Locations = { mercenary_reinf1_entry.Location, mercenary_reinf1_waypoint.Location }
MercenaryReinf2Locations = { mercenary_reinf2_entry.Location, mercenary_reinf2_waypoint.Location }

CorrinoReinfLocations = { corrino_reinf_entry.Location, corrino_reinf_waypoint.Location }

atr_barr1		= { name = "barracks",			pos = CPos.New(98,  9), prize =  225,	exists = true }
atr_barr2		= { name = "barracks",			pos = CPos.New(65,  2), prize =  225,	exists = true }
atr_ref1		= { name = "refinery",			pos = CPos.New(51,  2), prize = 1500,	exists = true }
atr_ref2		= { name = "refinery",			pos = CPos.New(69, 14), prize = 1500,	exists = true }
atr_ref3		= { name = "refinery",			pos = CPos.New(58, 14), prize = 1500,	exists = true }
atr_palace		= { name = "palace",			pos = CPos.New(97,  2), prize = 1600,	exists = true }
atr_outpost		= { name = "outpost",			pos = CPos.New(89,  9), prize =  750,	exists = true }
atr_starport	= { name = "starport",			pos = CPos.New(62, 11), prize = 1500,	exists = true }
atr_hfac1		= { name = "heavy_factory",		pos = CPos.New(68,  6), prize = 1000,	exists = true }
atr_hfac2		= { name = "heavy_factory",		pos = CPos.New(55,  8), prize = 1000,	exists = true }
atr_lfac1		= { name = "light_factory",		pos = CPos.New(72, 10), prize =  500,	exists = true }
atr_lfac2		= { name = "light_factory",		pos = CPos.New(56,  2), prize =  500,	exists = true }
atr_rpad		= { name = "repair_pad",		pos = CPos.New(72,  6), prize =  800,	exists = true }
atr_ix			= { name = "research_centre",	pos = CPos.New(68,  9), prize = 1000,	exists = true }
atr_wind1		= { name = "wind_trap",			pos = CPos.New(89,  2), prize =  255,	exists = true }
atr_wind2		= { name = "wind_trap",			pos = CPos.New(91,  2), prize =  255,	exists = true }
atr_wind3		= { name = "wind_trap",			pos = CPos.New(92,  9), prize =  255,	exists = true }
atr_wind4		= { name = "wind_trap",			pos = CPos.New(94,  9), prize =  255,	exists = true }
atr_wind5		= { name = "wind_trap",			pos = CPos.New(59,  2), prize =  255,	exists = true }
atr_wind6		= { name = "wind_trap",			pos = CPos.New(61,  2), prize =  255,	exists = true }
atr_wind7		= { name = "wind_trap",			pos = CPos.New(63,  2), prize =  255,	exists = true }
atr_wind8		= { name = "wind_trap",			pos = CPos.New(67,  2), prize =  255,	exists = true }
atr_wind9		= { name = "wind_trap",			pos = CPos.New(69,  2), prize =  255,	exists = true }
atr_wind10		= { name = "wind_trap",			pos = CPos.New(71,  2), prize =  255,	exists = true }
atr_wind11		= { name = "wind_trap",			pos = CPos.New(73,  2), prize =  255,	exists = true }
atr_wind12		= { name = "wind_trap",			pos = CPos.New(65, 11), prize =  255,	exists = true }
atr_wind13		= { name = "wind_trap",			pos = CPos.New(65,  7), prize =  255,	exists = true }
atr_wind14		= { name = "wind_trap",			pos = CPos.New(63,  7), prize =  255,	exists = true }
atr_wind15		= { name = "wind_trap",			pos = CPos.New(61,  7), prize =  255,	exists = true }
atr_wind16		= { name = "wind_trap",			pos = CPos.New(59,  7), prize =  255,	exists = true }

har_barr		= { name = "barracks",			pos = CPos.New(89, 73), prize =  225,	exists = true }
har_ref1		= { name = "refinery",			pos = CPos.New(88, 77), prize = 1500,	exists = true }
har_ref2		= { name = "refinery",			pos = CPos.New(96, 43), prize = 1500,	exists = true }
har_outpost		= { name = "outpost",			pos = CPos.New(97, 73), prize =  750,	exists = true }
har_starport	= { name = "starport",			pos = CPos.New(94, 57), prize = 1500,	exists = true }
har_hfac		= { name = "heavy_factory",		pos = CPos.New(97, 64), prize = 1000,	exists = true }
har_lfac		= { name = "light_factory",		pos = CPos.New(97, 61), prize =  500,	exists = true }
har_htec		= { name = "high_tech_factory",	pos = CPos.New(97, 52), prize = 1150,	exists = true }
har_rpad		= { name = "repair_pad",		pos = CPos.New(97, 57), prize =  800,	exists = true }
har_ix			= { name = "research_centre",	pos = CPos.New(97, 68), prize = 1000,	exists = true }
har_wind1		= { name = "wind_trap",			pos = CPos.New(92, 77), prize =  255,	exists = true }
har_wind2		= { name = "wind_trap",			pos = CPos.New(94, 77), prize =  255,	exists = true }
har_wind3		= { name = "wind_trap",			pos = CPos.New(94, 73), prize =  255,	exists = true }
har_wind4		= { name = "wind_trap",			pos = CPos.New(92, 73), prize =  255,	exists = true }
har_wind5		= { name = "wind_trap",			pos = CPos.New(94, 69), prize =  255,	exists = true }
har_wind6		= { name = "wind_trap",			pos = CPos.New(94, 65), prize =  255,	exists = true }
har_wind7		= { name = "wind_trap",			pos = CPos.New(94, 61), prize =  255,	exists = true }
har_wind8		= { name = "wind_trap",			pos = CPos.New(95, 53), prize =  255,	exists = true }
har_wind9		= { name = "wind_trap",			pos = CPos.New(92, 61), prize =  255,	exists = true }

AtreidesBaseBuildings =
{ 
	atr_barr1,
	atr_barr2,
	atr_ref1,
	atr_ref2,
	atr_ref3,
	atr_palace,
	atr_outpost,
	atr_starport,
	atr_hfac1,
	atr_hfac2,
	atr_lfac1,
	atr_lfac2,
	atr_rpad,
	atr_ix,
	atr_wind1,
	atr_wind2,
	atr_wind3,
	atr_wind4,
	atr_wind5,
	atr_wind6,
	atr_wind7,
	atr_wind8,
	atr_wind9,
	atr_wind10,
	atr_wind11,
	atr_wind12,
	atr_wind13,
	atr_wind14,
	atr_wind15,
	atr_wind16
}

AtreidesInitialBase =
{ 
	atreides_barr1,
	atreides_barr2,
	atreides_ref1,
	atreides_ref2,
	atreides_ref3,
	atreides_palace,
	atreides_outpost,
	atreides_starport,
	atreides_hfac1,
	atreides_hfac2,
	atreides_lfac1,
	atreides_lfac2,
	atreides_rpad,
	atreides_ix,
	atreides_wind1,
	atreides_wind2,
	atreides_wind3,
	atreides_wind4,
	atreides_wind5,
	atreides_wind6,
	atreides_wind7,
	atreides_wind8,
	atreides_wind9,
	atreides_wind10,
	atreides_wind11,
	atreides_wind12,
	atreides_wind13,
	atreides_wind14,
	atreides_wind15,
	atreides_wind16
}

HarkonnenBaseBuildings =
{ 
	har_barr,
	har_ref1,
	har_ref2,
	har_outpost,
	har_starport,
	har_hfac,
	har_lfac,
	har_htec,
	har_rpad,
	har_ix,
	har_wind1,
	har_wind2,
	har_wind3,
	har_wind4,
	har_wind5,
	har_wind6,
	har_wind7,
	har_wind8,
	har_wind9
}

HarkonnenInitialBase =
{ 
	harkonnen_barr,
	harkonnen_ref1,
	harkonnen_ref2,
	harkonnen_outpost,
	harkonnen_starport,
	harkonnen_hfac,
	harkonnen_lfac,
	harkonnen_htec,
	harkonnen_rpad,
	harkonnen_ix,
	harkonnen_wind1,
	harkonnen_wind2,
	harkonnen_wind3,
	harkonnen_wind4,
	harkonnen_wind5,
	harkonnen_wind6,
	harkonnen_wind7,
	harkonnen_wind8,
	harkonnen_wind9
}

SetDestroyedBuildings = function(init, buildings)
	for i,v in ipairs(init) do
		Trigger.OnCapture(v, function()
			Trigger.AfterDelay(0, function()
				Trigger.OnRemovedFromWorld(v, function()
					buildings[i].exists = false
				end)
			end)
		end)
		Trigger.OnKilled(v, function()
			buildings[i].exists = false
		end)
	end
end

GetBuilding = function(player, buildings, conyard)
	for i,v in ipairs(buildings) do
		BuildBase(player, v, conyard)
	end
end

BuildBase = function(player, building, conyard)
	if not building.exists then
		BuildBuilding(player, building, conyard)
		return
	end

	Trigger.AfterDelay(DateTime.Seconds(10), function() BuildBase(player, building, conyard) end)
end

BuildBuilding = function(player, building, conyard)
	Trigger.AfterDelay(Actor.BuildTime(building.name) * 2, function()
		if conyard.IsDead or conyard.Owner ~= player then
			Trigger.AfterDelay(DateTime.Seconds(10), function() BuildBase(player, building, conyard) end)
			return
		end

		building.exists = true

		local actor = Actor.Create(building.name, true, { Owner = player, Location = building.pos })
		player.Cash = player.Cash - building.prize

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnKilled(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == player and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
		end)
		Trigger.AfterDelay(DateTime.Seconds(10), function() BuildBase(player, building, conyard) end)
	end)
end

SendCargoVehicle = function()
	if not Multi0.IsBot then
		local CargoVehicle = Actor.Create("cargo_vehicle", true, { Owner = Multi0, Location = CargoVehicleEntry.Location })

		CargoVehicle.Move(CargoVehicleWaypoint.Location)
		if Multi0.IsLocalPlayer then
			Media.DisplayMessage("A Cargo Vehicle has arrived.", "Mentat")
		end
	else
		Multi0.Cash = Multi0.Cash + 2000
	end

	Trigger.AfterDelay(DateTime.Seconds(60), SendCargoVehicle)
end

SendReinforcement = function(waypoint, transport, units, side, t, check, message)
	Trigger.AfterDelay(DateTime.Seconds(t), function()
		if check and check() then
			return
		end

		Reinforcements.ReinforceWithTransport(side, transport, units, waypoint, { waypoint[1] })
		Media.PlaySpeechNotification(side, "Reinforce")
		if side.IsLocalPlayer and message ~= nil then
			Trigger.AfterDelay(DateTime.Seconds(5), function()
				Media.DisplayMessage(message, "Mentat")
			end)
		end
	end)
end

SendReinforcementRepeating = function(waypoint, transport, units, side, t, check, message)
	Trigger.AfterDelay(DateTime.Seconds(t), function()
		if check and check() then
			return
		end

		Reinforcements.ReinforceWithTransport(side, transport, units, waypoint, { waypoint[1] })
		Media.PlaySpeechNotification(side, "Reinforce")
		if side.IsLocalPlayer and message ~= nil then
			Trigger.AfterDelay(DateTime.Seconds(5), function()
				Media.DisplayMessage(message, "Mentat")
			end)
		end

		SendReinforcementRepeating(waypoint, transport, units, side, t, check)
	end)
end

SetPlayerCash = function()
	Multi1.Cash = Multi1.Cash + 3000
	Multi2.Cash = Multi2.Cash + 3000
	Multi3.Cash = Multi3.Cash - 2000
	Multi4.Cash = Multi4.Cash - 1000
	Multi5.Cash = Multi5.Cash - 1000

	-- If both players are human, double the AI cash.
	if not Multi0.IsBot and not Multi1.IsBot then
		Multi2.Cash = Multi2.Cash * 2
		Multi3.Cash = Multi3.Cash * 2
		Multi4.Cash = Multi4.Cash * 2
		Multi5.Cash = Multi5.Cash * 2
	end
end

SetStartingUnits = function(support)
	if support == "light" or support == "medium" then
		mercenary_rifle6.Destroy()
		mercenary_rifle7.Destroy()
		mercenary_trooper4.Destroy()
		mercenary_trooper5.Destroy()
		mercenary_trooper6.Destroy()
		mercenary_engineer1.Destroy()
		mercenary_sniper1.Destroy()
		mercenary_raider3.Destroy()
		mercenary_quad3.Destroy()
		mercenary_tank2.Destroy()
		mercenary_tank3.Destroy()
		mercenary_siege1.Destroy()

		ordos_rifle8.Destroy()
		ordos_rifle9.Destroy()
		ordos_rifle10.Destroy()
		ordos_trooper2.Destroy()
		ordos_trooper3.Destroy()
		ordos_trooper4.Destroy()
		ordos_quad2.Destroy()
		ordos_stealth_raider1.Destroy()
		ordos_tank2.Destroy()
		ordos_tank3.Destroy()
		ordos_siege3.Destroy()
		ordos_carryall.Destroy()
	end
	if support == "light" then
		mercenary_rifle1.Destroy()
		mercenary_rifle5.Destroy()
		mercenary_trooper2.Destroy()
		mercenary_quad1.Destroy()
		mercenary_tank1.Destroy()

		ordos_rifle3.Destroy()
		ordos_rifle4.Destroy()
		ordos_rifle5.Destroy()
		ordos_rifle6.Destroy()
		ordos_raider1.Destroy()
		ordos_siege2.Destroy()
		ordos_devi1.Destroy()
	end
end

GetOrdosPlayer = function()
	if Multi1.IsBot then
		return Ordos
	end

	return Multi1
end

OrdosSetup = function()
	if not Multi1.IsBot then
		for i,v in ipairs(Ordos.GetActors()) do
			v.Owner = Multi1
		end
	end
end

MercenarySetup = function()
	if not Multi0.IsBot then
		for i,v in ipairs(Mercenaries.GetActors()) do
			v.Owner = Multi0
		end
	else
		MercenaryReinf3 = { "combat_tank_m", "combat_tank_m" }

		mercenary_sniper1.Move(AISniper1Waypoint.Location)
		mercenary_sniper2.Move(AISniper2Waypoint.Location)
	end
end

InitObjectives = function()
	MercenaryObjective	= Multi0.AddPrimaryObjective("Ensure the victory of Ordos.")
	OrdosObjective		= Multi1.AddPrimaryObjective("Destroy the Atreides, Harkonnen and Imperial Forces.")
	CorrinoObjective	= Multi2.AddPrimaryObjective("Destroy the Ordos forces and their Mercenaries.")
	Atreides2Objective	= Multi3.AddPrimaryObjective("Destroy the Ordos forces and their Mercenaries.")
	HarkonnenObjective	= Multi4.AddPrimaryObjective("Destroy the Ordos forces and their Mercenaries.")
	Atreides1Objective	= Multi5.AddPrimaryObjective("Destroy the Ordos forces and their Mercenaries.")

	Trigger.OnPlayerLost(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "Lose")
		end)
	end)
	Trigger.OnPlayerWon(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "Win")
		end)
	end)
end

Tick = function()
	if Multi0.HasNoRequiredUnits() then
		Multi0.MarkFailedObjective(MercenaryObjective)
	end

	if Multi1.HasNoRequiredUnits() then
		Multi0.MarkFailedObjective(MercenaryObjective)
		Multi1.MarkFailedObjective(OrdosObjective)
		Multi2.MarkCompletedObjective(CorrinoObjective)
		Multi3.MarkCompletedObjective(Atreides2Objective)
		Multi4.MarkCompletedObjective(HarkonnenObjective)
		Multi5.MarkCompletedObjective(Atreides1Objective)
	end

	if Multi2.HasNoRequiredUnits() and  Multi3.HasNoRequiredUnits() and Multi4.HasNoRequiredUnits() and Multi5.HasNoRequiredUnits() then
		Multi0.MarkCompletedObjective(MercenaryObjective)
		Multi1.MarkCompletedObjective(OrdosObjective)
		Multi2.MarkFailedObjective(CorrinoObjective)
		Multi3.MarkFailedObjective(Atreides2Objective)
		Multi4.MarkFailedObjective(HarkonnenObjective)
		Multi5.MarkFailedObjective(Atreides1Objective)
	end
end

WorldLoaded = function()
	Multi0		= Player.GetPlayer("Multi0")
	Multi1		= Player.GetPlayer("Multi1")
	Multi2		= Player.GetPlayer("Multi2")
	Multi3		= Player.GetPlayer("Multi3")
	Multi4		= Player.GetPlayer("Multi4")
	Multi5		= Player.GetPlayer("Multi5")
	Ordos		= Player.GetPlayer("Ordos")
	Mercenaries	= Player.GetPlayer("Mercenaries")
	Emparor		= Player.GetPlayer("Emparor")
	Harkonnen	= Player.GetPlayer("Harkonnen")
	Atreides	= Player.GetPlayer("Atreides")

	SetStartingUnits(Map.LobbyOption("units"))

	SetDestroyedBuildings(AtreidesInitialBase, AtreidesBaseBuildings)
	SetDestroyedBuildings(HarkonnenInitialBase, HarkonnenBaseBuildings)

	GetBuilding(Multi5, AtreidesBaseBuildings, atreides_cyard)
	GetBuilding(Multi4, HarkonnenBaseBuildings, harkonnen_cyard)

	Trigger.OnCapture(atreides_cyard, atreides_cyard.Kill)	
	Trigger.OnCapture(harkonnen_cyard, harkonnen_cyard.Kill)

	InitObjectives()
	SetPlayerCash()

	SendReinforcement(OrdosReinf1Locations, "carryall.reinforce", OrdosReinf1, GetOrdosPlayer(), 120, false, "Reinforcements have arrived.")
	SendReinforcement(OrdosReinf2Locations, "carryall.reinforce", OrdosReinf2, GetOrdosPlayer(), 150, false, "Reinforcements have arrived.")
	SendReinforcement(OrdosReinf3Locations, "carryall.reinforce", OrdosReinf3, GetOrdosPlayer(), 200, false, "Reinforcements have arrived.")
	SendReinforcement(OrdosReinf3Locations, "carryall.reinforce", OrdosReinf4, Multi1, 100, false, "Reinforcements have arrived.")

	OrdosSetup()
	MercenarySetup()

	local merc_hfac_dead = function() return mercenary_hfac.IsDead end
	SendReinforcementRepeating(MercenaryReinf2Locations, "carryall.reinforce", MercenaryReinf3, Multi0, 300, merc_hfac_dead, "Bomb buggies have arrived.")

	local merc_starport_dead = function() return mercenary_starport.IsDead end
	SendReinforcement(MercenaryReinf1Locations, "frigate", MercenaryReinf2, Multi0, 120, merc_starport_dead, "Starport reinforcements have arrived.")
	SendReinforcementRepeating(MercenaryReinf1Locations, "frigate", MercenaryReinf1, Multi0, 240, merc_starport_dead, "Starport reinforcements have arrived.")
	Trigger.AfterDelay(DateTime.Minutes(2), function()
		SendReinforcementRepeating(MercenaryReinf1Locations, "frigate", MercenaryReinf2, Multi0, 240, merc_starport_dead, "Starport reinforcements have arrived.")
	end)

	local corr_starport_dead = function() return corrino_starport.IsDead or corrino_starport.Owner ~= Multi2 end
	SendReinforcementRepeating(CorrinoReinfLocations, "frigate", CorrinoReinf, Multi2, 240, corr_starport_dead, nil)

	Trigger.AfterDelay(DateTime.Seconds(60), SendCargoVehicle)
end
