local trees = {"t02", "t06", "t10", "t11", "t13", "t14", "t15"}
local map = {}
local w = 90
local h = 90
local Neutral = Player.GetPlayer("Neutral")

-- Based on Murto's experiment with forest generation
-- Main goal is to make it playable (and practice programming)

function ParseTile(x, y, offset)
  local areaWeight = 0
  for tileX = x - offset, x + offset do
    for tileY = y - offset, y + offset do
      if (tileX > 0 and tileY > 0) and (tileX < w and tileY < h) then
        if((tileX ~= x) or (tileY ~= y))then
          if map[tileX][tileY] ~= 2 then
            areaWeight = areaWeight + map[tileX][tileY]
          end
        end
      end
    end
  end
  return areaWeight
end

function ParseTileGold(x, y, offset)
  local areaWeight = 0
  for tileX = x - offset, x + offset do
    for tileY = y - offset, y + offset do
      if (tileX > 0 and tileY > 0) and (tileX < w and tileY < h) then
        if((tileX ~= x) or (tileY ~= y))then
            areaWeight = areaWeight + map[tileX][tileY]
        end
      end
    end
  end
  return areaWeight
end

function FillCorners()
  Media.Debug("Filling corners with trees.")
  for x=1,w do
    for y=1,h do
      -- I am more than sure one can make this shorter, but i made it to be sure in everything.
      if ((h >= y) and (y >= 1)) and x == 1 then
        map[x][y] = 1
      elseif y == 1 and ((w >= x) and (x >= 1)) then
        map[x][y] = 1
      elseif x == w and ((h >= y) and (y >= 1)) then
        map[x][y] = 1
      elseif y == h and ((w >= x) and (x >= 1)) then
        map[x][y] = 1
      end
    end
  end
end

function ClearArea(x, y, offset)
  for tileX = x - offset, x + offset do
    for tileY = y - offset, y + offset do
      if map[tileX][tileY] == 1 then
        map[tileX][tileY] = 0
      end
    end
  end
end

function ClearPlayerSpawns()
  -- Those magic numbers are coordinates of mpspawn actors found in map.yaml
  Media.Debug("Clearing spawns.")
  ClearArea(10, 10, 4)
  ClearArea(10, 10, 4)
  ClearArea(10, 80, 4)
  ClearArea(10, 80, 4)
  ClearArea(80, 80, 4)
  ClearArea(80, 80, 4)
  ClearArea(80, 10, 4)
  ClearArea(80, 10, 4)
end

function Blanking()
  for x= (w / 2), (w / 2 + 1) do
    for y=5, h-5 do
      map[x][y] = 0
    end
  end
  -- Magic numbers... Those magic numbers are coordinates of mpspawn actors found in map.yaml
  for x = 10, 11 do -- This 11 is here so we make 2 tiles blank space
    for y = 5, h - 5 do
      map[x][y] = 0
    end
  end
  for x = 80, 81 do -- This 81 is here so we make 2 tiles blank space
    for y = 5, h - 5 do
      map[x][y] = 0
    end
  end
  -- Here comes vertical blanking so we can connect all the spawns together
  for x = 10, w - 10 do -- Again, spawn cordinates
    for y = 10, 11 do -- And again, coordinates, coordinates+1
      map[x][y] = 0
    end
  end
  for x = 10, w - 10 do -- Again, spawn cordinates
    for y = 80, 81 do -- And again, coordinates, coordinates+1
      map[x][y] = 0
    end
  end
end

function SmoothMap()
  Media.Debug("Smoothing map.")
  for x=2, w-2 do
    for y=2, h-2 do
      local areaWeight = ParseTile(x, y, 1)
      if(areaWeight >= 4 and map[x][y] == 1) then
        map[x][y] = 1
      elseif(areaWeight >= 5 and map[x][y] == 0) then
        map[x][y] = 1
      else
        map[x][y] = 0
      end
    end
  end
end

function CreateVisual(x,y)
  if map[x][y] == 1 then
    local actor = Actor.Create(Utils.Random(trees), true, {
        Owner = Neutral,
        Location = CPos.New(x, y)
      })
  elseif map[x][y] == 2 then
    local actor = Actor.Create(Utils.Random({"mine", "gmine"}), true, {
        Owner = Neutral,
        Location = CPos.New(x, y)
      })
  end
end

function PlaceTreasure()
  for x = 20, w-20 do
    for y = 20, h-20 do
      if map[x][y] == 0 then
        local weight = ParseTile(x, y, 1)
        local bigWeight = ParseTile(x, y, 7)
        if weight >= 4 then
          map[x][y] = 2
        elseif bigWeight == 0 then
          if ParseTileGold(x, y, 4) == 0 then
            map[x][y] = 2
          end
        end
      end
    end
  end
end

function RenderMap()
  Media.Debug("Rendering.")
  for x=1, w do
    for y=1, h do
      if map[x][y] == 1 or map[x][y] == 2 then
        CreateVisual(x,y)
      end
    end
  end
end

function WorldGenerationSequence()
  Media.Debug("Starting world generation sequence!")
  Media.Debug("Randomly filling map")
  for x=1,w do
    map[x] = {}
    for y=1,h do
      map[x][y] = Utils.RandomInteger(0, 2)
    end
  end
  ClearPlayerSpawns()
  Blanking()
  SmoothMap()
  SmoothMap()
  FillCorners()
  PlaceTreasure()
  RenderMap()
end

WorldLoaded = function()
  Trigger.AfterDelay(0.1, WorldGenerationSequence)
end