
Power = {}
Effect = {}

HealingUses = 0
Power.Healing = function(actor)
	HealingUses = HealingUses + 1
	if HealingUses < 10 then
		Effect.Heal1Location(actor.Location,actor.Owner)
	elseif HealingUses < 20 then
		Effect.Heal2Location(actor.Location,actor.Owner)
	elseif HealingUses < 30 then
		Effect.Heal3Location(actor.Location,actor.Owner)
	else
		Effect.Heal4Location(actor.Location,actor.Owner)
	end
	--Actor.CreateEffectOn(actor, "heal") -- Not working needs to be fixed
end

Power.AtomicBreath = function(actor)
	local locations = LocationsFromLocationDistanceFacingSpread(actor.Location, 5, Actor.Facing(actor), 1, 2)
	local delay = 0
	for i, location in ipairs(locations) do
		OpenRA.RunAfterDelay(delay, function()
			Effect.FlameLocation(location,actor.Owner)
		end)
		delay = delay + 0.5
	end
	PlayRandomGodzillaSound()
end

Power.AtomicEnergy = function(actor)
	Effect.NukeLocation(actor.Location, actor.Owner)
	PlayRandomGodzillaSound()
end

Power.CallForHelp = function(actor)
	local toSpawn = 5
	local limit = 30
	while toSpawn > 0 and limit > 0 do
		local x = OpenRA.GetRandomInteger(actor.Location.X - 10, actor.Location.X + 10)
		local y = OpenRA.GetRandomInteger(actor.Location.Y - 10, actor.Location.Y + 10)
		local pos = CPos.New(x,y)
		if x > 0 and y > 0 and Actor.CanEnterLocation(actor, pos) then
			Actor.Create("GODZILLAJR", { Location = pos, Owner = actor.Owner })
			toSpawn = toSpawn - 1
		end
		limit = limit - 1
	end
	PlayRandomGodzillaSound()
end

Power.Wrath = function(actor)
	local locations = LocationsFromLocationWithCross(actor.Location, 3)
	local delay = 0
	for i, location in ipairs(locations) do
		OpenRA.RunAfterDelay(delay, function()
			Effect.FlameLocation(location,actor.Owner)
		end)
		delay = delay + 0.5
	end

	locations = LocationsFromLocationWithDiogonalCross(actor.Location, 3)
	delay = 10
	for i, location in ipairs(locations) do
		OpenRA.RunAfterDelay(delay, function()
			Effect.FlameLocation(location,actor.Owner)
		end)
		delay = delay + 0.5
	end

	delay = 20
	for i = 1, 5, 1 do
		OpenRA.RunAfterDelay(delay, function()
			locations = LocationsFromLocationWithCube(actor.Location, i)
			for i, location in ipairs(locations) do
				Effect.FlameLocation(location,actor.Owner)
			end
		end)
		delay = delay + 1
	end

	PlayRandomGodzillaSound()
end

Power.IsHealing = function(actor, eh)
	if Actor.HasTrait(actor, "Health") and Actor.Trait(actor, "Health").HP == 100001 then
		eh()
	end
end

Power.IsAtomicBreath = function(actor, eh)
	if Actor.HasTrait(actor, "Health") and Actor.Trait(actor, "Health").HP == 100002 then
		eh()
	end
end

Power.IsAtomicEnergy = function(actor, eh)
	if Actor.HasTrait(actor, "Health") and Actor.Trait(actor, "Health").HP == 100003 then
		eh()
	end
end

Power.IsCallForHelp = function(actor, eh)
	if Actor.HasTrait(actor, "Health") and Actor.Trait(actor, "Health").HP == 100004 then
		eh()
	end
end

Power.IsWrath = function(actor, eh)
	if Actor.HasTrait(actor, "Health") and Actor.Trait(actor, "Health").HP == 100005 then
		eh()
	end
end

Effect.Heal1Location = function(cpos, owner)
	if cpos.X >= 0 and cpos.Y >= 0 then
		Actor.Create("PHEALING1", { Location = cpos, Owner = owner })
	end
end

Effect.Heal2Location = function(cpos, owner)
	if cpos.X >= 0 and cpos.Y >= 0 then
		Actor.Create("PHEALING2", { Location = cpos, Owner = owner })
	end
end

Effect.Heal3Location = function(cpos, owner)
	if cpos.X >= 0 and cpos.Y >= 0 then
		Actor.Create("PHEALING3", { Location = cpos, Owner = owner })
	end
end

Effect.Heal4Location = function(cpos, owner)
	if cpos.X >= 0 and cpos.Y >= 0 then
		Actor.Create("PHEALING4", { Location = cpos, Owner = owner })
	end
end

Effect.FlameLocation = function(cpos, owner)
	if cpos.X >= 0 and cpos.Y >= 0 then
		Actor.Create("PDAMAGE1", { Location = cpos, Owner = owner })
	end
end

Effect.NukeLocation = function(cpos, owner)
	if cpos.X >= 0 and cpos.Y >= 0 then
		Actor.Create("PDAMAGE2", { Location = cpos, Owner = owner })
	end
end

PlayRandomGodzillaSound = function()
	local rnd = OpenRA.GetRandomInteger(0,4)
	if rnd == 0 then
		Media.PlaySoundNotification("Roar1",player)
	elseif rnd == 1 then
		Media.PlaySoundNotification("Roar2",player)
	elseif rnd == 2 then
		Media.PlaySoundNotification("Roar3",player)
	elseif rnd == 3 then
		Media.PlaySoundNotification("Roar4",player)
	elseif rnd == 4 then
		Media.PlaySoundNotification("Roar5",player)
	end
end

-- ex: "napalm"
Map.CreateExplosionEffectAt = function(wpos, style)
	World:AddFrameEndTask(
		function(w)
			w:Add( OpenRA.New("Explosion", { w, wpos, {style, "String"} } ) )
		end)
end

-- ex: "levelup"
Actor.CreateEffectOn = function(actor, sequence)
	World:AddFrameEndTask(
		function(w)
			w:Add( OpenRA.New("CrateEffect", { actor, {sequence, "String"} } ) )
		end)
end

-- Get location from distance from location and facing
CPos.LocationAddDistanceAndFacing = function(cpos, distance, facing)
	local degrees = math.floor(facing * 1.40625 + 0.5) + 180
	local xDist = distance * math.sin(math.rad(degrees))
	local yDist = distance * math.cos(math.rad(degrees))
	return CPos.New(math.floor(cpos.X + xDist + 0.5), math.floor(cpos.Y + yDist + 0.5))
end

-- V formation of locations from location, distance, facing, startSize and increasement
LocationsFromLocationDistanceFacingSpread = function(cpos, distance, facing, startSize, increasement)
	local i = 1
	local size = startSize
	local arrSize = 0
	local arr = {}
	while i <= distance do
		local s = math.floor(size + 0.5)
		if s > 0 then
			if s > 1 then
				local s1 = 1 - (s - math.floor(s/2)*2)
				s = s - s1
			end
			local moveUp = math.floor(s / 2)
			for x = 0 - moveUp, s - moveUp - 1, 1 do
				if x < 0 then
					local tmp = CPos.LocationAddDistanceAndFacing(CPos.New(cpos.X, cpos.Y), math.abs(x), facing - 64)
					arr[arrSize] = CPos.LocationAddDistanceAndFacing(CPos.New(tmp.X, tmp.Y), i, facing)
					arrSize = arrSize + 1
				end
				if x == 0 then
					arr[arrSize] = CPos.LocationAddDistanceAndFacing(CPos.New(cpos.X, cpos.Y), i, facing)
					arrSize = arrSize + 1
				end
				if x > 0 then
					local tmp = CPos.LocationAddDistanceAndFacing(CPos.New(cpos.X, cpos.Y), math.abs(x), facing + 64)
					arr[arrSize] = CPos.LocationAddDistanceAndFacing(CPos.New(tmp.X, tmp.Y), i, facing)
					arrSize = arrSize + 1
				end
			end
		end
		size = size + increasement
		i = i + 1
	end
	return arr
end

LocationsFromLocationWithCross = function(cpos, distance)
	local arr = {}
	local arrSize = 0
	for i = 0, distance * 4, 1 do
		local direction = i - math.floor(i/4)*4
		local dist = math.floor(i / 4) + 1
		if direction == 0 then
			arr[arrSize] = CPos.New(cpos.X, cpos.Y - dist)
			arrSize = arrSize + 1
		elseif direction == 1 then
			arr[arrSize] = CPos.New(cpos.X - dist, cpos.Y)
			arrSize = arrSize + 1
		elseif direction == 2 then
			arr[arrSize] = CPos.New(cpos.X, cpos.Y + dist)
			arrSize = arrSize + 1
		elseif direction == 3 then
			arr[arrSize] = CPos.New(cpos.X + dist, cpos.Y)
			arrSize = arrSize + 1
		end
	end
	return arr
end

LocationsFromLocationWithDiogonalCross = function(cpos, distance)
	local arr = {}
	local arrSize = 0
	for i = 0, distance * 4, 1 do
		local direction = i - math.floor(i/4)*4
		local dist = math.floor(i / 4) + 1
		if direction == 0 then
			arr[arrSize] = CPos.New(cpos.X - dist, cpos.Y - dist)
			arrSize = arrSize + 1
		elseif direction == 1 then
			arr[arrSize] = CPos.New(cpos.X - dist, cpos.Y + dist)
			arrSize = arrSize + 1
		elseif direction == 2 then
			arr[arrSize] = CPos.New(cpos.X + dist, cpos.Y + dist)
			arrSize = arrSize + 1
		elseif direction == 3 then
			arr[arrSize] = CPos.New(cpos.X + dist, cpos.Y - dist)
			arrSize = arrSize + 1
		end
	end
	return arr
end

LocationsFromLocationWithCube = function(cpos, distance)
	local arr = {}
	local arrSize = 0
	local size = 3 + distance * 2
	local offset = math.floor(size / 2)
	for x = cpos.X + offset, cpos.X + offset - size + 1, -1 do
		arr[arrSize] = CPos.New(x, cpos.Y - offset)
		arrSize = arrSize + 1
	end
	for y = cpos.Y - offset + 1, cpos.Y - offset + size - 2, 1 do
		arr[arrSize] = CPos.New(cpos.X - offset, y)
		arrSize = arrSize + 1
	end
	for x = cpos.X - offset, cpos.X - offset + size - 1, 1 do
		arr[arrSize] = CPos.New(x, cpos.Y + offset)
		arrSize = arrSize + 1
	end
	for y = cpos.Y + offset - 1, cpos.Y + offset - size + 2, -1 do
		arr[arrSize] = CPos.New(cpos.X + offset, y)
		arrSize = arrSize + 1
	end
	return arr
end

Actor.CanEnterLocation = function(actor, cpos)
	return Actor.Trait(actor, "Mobile"):CanEnterCell(cpos)
end

checkPowers = function(actor)
	Power.IsHealing(actor, function()
		Power.Healing(godzilla)
	end)
	Power.IsAtomicBreath(actor, function()
		Power.AtomicBreath(godzilla)
	end)
	Power.IsAtomicEnergy(actor, function()
		Power.AtomicEnergy(godzilla)
	end)
	Power.IsCallForHelp(actor, function()
		Power.CallForHelp(godzilla)
	end)
	Power.IsWrath(actor, function()
		Power.Wrath(godzilla)
	end)
end

Map.GetNumberOfPlayers = function()
	local nr = 4
	for i = 0, 3, 1 do
		if OpenRA.GetPlayer("Multi" .. tostring(i)) == nil then
			nr = nr - 1
		end
	end
	return nr
end

PlayMessagesEveryMin = function(mins, msgOne, msgMany, eh)
	if mins > 0 then
		if mins == 1 then
			local tmp = string.gsub(msgOne, ".mins.", tostring(mins))
			print(tmp)
		else
			local tmp = string.gsub(msgMany, ".mins.", tostring(mins))
			print(tmp)
		end
	end
	for i = 1, mins, 1 do
		OpenRA.RunAfterDelay(25 * 60 * i, function()
			if mins - i == 1 then
				local tmp = string.gsub(msgOne, ".mins.", tostring(mins - i))
				print(tmp)
			elseif mins - i > 1 then
				local tmp = string.gsub(msgMany, ".mins.", tostring(mins - i))
				print(tmp)
			end
		end)
	end
	OpenRA.RunAfterDelay(25 * 60 * mins, eh)
end

startLocations = {}
startLocations[0] = CPos.New(18,18)
startLocations[1] = CPos.New(19,82)
startLocations[2] = CPos.New(109,108)
startLocations[3] = CPos.New(87,19)
startLocations[4] = CPos.New(71,45)

startZillasLocations = {}
startZillasLocations[0] = CPos.New(19,18)
startZillasLocations[1] = CPos.New(20,82)
startZillasLocations[2] = CPos.New(108,108)
startZillasLocations[3] = CPos.New(86,19)
startZillasLocations[4] = CPos.New(70,45)

startLocation = OpenRA.GetRandomInteger(0,4)

WorldLoaded = function()
	godzillaEgg = Actor.Create("GODZILLAEGG", { Location = startLocations[startLocation] , Owner = OpenRA.GetPlayer("Multi0") })
	World.ActorAdded:Add(checkPowers)

	local nrOfPlayers = Map.GetNumberOfPlayers()
	local mins = 7
	if nrOfPlayers == 1 then
		mins = 0
	end
	
	PlayMessagesEveryMin(mins, "Godzilla is coming in .mins. minute.", "Godzilla is coming in .mins. minutes.", function()
		PlayRandomGodzillaSound()
		Actor.Create("TENT2", { Location = CPos.New(39,16) , Owner = OpenRA.GetPlayer("Multi0") })
		godzilla = Actor.Create("GODZILLA", { Location = startLocations[startLocation] , Owner = OpenRA.GetPlayer("Multi0") })
		Actor.RemoveSelf(godzillaEgg)
	end)

	OpenRA.RunAfterDelay(25 * 60 * mins + 25 * 2, function()
		Media.PlaySoundNotification("Sound1",player)		
	end)

	for i = 0, mins * 2, 1 do
		OpenRA.RunAfterDelay(25 * 30 * i, function()
			Actor.Create("GODZILLAJR", { Location = startZillasLocations[startLocation] , Owner = OpenRA.GetPlayer("Multi0") })
		end)
	end
end
