
countNumberOfHumanPlayers = function()
  local count = 0
  Utils.Do(Player.GetPlayers(nil), function(p)
      if not p.IsNonCombatant and not p.IsBot then
        count = count + 1
      end
  end)
  return count
end

countTotalNumberOfDerricks = function()
  local count = 0
  Utils.Do(Map.NamedActors, function(a)
      if a.Type == "zombie" then
        count = count + 1
      end
  end)
  return count
end

countMaxNumerOfDerricksPerPlayer = function(numDerricks, numPlayers)
  offset = 80  -- the 4 derricks at the center of this particular map...
  return math.floor(0.5 + (numDerricks - offset) / numPlayers)
end

isGreedyPlayer = function(player, numDerricks, maxNum)
  print(" isGreedy check: " ..player.InternalName .. ", " .. tostring(numDerricks) .. " >? " .. tostring(maxNum))
  if numDerricks > maxNum then
    return true
  else
    return false
  end
end

numberOfHumanPlayers = countNumberOfHumanPlayers()
totalNumberOfDerricks = countTotalNumberOfDerricks()
maxNumerOfDerricksPerPlayer = countMaxNumerOfDerricksPerPlayer(totalNumberOfDerricks, numberOfHumanPlayers)

Media.DisplayMessage("There are " .. tostring(totalNumberOfDerricks - 4) .. " Zombies .. be prepared to defend!!!")
Media.DisplayMessage("Good luck.\nAnd have FUN!!!")

findClosestWaypoint = function(cPos)
  result = nil
  closestDist = 9999999

  Utils.Do(Map.NamedActors, function(a)
    if a.Type == "waypoint" then
      d = (a.Location.X - cPos.X)^2 + (a.Location.Y - cPos.Y)^2
      if d < closestDist then
        closestDist = d
        result = a.Location
      end
    end
  end)
  return result
end



