-- Amount of Main Players in this game, Players are taken from the first mainplr_count slots
mainplr_count = 4

-- Player information
player_list = {}
main_players = {}
micro_players = {}
is_main = {}

player_count = 0

-- lua mostly copied from:
--  SirCakealot (d2kA)
-- a few scripts from:
--  sin (Top Control)
--  CombinE (Conyard Wars)

-- Information for every unit
ActorRegister = {}
OriginalOwner = {}

-- Game Over Check
team_mains = {}
main_disabled = {}

IsMain = function(plr) return is_main[plr.InternalName] == 1 end
ChatMsg = function(msg) print(msg); Media.DisplayMessage(msg) end
IndexPlayer = function(i) return Player.GetPlayer("Multi"..i) end

function CaptureUnits(act, range)
	-- Change Owner of all units in area
	local center = act.CenterPosition
	local dist = WVec.New(range,range,0)
	local units = Map.ActorsInBox(center-dist,center+dist,function(unit)
		-- Only Main Player units can be taken
		if not IsMain(unit.Owner) then return nil end
		-- Are the players allied? Cause taking enemy's units is unfair!
		if not unit.Owner.IsAlliedWith(act.Owner) then return nil end
		-- Only Units, no structures
		if not unit.HasProperty("Move")	then return nil end
		-- Following Units can't be captured
		if unit.Type == "mcv" then return nil end
		return unit
	end)

	local orig
	for _,u in pairs(units) do
		-- does this unit have any original owner?
		orig = OriginalOwner[tostring(u)]
		if orig ~= nil then
			-- yes - only pass if owners do match
			if u.Owner == orig then u.Owner = act.Owner end
		elseif IsMain(u.Owner) then
			-- no - save owner and pass that unit only if the real owner is a Main
			OriginalOwner[tostring(u)] = u.Owner
			u.Owner = act.Owner
		end
	end
	act.Destroy()
end

function ReturnUnits(act, range)
	--Change Owner of all units in area
	local center = act.CenterPosition
	local dist = WVec.New(range,range,0)
	local units = Map.ActorsInBox(center-dist,center+dist,function(unit)
		-- To return an Unit, you need to be either the original owner or the actual owner of that unit
		if act.Owner ~= unit.Owner and act.Owner ~= OriginalOwner[tostring(unit)] then return nil end
		-- Are the players allied? Cause returning enemy's units is unfair!
		--if not unit.Owner.IsAlliedWith(act.Owner) then return nil end
		-- Only Units, no structures
		if not unit.HasProperty("Move")	then return nil end
		-- Following Units can't be returned
--		if unit.Type == "mcv" then return nil end
		return unit
	end)
	
	local orig
	for _,u in pairs(units) do
		-- does this unit have any original owner?
		orig = OriginalOwner[tostring(u)]
		if orig ~= nil then
			-- yes - return unit
			u.Owner = orig
		end
		-- no - don't do anything cause that would cause bugs and it's possible that non-mains get own units
--		elseif IsMain(act.Owner) and (unit.HasProperty("Move") or unit.Type == "v19" or unit.Type == "hosp" or unit.Type == "bio") then
--			-- no - save owner and pass that unit
--			OriginalOwner[tostring(u)] = u.Owner
--			u.Owner = act.Owner
--			OriginalOwner[tostring(u)] = act.Owner
--		end
	end
	act.Destroy()
end

-- AddTag could help?
function ActorsAddedToWorld(newlist,register)
	local new_actor_list={}
	local str
	for key,act in pairs(newlist) do
		str = tostring(act)
		if not register[str] then
			register[str]=true
			table.insert(new_actor_list,act)
			ActualizeActor(act)
		end
	end
	return new_actor_list
end

function ActualizeActor(actor)
	if actor.HasProperty("MaxHealth") then
		Trigger.OnCapture(actor, function(self, captor, old, new)
			CheckCaptured(self, captor, old, new)
		end)
		Trigger.OnKilled(actor, function(self, killer)
			CheckKilled(self, killer)
		end)
	end
end

function CheckKilled(self, killer)
	local owner = self.Owner
	local strtype, stract
	for i=0,1 do
		if     i == 0 then strtype = "hosp" stract = "hospitalactor"
		elseif i == 1 then strtype = "bio" stract = "biolabactor"
		end
		if self.Type == strtype then
			units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.Type == strtype and Actor.Owner.IsAlliedWith(owner) end)
			if #units < 2 then
				units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.Type == stract and Actor.Owner.IsAlliedWith(owner) end)
				for _,u in pairs(units) do
					u.Destroy()
				end
			end
		end
	end
end

function CheckHuskActor(center, oldstr, orig, new)
	dist = WVec.New(1024,1024,0)
	newact = Map.ActorsInBox(center-dist,center+dist, function(unit) return unit.Type..".husk" == oldstr and unit.Owner == new end)[1]
	if newact ~= nil then
		--ChatMsg("Found "..tostring(newact)..", Move to "..orig.Name)
		if newact.HasProperty("StartBuildingRepairs") then -- Buildings should belong to the original owner
			newact.Owner = orig
		else
			OriginalOwner[tostring(newact)] = orig
		end
	end
end
				
function CheckCaptured(self, captor, old, new)
	local orig = OriginalOwner[tostring(captor)]
	if orig ~= nil then
		OriginalOwner[tostring(self)] = orig
		oldstr = self.Type
--		if self.HasProperty("StartBuildingRepairs") or self.Type == "v19.husk" or self.Type == "hosp.husk" or self.Type == "bio.husk" then -- Buildings should belong to the original owner
		if self.HasProperty("StartBuildingRepairs") then
			-- Buildings should belong to the original owner
			self.Owner = orig
		else
			-- Was it some kind of husk? Save the original owner after 3 Frames again due to the fact that this Unit might change the actor
			center = self.CenterPosition
			-- Vehicle Husk needs a delay of 3, Structure Husk a delay of 2
			Trigger.AfterDelay(2, function() CheckHuskActor(center, oldstr, orig, new) end)
			Trigger.AfterDelay(3, function() CheckHuskActor(center, oldstr, orig, new) end)
		end
	end

	local strtype, stract, doremove
	for i=0,3 do
		if     i == 0 then strtype = "hosp" stract = "hospitalactor" doremove = true
		elseif i == 1 then strtype = "bio" stract = "biolabactor" doremove = true
		elseif i == 2 then strtype = "hosp.husk" stract = "hospitalactor" doremove = false
		elseif i == 3 then strtype = "bio.husk" stract = "biolabactor" doremove = false
		end
		if self.Type == strtype then
--			ChatMsg(new.Name.." captured an "..strtype.." from "..old.Name.."!")
			if doremove == true then
				-- Does the team of the old owner still own a strtype?
				units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.Type == strtype and Actor.Owner.IsAlliedWith(old) end)
				if #units < 2 then
					-- No strtype found: Remove all the stract
					units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.Type == stract and Actor.Owner.IsAlliedWith(old) end)
					for _,u in pairs(units) do
--						ChatMsg(u.Owner.Name.." lost an "..stract.."!")
						u.Destroy()
					end
				end
			end
			-- Did the team of the new owner not own an strtype at all?
			units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.Type == stract and Actor.Owner.IsAlliedWith(new) end)
			if not units[1] then
				-- No Actor found: Give stract to every player in team
				for i=0,player_count-1 do
					if player_list[i].IsAlliedWith(new) then
--						ChatMsg(player_list[i].Name.." got an "..stract.."!")
						Actor.Create(stract,true, { Owner = player_list[i], Location = CPos.New(0,0) })
					end
				end
			end
		end
	end
end

Tick = function()
	--check register for new actors and only call act.Type == "whatever" when necessary since it is expensive
	local new_actors = ActorsAddedToWorld(Map.ActorsInWorld,ActorRegister)
	
	for _,act in pairs(new_actors) do
		--ACTOR TYPE CHECKS
		local type = act.Type
		if		type == "actor_capturesingle" then CaptureUnits(act,512)
		elseif	type == "actor_captureunits" then CaptureUnits(act,2560) -- 2x1024+512
		elseif	type == "actor_returnunits" then ReturnUnits(act,2560)
		end
	end
	
	-- Game Over Check
	-- Could be easier with "OnAllKilledOrCaptured"
	for i=0,mainplr_count-1 do
		if main_disabled[main_players[i]] ~= 1 then
			if main_players[i].HasNoRequiredUnits() then
				team_mains[main_players[i].Team] = team_mains[main_players[i].Team]-1
				main_disabled[main_players[i]] = 1
				--ChatMsg(main_players[i].Name..", Team "..main_players[i].Team.." is disabled now!")
				if team_mains[main_players[i].Team] == 0 then
					for j=0,player_count-mainplr_count-1 do
						if micro_players[j].IsAlliedWith(main_players[i]) then
							for _,act in pairs(micro_players[j].GetActors()) do
								if act.HasProperty("MaxHealth") then act.Kill()
								elseif act.Type == "plractor" then act.Destroy()
								end
							end
						end
					end
				end
			end
		end
	end
end

WorldLoaded = function()
	-- Get the Main Players first
	local player
	local num = 0, found
	local units
	for i=1,mainplr_count do
		player = IndexPlayer(num)
		num = num+1
		if player ~= nil then
			player_list[player_count] = player
			main_players[player_count] = player
			is_main[player.InternalName] = 1
			player_count = player_count+1

			if team_mains[player.Team] ~= nil then
				team_mains[player.Team] = team_mains[player.Team]+1
			else
				team_mains[player.Team] = 1
			end
			-- In case of 'if they want to return an unit'
			Actor.Create("ReturnUnitsPower", true, { Owner = player, Location = CPos.New(0,0) })
		else
			-- Main Player not found: Reduce the amount of Main Players
			mainplr_count = mainplr_count-1
		end
	end
	-- gather Micro Players
	for i=1,24 do -- I bet there can be up to 24 Micro Players in a single game
		player = IndexPlayer(num)
		num = num+1
		if player ~= nil then
			-- Save data
			player_list[player_count] = player
			micro_players[player_count-mainplr_count] = player
			is_main[player.InternalName] = 0
			player_count = player_count+1

			-- Micro Players: Remove all their units, set money to zero and replace their MCV with an undestructable Structure
			--	(Structure prevents from loosing instantly)
			player.Cash = 0
			units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.HasProperty("Move") and Actor.Owner == player end)
			for _,u in pairs(units) do u.Destroy() end
			-- Do they have any allied main? Cause Microers without a Main can't do anything!
			found = 0
--			for j=0,mainplr_count-1 do if player.IsAlliedWith(main_players[j]) then ChatMsg(player.Name.." is allied with "..main_players[j].Name) found = 1 end end
			for j=0,mainplr_count-1 do if player.IsAlliedWith(main_players[j]) then found = 1 end end
			if found == 1 then
				Actor.Create("PlrActor",			true, { Owner = player, Location = CPos.New(0,0) })
				Actor.Create("CaptureUnitsPower",	true, { Owner = player, Location = CPos.New(0,0) })
				Actor.Create("ReturnUnitsPower",	true, { Owner = player, Location = CPos.New(0,0) })
				Actor.Create("CaptureSinglePower",	true, { Owner = player, Location = CPos.New(0,0) })
				--Camera.Position = MCV.CenterPosition
			else
				ChatMsg(player.Name.." has no allied Main Player!")
			end
		end
	end

	-- Test for the Oil Derricks on the Map
--	units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.Type == "v19" end)
--	for _,u in pairs(units) do
--		Trigger.OnCapture(u, function(this, captor, old, new)
--			local orig = OriginalOwner[tostring(captor)]
--			if orig ~= nil then
--				this.Owner = orig
--			end
--		end)
--	end
	-- Works fine

	-- Check for my lua to work
--	ChatMsg("Main count = "..mainplr_count)
--	ChatMsg("Player count = "..player_count)
--	for i=0,player_count-1 do
--		local plr = player_list[i].InternalName
--		j = is_main[plr]
--		if plr ~= nil then
--			ChatMsg("Player "..i.." is main = "..j)
--		end
--	end
end
