AtreidesBaseAdvice={"Sovereign, we have to establish a BASE here first. Deploy the MOBILE CRANE, we can pack it back up later.",
"Sovereign, we should recruit some MORE TROOPS, our savings allow it.",
"Your Highness, to unlock AIR REINFORCEMENTS build an OUTPOST.",
"Sire, if we UPGRADE the OUTPOST now we can get reinforcements later.",
"We are well established, Sire. We should un-deploy the CRANE and TAKE NEW TERRITORY.",
"Your Highness, I propose we  build silos and upgrade them. It pays off in the long term."}
AtreidesMapAdvice={"Sire, our Fremen friends are somewhere in the North. CAPTURE one of their cliff SIETCHes to grant us powerful Fremen troops.",
"Sire, to the East SMUGGLER carryalls have been sighted. They might have a BASE there.",
"Sire, before us are the remnants of the former Ordos city. CAPTURE as much TECHNOLOGY and PRODUCTION as we can get.",
"Sire! The Harkonnen base! Be careful, it is well fortified!",
"Your Highness, those are Harkonnen ORNITHOPTERS. We should shoot them down quickly with our missile tanks.",
"Sire, those are Harkonnen troop transports. Beware, they might carry a squad of sardaukar!"}
HarkonnenBaseAdvice={"Sire, this cheap leased base doesn't have any building construction. Fortunately we can still purchase UPGRADES for our structures and build defenses with the PALACE.",
"Also I, as your humble Advisor, propose we use our STARPORT to call in high tech troops the nasty Atreides can't deal with.\nWe should also scout the area wih our two LIGHT THOPTERS.",
"Your Highness! Our funds are dwindling - please order more HARVESTERS."}
HarkonnenMapAdvice={"Ah, the Smugglers, our friends! We could SEND ENGINEERS to take over their spice production, Sire.",
"Fremen Scum! Their SKYHUNTER INFANTRY can shoot down your Ornithopters, Milord. We might want to destroy all their cave Sietches.",
"There lie the remnants of the Ordos in ruin. You could order some of your ENGINEERS to CAPTURE valuable TECHNOLOGY, Milord.",
"Milord, the Atreides base! They seem to only have a MOBILE CRANE with them - and so, are restricted to basic technology."}

ThopterDiscovered=false
TroopCrawlerDiscovered=false

function initializeMission()
	--wither ordos walls
	for iter, act in pairs(ordos.GetActors()) 
		do
			if act.Type == "wall" then act.Health = 0.2*act.MaxHealth 
			end
	end
	--kill automatic ordos carryalls
	Trigger.AfterDelay(DateTime.Seconds(0.1),function()
			for _,act in pairs(ordos.GetActors())
			do 
				if act.Type=="carryall.reinforce" then act.Kill() end
			end
		end)
	--set starting cash (rules:	PlayerResources: DefaultCashLocked: True currently bugged -> prevents players from joining)
	harkonnen.Cash=10000
	atreides.Cash =10000	
		
	--Introductory text	
	if atreides and atreides.IsLocalPlayer
		then
			Media.DisplayMessage("Spread Atreides influence and destroy all Harkonnen forces!","Your Mission",HSLColor.LawnGreen)
	end
	if harkonnen and harkonnen.IsLocalPlayer
		then
			Media.DisplayMessage("Destroy all Atreides forces!","Your Mission",HSLColor.Red)
	end

	--Set up part one of the mission-text triggers (Mentat Advisor help text)
	summonAtreidesMentat()
	summonHarkonnenMentat()

	--victory messages
	Trigger.OnObjectiveCompleted(atreides, 
		function(p,id) 
			Media.DisplayMessage("The Atreides have liberated the territory!","Mission Success",HSLColor.Blue) 
			Media.DisplayMessage("The Harkonnen are fleeing!","Mission Failure",HSLColor.Red)
		end)
	Trigger.OnObjectiveCompleted(harkonnen, 
		function(p,id) 
			Media.DisplayMessage("The Harkonnen strengthened their grip on the area!","Mission Success",HSLColor.Red)
			Media.DisplayMessage("The Atreides were driven back!","Mission Failure",HSLColor.Blue)
		end)
end

function mentatUnitDiscoveredAdvice(unit,Type)
-- Atreides Mentat "Troop Transport discovered" message check (requires AnnounceOnSeen: on unit and Player: EnemyWatcher in map.yaml)
	if not TroopCrawlerDiscovered and Type=="troop_crawler"
	then
		Trigger.OnDiscovered(unit,function(discoveringAct,owner)
			if owner==atreides 
			then
				TroopCrawlerDiscovered=true
				sayTo(atreides, AtreidesMapAdvice[6])
				AtreidesMapAdvice[6]=nil
			end
		end)
	--...and Atreides Mentat "Ornithopter discovered" message check
	elseif not ThopterDiscovered and Type=="light_thopter"
	then
		Trigger.OnDiscovered(unit, function(discoveringAct, owner)
			if owner==atreides 
			then
				ThopterDiscovered=true
				sayTo(atreides, AtreidesMapAdvice[5])
				AtreidesMapAdvice[5]=nil
			end
		end)
	end	
end

function summonAtreidesMentat()
--common/standard triggers used for mentat advice
Trigger.AfterDelay(DateTime.Seconds(10),function()
	sayTo(atreides, AtreidesBaseAdvice[1])
	end)
Trigger.AfterDelay(DateTime.Minutes(6),function()
		if atreides.HasPrerequisites({"crane"}) 
		then
			sayTo(atreides, AtreidesBaseAdvice[6]) 
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(2,47,37,47),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[1])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)

Trigger.OnEnteredFootprint(getCPossesInRectangle(46,63,46,82),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[2])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(36,35,44,49),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[3])
			AtreidesMapAdvice[3]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(68,47,71,52),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[3])
			AtreidesMapAdvice[3]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(78,19,92,37),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[4])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
end

function summonHarkonnenMentat()
--common/standard triggers used for mentat advice
Trigger.AfterDelay(DateTime.Seconds(10),function()
	sayTo(harkonnen,HarkonnenBaseAdvice[1])
	end)
Trigger.AfterDelay(DateTime.Seconds(35),function()
	sayTo(harkonnen,HarkonnenBaseAdvice[2])
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(76,50,93,50),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[1])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)	
Trigger.OnEnteredFootprint(getCPossesInRectangle(65,13,70,49),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[3])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(44,7,51,14),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[2])
			HarkonnenMapAdvice[2]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(12,30,18,35),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[2])
			HarkonnenMapAdvice[2]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(3,68,18,80),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[4])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
end
	
function taskAtreidesMentat()
--custom triggers used for mentat advice
if AtreidesBaseAdvice[2] and Utils.Any({{"barracks"},{"light_factory"},{"heavy_factory"}},atreides.HasPrerequisites)
then
	sayTo(atreides, AtreidesBaseAdvice[2])
	AtreidesBaseAdvice[2] = nil
end
if AtreidesBaseAdvice[3] and Utils.Any({{"barracks","light_factory"},{"barracks", "heavy_factory"},{"light_factory","heavy_factory"}},atreides.HasPrerequisites ) and atreides.HasPrerequisites({"crane"})
then
	if atreides.HasPrerequisites({"outpost"}) then AtreidesBaseAdvice[3] = nil end
	sayTo(atreides, AtreidesBaseAdvice[3])
	AtreidesBaseAdvice[3] = nil
end
if AtreidesBaseAdvice[4] and atreides.HasPrerequisites({"outpost"}) 
then
	sayTo(atreides, AtreidesBaseAdvice[4])
	AtreidesBaseAdvice[4] = nil
end
if AtreidesBaseAdvice[5] and atreides.HasPrerequisites({"refinery","barracks","light_factory","heavy_factory","outpost"}) and atreides.HasPrerequisites({"crane"})
then
	sayTo(atreides, AtreidesBaseAdvice[5])
	AtreidesBaseAdvice[5] = nil
end
end

function taskHarkonnenMentat()
--custom triggers used for mentat advice
if HarkonnenBaseAdvice[3] and harkonnen.Resources+harkonnen.Cash<3300
then 
	sayTo(harkonnen, HarkonnenBaseAdvice[3])
	HarkonnenBaseAdvice[3]=nil
end

--Air units unfortunately don't trigger Trigger.OnEnteredFootprint so...
local Advice = 0
for _,thopter in pairs(harkonnen.GetActorsByType("light_thopter")) do
	local x = thopter.Location.X
	local y = thopter.Location.Y
	if y>=60 and x>=69
	then
		Advice = 1
	elseif 49>=y and y>=14 and x<=71
	then
		Advice = 3
	elseif 38>=y and y>=25 and 18>=x and x>=10 --this entry is somehow bugged
	then 
		Advice = 2
	elseif 14>=y and y>=7 and 51>=x and x>=44
	then
		Advice = 2
	elseif x<=18 and y>=68
	then
		Advice = 4
	end
end
if Advice>0
then
	sayTo(harkonnen,HarkonnenMapAdvice[Advice])
	HarkonnenMapAdvice[Advice]=nil
end
end

function getCPossesInRectangle(left,top,right,bottom)
	local Cposses={}
	local length=right-left+1
	for i=top,bottom do 
		for j=left,right do 
			Cposses[(i-top)*length+(j+1-left)]=CPos.New(j,i)
		end
	end
	--for debugging
	--[[
	 for idx,cpos in pairs(Cposses) do
		Beacon.New(harkonnen,Map.CenterOfCell(cpos))
	 end
	 --]]
	return Cposses
end

function sayTo(player, message)
	if message
	then
		if player==atreides and not harkonnen.IsLocalPlayer 
		then 
			Media.DisplayMessage(message,"Mentat",HSLColor.LawnGreen)
		elseif player==harkonnen and not atreides.IsLocalPlayer 
		then 
			Media.DisplayMessage(message,"Mentat",HSLColor.Red)
		end
	end
end

