--MISSION ADJUSTED d2kA.lua clone
ActorRegister={}
TrackedPairs = {}
TrackedProduction = {}
ConditionRecord = {}

ReinforcementSquads = {
	{"light_inf"},
	{"quad","quad","mpsardaukar", "mpsardaukar"},
	{"guild_agent"}
	}
	
WorldLoaded = function()
	neut=Player.GetPlayer("Neutral")
	mp0=Player.GetPlayer("Multi0")
	mp1=Player.GetPlayer("Multi1")
	Neutral=Player.GetPlayer("Neutral")
	hate1=Player.GetPlayer("HatesMulti1")
	hate0=Player.GetPlayer("HatesMulti0")
	
	--fix multi1 palace waypoint 
	Actor89.RallyPoint=CPos.New(36,64) 
	
	--Mentat
	intitializeMentats()
	
	--Rogue starport
	initializeRogueStarport()
end

Tick = function()
	--can starport stop defending?
	starportRelax()
	
	--more mentat tips
	mentatTipsTick()
	
	--check register for new actors and only call act.Type=="whatever" when neccessary since it is expensive
	local new_actors = ActorsAddedToWorld(Map.ActorsInWorld,ActorRegister)
	
	for _,act in pairs(new_actors) 
	do
	--ACTOR TYPE CHECKS
		local T=act.Type
		--needed for airdrop powers
		if (T=="waypoint_dummy_a" or T=="waypoint_dummy_h" or T=="waypoint_dummy_o")
		then
			dropAirReinforcements(act.Location,act)
		--...handle silo replacement on silo upgrade
		elseif T=="upgrade.silo"
		then
			replace_silos(act.Owner)
		--...Handle saboteur entering a harvester which is getting picked up by a carryall before the Demolition charge explodes (Both will die)
		elseif (T == "harvester" or T == "advanced_harvester_h"  or T == "advanced_harvester_a" or T == "advanced_harvester_o" or T == "harvester.starport") and TrackedPairs[tostring(act)]==nil
		then
			TrackedPairs[tostring(act)]='NoCarryall'
			Trigger.OnKilled(act, 
				function(harvester,killer)
					local MaybeCarryall = TrackedPairs[tostring(harvester)]
					if MaybeCarryall~='NoCarryall' and MaybeCarryall~=nil
					then
						if MaybeCarryall.HasProperty('Kill') 
						then 
							MaybeCarryall.Kill()
							Media.PlaySound('EXPLLG2.WAV')
						end
					else
					end
				end
			)
			Trigger.OnRemovedFromWorld(act, 
				function(harv)
					local carryalls = Map.ActorsInCircle(harv.CenterPosition, WDist.New(1), 
						function(carry) 
							if (carry.Type=="carryall" or carry.Type=="carryall.starport") then return carry else return nil end 
						end
					)
					if carryalls[1]~=nil 
					then 
						TrackedPairs[tostring(harv)]=carryalls[1]
					end
				end 
			)
			Trigger.OnAddedToWorld(act,function(harv)
					local carryalls = Map.ActorsInCircle(harv.CenterPosition, WDist.New(1), 
						function(carry) 
							if (carry.Type=="carryall" or carry.Type=="carryall.starport") then return carry else return nil end 
						end
					)
					if carryalls[1]~=nil
					then 
						TrackedPairs[tostring(harv)]='NoCarryall'
					end
				end 
			)
		--...handle guild agent unit-built icons on unit constructing buildings
		elseif (T=="barracks" or T=="light_factory" or T=="heavy_factory" or T=="high_tech_factory" or T=="starport_dummy") and TrackedProduction[tostring(act)]==nil
		then
			TrackedProduction[tostring(act)]= true
			Trigger.OnProduction(act, 
				function(prod,prodded) 
					grantProductionIcon(prod,prodded) 
				end
			)
		end	
	end
end

function ActorsAddedToWorld(newlist,register)
	local new_actor_list={}
	for key,act in pairs(newlist)
	do
		if not register[tostring(act)]
		then
			register[tostring(act)]=true
			table.insert(new_actor_list,act)
		end
	end
	return new_actor_list
end

grantProductionIcon = function(producer,unit)
	if ConditionRecord[tostring(producer)] 
	then
		producer.RevokeCondition(ConditionRecord[tostring(producer)])
		ConditionRecord[tostring(producer)]=nil
	end

	local T=unit.Type
	if producer.Type == 'barracks' 
	then if T=='light_inf' or T=='trooper' or T=='engineer' or T=='thumper' or T=='assassin' or T=='loyalist' or T=='mpsardaukar' or T=='saboteur' or T=='propaganda_corps' or T=='guild_agent'
	then ConditionRecord[tostring(producer)] = producer.GrantCondition(tostring(unit.Type)..'_ICO') end
	elseif producer.Type == 'light_factory'
	then if T=='raider' or T=='trike_a' or T=='quad_hmg' or T=='quad' or T=='stealth_raider' or T=='troop_crawler'
	then ConditionRecord[tostring(producer)] = producer.GrantCondition(tostring(unit.Type)..'_ICO') end
	
	elseif producer.Type == 'heavy_factory'
	then if T=='advanced_harvester_o' or T=='advanced_harvester_a' or T=='advanced_harvester_h' or T=='combat_tank_a' or T=='combat_tank_h' or T=='combat_tank_o' or T=='siege_tank_o' or T=='siege_tank_a' or T=='deviator' or T=='missile_tank_a' or T=='missile_tank_o' or T=='sonic_tank' or T=='devastator' or T=='mcv' or T=='missile_tank_h' or T=='siege_tank_h'
	then ConditionRecord[tostring(producer)] =producer.GrantCondition(tostring(unit.Type)..'_ICO') end
	
	elseif producer.Type == 'high_tech_factory'
	then if T=='carryall' or T=='light_thopter' 
	then ConditionRecord[tostring(producer)] =producer.GrantCondition(tostring(unit.Type)..'_ICO') end
	
	elseif producer.Type == 'starport_dummy'
	then if T=='carryall.starport' or T=='harvester.starport' or T=='combat_tank_m.starport' or T=='missile_tank.starport' or T=='siege_tank.starport' or T=='trike.starport' or T=='quad.starport' or T=='mobile_crane.starport'
	then ConditionRecord[tostring(producer)] =producer.GrantCondition(string.sub(tostring(unit.Type),1,-10)..'_ICO') end
	end
end

function replace_silos(player)
	local res = player.Resources
	for _, actor in pairs(player.GetActorsByType("silo")) do
		local loc=actor.Location
		actor.Destroy()
		Actor.Create("advanced_silo", true, { Owner = player, Location = loc })
	end
	--give the game time to contemplate consequences of rapid player.ResourceCapacity changes, then correct.
	Trigger.AfterDelay(DateTime.Seconds(0.1),
					function() 
						player.Resources = res
					end
				)
end

function dropAirReinforcements(location,dummy)
	local squad
	if dummy.Type=="waypoint_dummy_a" then squad=1
	elseif dummy.Type=="waypoint_dummy_h" then squad=2
	elseif dummy.Type=="waypoint_dummy_o" then squad=3 
	end
	--Carryall reinforcements
	local base = dummy.Owner.GetActorsByType("outpost")[1]
	local edge = getMapEdge(base.Location, location)
	local path = {edge,location}
	local units = Reinforcements.ReinforceWithTransport(dummy.Owner, "carryall.controllable", ReinforcementSquads[squad], path, {path[2], path[1]})
	local carryall = units[1]
	Trigger.OnPassengerExited(carryall,
		function(carry, pass) 
			if not carry.HasPassengers 
			then 
				carry.Move(path[1]) 
				carry.Destroy() 
			end
		end
	)
end

function getMapEdge(posB,posA)
	local bnds = {}
	bnds.Top=(Map.TopLeft.Y)/1024
	bnds.Bottom=(Map.BottomRight.Y+1)/1024
	bnds.Left=(Map.TopLeft.X)/1024
	bnds.Right=(Map.BottomRight.X+1)/1024
	--catch zero devision errors
	if posB.X-posA.X == 0 
	then 
		if posB.Y<posA.Y then return CPos.New(posA.X,bnds.Top)
		else return CPos.New(posA.X,bnds.Bottom)
		end
	elseif posB.Y-posA.Y == 0 
	then 
		if posB.X<posA.X then return CPos.New(bnds.Left,posA.Y)
		else return CPos.New(bnds.Right,posA.Y)
		end
	end
	
	--compute all boundary intersections
	local slope = (posB.Y-posA.Y)/(posB.X-posA.X)
	local topX   = posA.X - (posA.Y-bnds.Top)/slope
	local bottomX= posA.X + (bnds.Bottom-posA.Y)/slope
	local rightY = posA.Y + (bnds.Right-posA.X)*slope
	local leftY =  posA.Y - (posA.X-bnds.Left)*slope
	
	local top = CPos.New(math.floor(topX),bnds.Top)
	local bottom = CPos.New(math.floor(bottomX),bnds.Bottom)
	local right = CPos.New(bnds.Right, math.floor(rightY))
	local left = CPos.New(bnds.Left, math.floor(leftY))	
	
	--decide which of them is reasonable
	local positiveDelX = 0 < (posB.X-posA.X)
	local positiveSlope= 0 < slope 
	
	if positiveDelX and positiveSlope
	then 
		if bottom.X<=bnds.Right then return bottom
		else return right
		end
	elseif positiveDelX and not positiveSlope
	then
		if top.X<=bnds.Right then return top
		else return right
		end
	elseif not positiveDelX and positiveSlope
	then
		if top.X>=bnds.Left then return top
		else return left
		end
	elseif not positiveDelX and not positiveSlope
	then
		if bottom.X>=bnds.Left then return bottom
		else return left
		end
	end
	Media.DisplayMessage(" in Function getMapEdge, no Edge matched, returning default. (0,0)","Error")
	return CPos.New(0,0)
end