undiscoveredStarport={false, false}
OrdosMentat={"It is a fact - any faction may use this Rogue Starport to call in some combat vehicles.\nDoubtlessly they will be very expensive, but it might be worth it.",
"It is a decision - the Rogues are under attack and ask for our assistance.",
"It is a fact -  I am your best advisor in this situation.\nIt is a neccessity - Strenghten our income and base Infrastructure right away.\nIt is an inconvenience - We are not allowed to bring war-machines here.",
"It is a decision - Carryalls multiply our economy, Thopters multiply our surveillance abilities.",
"It is a chance - If we manage to Infiltrate the Harkonnen with Guild Agents and Saboteurs, we will likely take away the victory.",
"I have nothing to say",
"It is an option - upgrading the outpost will grant us air-reinforcements.",
"It is a conclusion - We are victorious and proved that we were proceeding correctly."}
HarkonnenMentat={"It's not really cheating, Baron. With just a bit of extra cash and a bribe on top of that we can buy some tanks at this Rogue Starport.\nHowever, the nasty Rogues also surely deliver vehicles to the Ordos..",
"Baron, baron! The Rogues are under attack by the Ordos right now -- shall we help them?",
"Here I am again! Your Humble Advisor..\nDear, dear Baron - A war of Assassins! How exquisite! A spectacular Infantry only battle awaits us!!\nFirst however.. we have to take care of boring building construction and OF COURSE spice - mooore SPICE!",
"Take us to the skies, Master! Elegant and quick with the Light Thopter or lumbering and spice-heavy with the Carryall.",
"We should hide our Assassins in the rocks, they are stealthy there - they are my little brothers, heh.",
"Sardaukar... Bulky, coarse and brutal. Good enough Baron, but not as disingenuous as me!",
"Baron - use our air support! Upgrade the outpost and we will get air reinforcements.",
"Haha, see those Ordos weaklings. We were right after all!\nWe are victorious, great Baron!"}

function sayTo(player, message)
	if message
	then
		if player==mp0 and not mp1.IsLocalPlayer 
		then 
			Media.DisplayMessage(message,"Mentat",HSLColor.Red)
		elseif player==mp1 and not mp0.IsLocalPlayer 
		then 
			Media.DisplayMessage(message,"Mentat",HSLColor.LawnGreen)
		end
	end
end

function intitializeMentats()
	--Mentat introduction
	Trigger.AfterDelay(DateTime.Seconds(4),function()
		sayTo(mp0,HarkonnenMentat[3])
		sayTo(mp1,OrdosMentat[3])
	 end)
	--MentatVictoryMessages
	 Trigger.OnPlayerLost(mp1, function(p) sayTo(mp0, HarkonnenMentat[8]) end)
	 Trigger.OnPlayerLost(mp0, function(p) sayTo(mp1, OrdosMentat[8])     end)
end

function initializeRogueStarport()
	laststance=Neutral --player
	RogueStarport=Actor33
	
	--needed for Rogue Starport
	Actor92.Owner=Neutral
	Actor93.Owner=Neutral
	Trigger.AfterDelay(DateTime.Seconds(1),--to prevent "explored map" discovering the starport
		function()
			Trigger.OnDiscovered(RogueStarport, 
				function(unit,player)
					if player==mp0 and HarkonnenMentat[1]~=nil
					then 
						Actor92.Owner=mp0
						sp0 = Actor92
						sayTo(mp0,HarkonnenMentat[1])
						HarkonnenMentat[1]=nil
					elseif player==mp1 and OrdosMentat[1]~=nil
					then 
						Actor93.Owner=mp1
						sp1 = Actor93 
						sayTo(mp1,OrdosMentat[1])
						OrdosMentat[1]=nil
					end
				end
			)
		end
	)

	--defend starport if it is damaged and ask for help
	Trigger.OnDamaged(RogueStarport,
		function(attacked, attacker)
			local stance = false
			if attacker.Owner==mp1 
			then 
				stance=hate1
				laststance=hate1
				sayTo(mp0,HarkonnenMentat[2])
				HarkonnenMentat[2]=nil
			elseif attacker.Owner==mp0
			then 
				stance=hate0
				laststance=hate0
				sayTo(mp1,OrdosMentat[2])
				OrdosMentat[2]=nil		
			end 
			if stance
			then
				if not RogueStarport.IsDead then RogueStarport.StartBuildingRepairs(Neutral) end
				if not Actor21.IsDead then Actor21.Owner=stance end
				if not Actor23.IsDead then Actor23.Owner=stance end
				if not Actor27.IsDead then Actor27.Owner=stance end
				if not Actor32.IsDead then Actor32.Owner=stance end
			end
		end
	)
	--kill the dummies if starport is captured or killed
	Trigger.OnKilledOrCaptured(RogueStarport, 
		function()
			if not RogueStarport.IsDead then RogueStarport.Kill() end
			if sp0 then sp0.Destroy() end
			if sp1 then sp1.Destroy() end
		end
	)
end

function mentatTipsTick()

	--more mentat messages for base building
	if mp0.HasPrerequisites({"outpost"}) 
	then
		sayTo(mp0,HarkonnenMentat[7]) 
		HarkonnenMentat[7]=nil
	end
	if mp0.HasPrerequisites({"high_tech_factory"}) 
	then
		sayTo(mp0,HarkonnenMentat[4]) 
		HarkonnenMentat[4]=nil
	end
	if mp1.HasPrerequisites({"outpost"}) 
	then
		sayTo(mp1,OrdosMentat[7]) 
		OrdosMentat[7]=nil
	end
	if mp1.HasPrerequisites({"high_tech_factory"}) 
	then
		sayTo(mp1,OrdosMentat[4]) 
		OrdosMentat[4]=nil
	end
end

function starportRelax()
	--check wether the starport defenders can be set back to Neutral (full health starport?)
	if not RogueStarport.IsDead and laststance~=Neutral and RogueStarport.Health >= (RogueStarport.MaxHealth-3000)
	then
		laststance=Neutral
		Trigger.AfterDelay(DateTime.Seconds(3),
			function()
				if not Actor21.IsDead then Actor21.Owner=Neutral end
				if not Actor23.IsDead then Actor23.Owner=Neutral end
				if not Actor27.IsDead then Actor27.Owner=Neutral end
				if not Actor32.IsDead then Actor32.Owner=Neutral end
			end
		)
		if not reloading
		then
			Trigger.AfterDelay(DateTime.Seconds(20),
				function()
					--"reload" the mentat messages
					OrdosMentat[2]="Sire, the Rogues are under attack and ask for our assistance!"
					HarkonnenMentat[2]="Mylord, the Rogues are under attack by the Ordos - shall we help them?"
					reloading=false
				end
			)
		reloading=true	
		end
	end 
end
