-- Amount of Main Players in this game, Players are taken from the first mainplr_count slots
mainplr_count = 2

-- Player information
player_list = {}
main_players = {}
micro_players = {}
is_main = {}

player_count = 0

-- lua mostly copied from:
--  SirCakealot (d2kA)
-- a few scripts from:
--  sin (Top Control)
--  CombinE (Conyard Wars)

-- Information for every unit
ActorRegister = {}
OriginalOwner = {}

-- Game Over Check
team_mains = {}
main_disabled = {}


IsMain = function(plr) return is_main[plr.InternalName] == 1 end
ChatMsg = function(msg) print(msg); Media.DisplayMessage(msg) end
IndexPlayer = function(i) return Player.GetPlayer("Multi"..i) end

function CaptureUnits(act, range)
	-- Change Owner of all units in area
	local center = act.CenterPosition
	local dist = WVec.New(range,range,0)
	local units = Map.ActorsInBox(center-dist,center+dist,function(unit)
		-- Right now only Main Player units can be taken
		if not IsMain(unit.Owner) then return nil end
		-- Are the players allied? Cause taking enemy's units is unfair!
		if not unit.Owner.IsAlliedWith(act.Owner) then return nil end
		-- Only Units, no structures
		if not unit.HasProperty("Move")
		-- Some exceptions
		   and not (unit.Type == "v19" or unit.Type == "hosp" or unit.Type == "bio")
			then return nil end
-- and not unit.HasProperty("Land")
		-- Following Units can't be captured
		if unit.Type == "mcv" then return nil end
		return unit
	end)

	local orig
	for _,u in pairs(units) do
		-- does this unit have any original owner?
		orig = OriginalOwner[tostring(u)]
		if orig ~= nil
		then
			-- yes - only pass if owners do match
			if u.Owner == orig then u.Owner = act.Owner end
		else
			-- no - save owner and pass that unit
			OriginalOwner[tostring(u)] = u.Owner
			u.Owner = act.Owner
		end
	end
	act.Destroy()
end

function ReturnUnits(act, range)
	--Change Owner of all units in area
	local center = act.CenterPosition
	local dist = WVec.New(range,range,0)
	local units = Map.ActorsInBox(center-dist,center+dist,function(unit)
		-- To return an Unit, you need to be Main or Owner of that unit
		if not IsMain(act.Owner) and not act.Owner == unit.Owner then return nil end
		-- Are the players allied? Cause returning enemy's units is unfair!
		if not unit.Owner.IsAlliedWith(act.Owner) then return nil end
		-- Only Units, no structures
		if not unit.HasProperty("Move")
		-- Some exceptions
		   and not (unit.Type == "v19" or unit.Type == "hosp" or unit.Type == "bio")
			then return nil end
		-- Following Units can't be returned
--		if unit.Type == "mcv" then return nil end
		return unit
	end)
	
	local orig
	for _,u in pairs(units) do
		-- does this unit have any original owner?
		orig = OriginalOwner[tostring(u)]
		if orig ~= nil
		then
			-- yes - return unit
			u.Owner = orig
		elseif IsMain(act.Owner) and (u.HasProperty("Move") or u.Type == "v19" or u.Type == "hosp" or u.Type == "bio") then
--			-- no - save owner and pass that unit
--			OriginalOwner[tostring(u)] = u.Owner
			u.Owner = act.Owner
			OriginalOwner[tostring(u)] = act.Owner
		end
	end
	act.Destroy()
end

function ActorsAddedToWorld(newlist,register)
	local new_actor_list={}
	for key,act in pairs(newlist)
	do
		if not register[tostring(act)]
		then
			register[tostring(act)]=true
			table.insert(new_actor_list,act)
		end
	end
	return new_actor_list
end

Tick = function()
	--check register for new actors and only call act.Type == "whatever" when neccessary since it is expensive
	local new_actors = ActorsAddedToWorld(Map.ActorsInWorld,ActorRegister)
	
	for _,act in pairs(new_actors) do
		--ACTOR TYPE CHECKS
		local type = act.Type
		if		type == "actor_capturesingle" then CaptureUnits(act,512)
		elseif	type == "actor_captureunits" then CaptureUnits(act,2560) -- 2x1024+512
		elseif	type == "actor_returnunits" then ReturnUnits(act,2560)
		end
	end
	
	-- Game Over Check
	for i=0,mainplr_count-1 do
		if main_disabled[main_players[i]] ~= 1 then
			if main_players[i].HasNoRequiredUnits() then
				team_mains[main_players[i].Team] = team_mains[main_players[i].Team]-1
				main_disabled[main_players[i]] = 1
				ChatMsg(main_players[i].Name..", Team "..main_players[i].Team.." is disabled now!")
				if team_mains[main_players[i].Team] == 0 then
					for j=0,player_count-mainplr_count-1 do
						if micro_players[j].IsAlliedWith(main_players[i]) then
							for _,act in pairs(micro_players[j].GetActors()) do
								if act.HasProperty("MaxHealth") then act.Kill()
								elseif act.Type == "plractor" then act.Destroy()
								end
							end
						end
					end
				end
			end
		end
	end
end

WorldLoaded = function()
	-- Get the Main Players first
	local player
	local num = 0, found
	local units
	for i=1,mainplr_count do
		player = IndexPlayer(num)
		num = num+1
		if player ~= nil then
			player_list[player_count] = player
			main_players[player_count] = player
			is_main[player.InternalName] = 1
			player_count = player_count+1
			
			if team_mains[player.Team] ~= nil then
				team_mains[player.Team] = team_mains[player.Team]+1
			else
				team_mains[player.Team] = 1
			end
			-- In case of 'if they want to return an unit'
			Actor.Create("ReturnUnitsPower", true, { Owner = player, Location = CPos.New(0,0) })
		else
			-- Main Player not found: Reduce the amount of Main Players
			mainplr_count = mainplr_count-1
		end
	end
	-- gather Micro Players
	for i=1,24 do -- I bet there can be up to 24 Micro Players in a single game
		player = IndexPlayer(num)
		num = num+1
		if player ~= nil then
			-- Save data
			player_list[player_count] = player
			micro_players[player_count-mainplr_count] = player
			is_main[player.InternalName] = 0
			player_count = player_count+1

			-- Micro Players: Remove all their units, set money to zero and replace their MCV with an undestructable Structure
			--	(Structure prevents from loosing instantly)
			player.Cash = 0
			units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.HasProperty("Move") and Actor.Owner == player end)
			for _,u in pairs(units) do u.Destroy() end
			-- Do they have any allied main? Cause Microers without a Main can't do anything!
			found = 0
--			for j=0,mainplr_count-1 do if player.IsAlliedWith(main_players[j]) then ChatMsg(player.Name.." is allied with "..main_players[j].Name) found = 1 end end
			for j=0,mainplr_count-1 do if player.IsAlliedWith(main_players[j]) then found = 1 end end
			if found == 1 then
				Actor.Create("PlrActor",			true, { Owner = player, Location = CPos.New(0,0) })
				Actor.Create("CaptureUnitsPower",	true, { Owner = player, Location = CPos.New(0,0) })
				Actor.Create("ReturnUnitsPower",	true, { Owner = player, Location = CPos.New(0,0) })
				Actor.Create("CaptureSinglePower",	true, { Owner = player, Location = CPos.New(0,0) })
				--Camera.Position = MCV.CenterPosition
			else
				ChatMsg(player.Name.." has no allied Main Player!")
			end
		end
	end

	-- For the Oil Derricks
	units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.Type == "v19" end)
	for _,u in pairs(units) do
		Trigger.OnCapture(u, function(this, captor, old, new)
			local orig = OriginalOwner[tostring(captor)]
			if orig ~= nil then OriginalOwner[tostring(this)] = orig end
		end)
	end

	-- Check for my lua to work
--	ChatMsg("Main count = "..mainplr_count)
--	ChatMsg("Player count = "..player_count)
--	for i=0,player_count-1 do
--		local plr = player_list[i].InternalName
--		j = is_main[plr]
--		if plr ~= nil then
--			ChatMsg("Player "..i.." is main = "..j)
--		end
--	end
end
