-- lua mostly copied from:
-- SirCakealot (d2kA)
-- sin (Top Control)
-- CombinE (Conyard Wars)

script_version_num=0
main_players = {}
player_list = {}
allied_with = {}
player_count = 0
ActorRegister = {}
Game_Over = 0

function CaptureUnits(act)
	--Change Owner of all units in area
	local center = act.CenterPosition
--	local dist = WVec.New(1024,1024,0)
	local dist = WVec.New(1536,1536,0)
	local units = Map.ActorsInBox(center-dist,center+dist,function(unit)
-- and not unit.HasProperty("Land")
		if unit.HasProperty("Move") and unit.Type ~= "mcv" or unit.Type == "v19" or unit.Type == "hosp" or unit.Type == "bio"
			then return unit
			else return nil
		end
	end)
	
	for _,u in pairs(units) do 
		if (u.Owner==main_players[0] or u.Owner==main_players[1]) and u.Owner.IsAlliedWith(act.Owner) then
			u.Owner = act.Owner
		end
	end
	act.Destroy()
end

function ReturnUnits(act)
	--Change Owner of all units in area
	local center = act.CenterPosition
	local dist = WVec.New(2560,2560,0)
	local units = Map.ActorsInBox(center-dist,center+dist,function(unit)
		if unit.HasProperty("Move") or unit.Type == "v19" or unit.Type == "hosp" or unit.Type == "bio"
			then return unit
			else return nil
		end
	end)
	
	local changeto = main_players[0]
	if act.Owner.IsAlliedWith(main_players[1]) then
		changeto = main_players[1]
	end
	
	for _,u in pairs(units) do 
		if u.Owner == act.Owner then
			u.Owner = changeto
		end
	end
	act.Destroy()
end

IndexPlayer = function(i) return Player.GetPlayer("Multi"..i) end

function ActorsAddedToWorld(newlist,register)
	local new_actor_list={}
	for key,act in pairs(newlist)
	do
		if not register[tostring(act)]
		then
			register[tostring(act)]=true
			table.insert(new_actor_list,act)
		end
	end
	return new_actor_list
end

Tick = function()
	--check register for new actors and only call act.Type=="whatever" when neccessary since it is expensive
	local new_actors = ActorsAddedToWorld(Map.ActorsInWorld,ActorRegister)
	
	for _,act in pairs(new_actors) do
		--ACTOR TYPE CHECKS
		local T = act.Type
		if T == "captureunits" then CaptureUnits(act)
		elseif T == "returnunits" then ReturnUnits(act)
		end
	end
	if Game_Over == 0 then
		if main_players[0].HasNoRequiredUnits() then
			for i=0,player_count-1 do
				if player_list[i] ~= main_players[0] and allied_with[i] == 0 then
					local Actors = player_list[i].GetActors()
					for _,u in pairs(Actors) do
						if u.HasProperty("MaxHealth") then u.Kill()
						elseif u.Type == "plractor" then u.Destroy()
						elseif u.Type == "plractor2" then u.Destroy()
						end
					end
				end
			end
			Game_Over = 1
		elseif main_players[1].HasNoRequiredUnits() then
			for i=0,player_count-1 do
				if player_list[i] ~= main_players[1] and allied_with[i] == 1 then
					local Actors = player_list[i].GetActors()
					for _,u in pairs(Actors) do
						if u.HasProperty("MaxHealth") then u.Kill()
						elseif u.Type == "plractor" then u.Destroy()
						elseif u.Type == "plractor2" then u.Destroy()
						end
					end
				end
			end
			Game_Over = 1
		end
	end
end

ChatMsg = function(msg) print(msg); Media.DisplayMessage(msg) end

InitPlayers = function()
--    local players = Player.GetPlayers(function(plr) return plr end)
	for _,p in pairs(player_list) do
		if p ~= main_players[0] and p ~= main_players[1] then
			-- Non-Main Players: Remove all their units, set money to zero and replace their MCV with a undestructable Structure
			p.Cash = 0
			local units = Utils.Where(Map.ActorsInWorld, function(Actor) return Actor.HasProperty("Move") and Actor.Owner == p end)
			if #units ~= 0 then
				for _,u in pairs(units) do
					u.Destroy()
				end
			end
			if p.IsAlliedWith(main_players[0]) or p.IsAlliedWith(main_players[1]) then
				Actor.Create("PlrActor", true, { Owner = p, Location = CPos.New(0,0) })
				Actor.Create("PlrActor2",true, { Owner = p, Location = CPos.New(0,0) })
			end
		end
	end
end

WorldLoaded = function()
	local player
	while 1 do
		player = IndexPlayer(player_count)
		if player == nil then break end
		player_list[player_count] = player
		player_count = player_count+1
	end
--	ChatMsg("Player Count: "..player_count)
	main_players[0]=player_list[0]
	main_players[1]=player_list[1]
	allied_with[0]=0
	allied_with[1]=1
	for i=2,player_count-1 do
		if     main_players[0].IsAlliedWith(player_list[i]) then allied_with[i] = 0
		elseif main_players[1].IsAlliedWith(player_list[i]) then allied_with[i] = 1
		else   allied_with[i] = -1 end
	end
	InitPlayers()
end
