Transports={}
TrackedHijackers={}
TrackedMADTanks={}
MadFactor=0.50

Changelog="FULL CHANGELOG:\nBUILDORDER (more open)\n* Construction Yard provides 30 power.\n* No prerequisites: Refinery, Barracks, Power, Kennel(allies too).\n* Techpath: Power -> Radar Dome + Advanced Power -> Tech Center\n* Radar Dome -> Gap Generator -> Mobile Gap Generator (all allies).\n* Production: Barracks -> Warfactory / Shipyard\n* Service Depot: 800$(-33%), Radar Dome: 1250$(-17%), Advanced Power: 400$(-20%)\n* Radar Dome can't be powered down.\n\nDEFENSES\n* Increased Gap Generator range.\n* Defenses deploy slower and all take the same duration to deploy.\n* Tesla and Gun Turret get submarine detection and can shoot submarines.\n* AA-Gun and SAM Site damage reduced by 25%.\n* SAM Site missile tracking range increased significantly. Missile turn rate reduced.\n* Adds Camo SAM Site to soviet.\n* Rocket Soldiers garrisoned in Pillboxes shoot aircraft.\n\nWARFACTORY (more uses for weak vehicles)\n* MCV build rate reduced to that of all other standard vehicles.\n* Ranger carries two passengers who can shoot while driving. (at reduced ranger range). Detects hijackers.\n* Supply Truck production moved to Silo. Truck cost to 600$. New Silo model.\n* Switched Radar Jammer to be France's special unit.\n* Minelayer ammo capacity doubled.\n* MAD Tank reduces >remaining< hitpoints by 50%.\n* Light Tank can swim.\n\nINFANTRY\n* Spies can only enter Advanced Power. Spy shoots while in Pillbox or Ranger.\n* Hijacker captures instead of beeing crushed.\n* Tanya can swim.\n* Dogs see one cell farther.\n\nAIRCRAFT (more uses)\n* Gives Mig and Longbow stealth and submarine detection and anti-sub weapons.\n* Mig carries separate ammo for air, armored and ground targets. Speed reduced. Less range.\n* Yak turn cicle reduced. Speed reduced. Flight altitude reduced. Cost reduced.\n* Transport Helicopters can transport most vehicles. (most vehicles occupy 5 slots). Cost to 700$(-22%). Explodes less violent.\n* New soviet 'Cossack' transport plane. Parachute-drops loaded vehicles/infantry.\n\nNAVY (more interaction with land)\n* Increased naval Transport capacity. Slows down with cargo. Cost to 1000$(+42%).\n* Gunboat gains more vision. More damage. Less HP (destroyable by one Hind/Yak).\n* Destroyer range increased, rate-of-fire decreased. Anti air capabilities moved to seperate aa-gun.\n* Attack Sub transports two infantry. More damage vs bridge. Improved homing topedoes, less damage. Torpedos no longer jammable.\n* Missile Sub increased range, new homing cruise missiles. AA capabilities removed.\n* New 'Flak Trap' anti-air submarine. 'Deploy' to submerge, can't shoot while submerged.\n----------------------------\n"
StartTip="The Contruction Yard provides 30 power."
RegularTipps={"Allies can build dogs, too. Improved dog vision.","The Service Depot is cheaper, but the MCV takes longer to build.","The Radar Dome is cheaper and its only prerequisite is a power plant.","Ranger can carry two passengers which can shoot while driving.","Light Tanks and Tanya can swim!","Advanced Powerplants are cheaper but are now the only type of power plant vulnerable to the spy!","The Mobile Gap Generator is available for all allies.","The Radar Dome can no longer be powered down.","Gap Genarators have increased range and unlock Mobile Gap Generator.","Soviets get a (stealthed) Camo SAM Site.","Minelayers have doubled ammo capacity.","New Silo which can produce suppy trucks. Support your allies!","Hijacker capture instead of beeing crushed.","Transport Helicopters can transport most vehicles.","The only prerequisites for a Tech Center are Radar Dome and Advanced Power.","The MAD Tank now reduces >remaining< hitpoints by 50%.","New soviet 'Cossack' transport plane which parachute-drops loaded vehicles/infantry.","The Mig now carries separate ammo for air, armored and ground targets!"}
NavalTipps={"The Naval Transport has increased capacity.","Attack Subs can transport two infantry.","The Destroyer has increased range and a different anti-air weapon.","Tesla Coil and Gun Turret can shoot submarines.","Soviet get a new 'Flak Trap' anti-air submarine.","Mig and Longbow have anti-sub weapons!","Missile Subs have an improved weapon, but no anti-air capabilities."}

WorldLoaded = function()
	players=Player.GetPlayers(function(p) return p end)
	table.remove(players) -- remove 'everyone'
	table.remove(players,1) -- remove 'neutral'
	table.remove(players,1) -- remove 'creeps'
	Media.DisplayMessage(Changelog,"")
	ShowTip(StartTip)
	tips_given=0
	Trigger.AfterDelay(DateTime.Seconds(40),function() SelectTip() end)
end

SelectTip = function()
	regulartip=18
	navaltip=7
	
	navalcount=0
	for _,p in pairs(players)
	do if p.HasPrerequisites({"spen"}) or p.HasPrerequisites({"syrd"}) then navalcount = navalcount + 1 end
	end
	
	tryregular=true
	if Utils.RandomInteger(0,2)==1 and navalcount>1
	then 
		start=Utils.RandomInteger(0,5)
		while NavalTipps[start]==nil and start<navaltip
		do start=start+1 
		end
		if start<navaltip 
		then 
			ShowTip(NavalTipps[start])
			NavalTipps[start]=nil
			tryregular=false 
		end
	end
	
	if tryregular
	then
		start=Utils.RandomInteger(tips_given,tips_given+navaltip)
		while RegularTipps[start]==nil and start<regulartip
		do start=start+1 
		end
		if start<regulartip 
		then 
			ShowTip(RegularTipps[start])
			RegularTipps[start]=nil
		end
	end
	
	tips_given=tips_given+1
	Trigger.AfterDelay(DateTime.Minutes(1),function() SelectTip() end)
end

ShowTip = function(tip)
	showtiptome=true
	for _,p in pairs(players)
	do
		if p.IsLocalPlayer and p.HasPrerequisites({"tutorialoff"})
		then
			showtiptome=false
		end
	end
	if showtiptome then  Media.DisplayMessage(tip,"Tip",HSLColor.FromRGB(138,43,226)) end
end

Tick = function()
	local cossacks
	local hijackers={}
	local MADTanks={}
	for _,p in pairs(players) 
	do 
		--handle cossacks
		cossacks = p.GetActorsByType("cossack") 
		for _,c in pairs(cossacks) 
		do
			if c.AmmoCount("primary")<1 and Transports[tostring(c)]==nil
			then
				Transports[tostring(c)]='unloading'
				local start=c.Location
				local angle=c.Facing/255*2*math.pi
				local dist=5
				local vector=CVec.New(-math.floor(math.sin(angle)*dist),-math.floor(math.cos(angle)*dist))
				c.Paradrop(start+vector)
			elseif c.AmmoCount("primary")==1 and Transports[tostring(c)]=='unloading'
			then 
				Transports[tostring(c)]=nil
				c.Paradrop(CPos.New(0,0)) --HACK: relocate (non-removable) landing zone to remote location
				c.Stop()
			--transports killed while unlading will remain in the list forever, but will not appear in GetActorsByType, so no problem there. this is better for performance then checking and removing.
			end
		end
		--handle hijackers
		hijackers = p.GetActorsByType("hijacker")
		for _,h in pairs(hijackers)
		do
			if not TrackedHijackers[tostring(h)]
			then 
				TrackedHijackers[tostring(h)]=true
				Trigger.OnKilled(h,function(act,killer)
					local target=Map.ActorsInCircle(Map.CenterOfCell(act.Location),WDist.New(1000),function(actor)
						if actor==killer
						then 
							local T=actor.Type
							if T=="1tnk" or T=="2tnk" or T=="3tnk" or T=="4tnk" or T=="harv" or T=="apc" or T=="mcv" or T=="mnly" or T=="stnk" or T=="qtnk" or T=="ctnk" or T=="ttnk"
							then return actor
							else return nil
							end
						else return nil
						end
						end)
					if target[1] 
					then 
						target[1].Owner=act.Owner
						target[1].Stop() 
					end
					end)
			end
		end
		--handle mad tanks
		MADTanks = p.GetActorsByType("qtnk")
		for _,mad in pairs(MADTanks)
		do
			if not TrackedMADTanks[tostring(mad)]
			then 
				TrackedMADTanks[tostring(mad)]=true
				Trigger.OnKilled(mad,function(act,killer)
					if killer==act 
					then
						local targets=Map.ActorsInCircle(Map.CenterOfCell(act.Location),WDist.New(7168),function(act)
							if not act.HasProperty("Move") and act.HasProperty("Health")
							then return act
							else return nil
							end
							end)
						for _,t in pairs(targets)
						do
							t.Health=t.Health*(1-MadFactor)
						end
					end
					end)
			end
		end
	end	
end