--[[
   Copyright 2007-2017 The OpenRA Developers (see AUTHORS)
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

RepairThreshold = 0.6

GdiBase = { GdiFact1, GdiNuke1, GdiProc1, GdiNuke3, GdiNuke2, GdiPyle1, GdiSilo1, GdiSilo2, GdiHarv }
GdiUnits = { "e3", "e3", "e3", "e3", "e1", "e1", "e1", "e1", "e1", "mtnk", "mtnk", "jeep", "jeep", "apc" }

AutocreateSquads =
{
	{ "ltnk", "ltnk", "ltnk" }
}

AutocreateInfantrySquads =
{
	{ "e1", "e1", "e1", "e1", "e3" }
}

AutocreateInfantrySquads2 =
{
	{ "e1", "e1", "e1", "e1", "e3", "e3", "e4" }
}

AutocreateFactorySquads =
{
	{ "htnk" },
	{ "mtnk", "mtnk" },
}

SquadHunt = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AttackRally.Location, 50)
			actor.Hunt()
		end)
	end)
end

WestSquadHunt = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(WestRally.Location, 50)
			actor.Hunt()
		end)
	end)
end

EastSquadHunt = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(EastRally.Location, 50)
			actor.Hunt()
		end)
	end)
end


NodVehicleProduction = function(Squad)
	if Airfield.IsDead or not Airfield.Owner == enemy then
		return
	end
	Airfield.Build(Squad, SquadHunt)
end

NodInfantryProduction = function(Squad)
	if Hand1.IsDead or not Hand1.Owner == enemy then
		return
	end
	Hand1.Build(Squad, SquadHunt)
end


NodVehicleProduction2 = function(Squad)
	if Airfield2.IsDead or not Airfield2.Owner == enemy then
		return
	end
	Airfield2.Build(Squad, SquadHunt)
end

NodInfantryProduction2 = function(Squad)
	if Hand2.IsDead or not Hand2.Owner == enemy then
		return
	end
	Hand2.Build(Squad, SquadHunt)
end

NodFactoryProduction = function(Squad)
	if CapturedFactory.IsDead or not CapturedFactory.Owner == enemy then
		return
	end
	CapturedFactory.Build(Squad, WestSquadHunt)
end

NodInfantryProduction3 = function(Squad)
	if Hand2.IsDead or not Hand2.Owner == enemy then
		return
	end
	Hand2.Build(Squad, EastSquadHunt)
end


AutoCreateTeam = function()
	NodVehicleProduction(Utils.Random(AutocreateSquads))
	NodInfantryProduction(Utils.Random(AutocreateInfantrySquads))
	Trigger.AfterDelay(DateTime.Seconds(40), AutoCreateTeam)
end

AutoCreateTeam2 = function()
	NodVehicleProduction2(Utils.Random(AutocreateSquads))
	NodInfantryProduction2(Utils.Random(AutocreateInfantrySquads))
	Trigger.AfterDelay(DateTime.Seconds(30), AutoCreateTeam2)
end

AutoCreateMammothTanks = function()
	NodFactoryProduction(Utils.Random(AutocreateFactorySquads))
	NodInfantryProduction3(Utils.Random(AutocreateInfantrySquads2))
	Trigger.AfterDelay(DateTime.Seconds(50), AutoCreateMammothTanks)
end

DiscoverGdiBase = function(actor, discoverer)
	if baseDiscovered or not discoverer == player then
		return
	end

	Utils.Do(GdiBase, function(actor)
		actor.Owner = player
	end)

	baseDiscovered = true

	gdiObjective3 = player.AddPrimaryObjective("Eliminate all Nod forces in the area.")
	player.MarkCompletedObjective(gdiObjective1)
	
	--AutoCreateTeam2()
end

StartProduction = function(type)
	if Hand1.IsInWorld and Hand1.Owner == enemy then
		Hand1.Build(type)
		Trigger.AfterDelay(DateTime.Seconds(30), function() StartProduction(type) end)
	end
end

InsertGdiUnits = function()
	Media.PlaySpeechNotification(player, "Reinforce")
	Reinforcements.Reinforce(player, GdiUnits, { UnitsEntry.Location, UnitsRally.Location }, 15)
end



--[[
IdleHunt = function(unit)
	if not unit.IsDead then
		Trigger.OnIdle(unit, unit.Hunt)
	end
end
--]]

WorldLoaded = function()
	player = Player.GetPlayer("GDI")
	gdiBase = Player.GetPlayer("AbandonedBase")
	enemy = Player.GetPlayer("Nod")

	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)
	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)

	Trigger.OnPlayerWon(player, function()
		Media.PlaySpeechNotification(player, "Win")
	end)

	Trigger.OnPlayerLost(player, function()
		Media.PlaySpeechNotification(player, "Lose")
	end)

	--[[
	Utils.Do(Map.NamedActors, function(actor)
		if actor.Owner == enemy and actor.HasProperty("StartBuildingRepairs") then
			Trigger.OnDamaged(actor, function(building)
				if building.Owner == enemy and building.Health < RepairThreshold * building.MaxHealth then
					building.StartBuildingRepairs()
				end
			end)
		end
	end)
	--]]

	
	gdiObjective1 = player.AddPrimaryObjective("Find the GDI base.")
	--gdiObjective2 = player.AddSecondaryObjective("Destroy all SAM sites to receive air support.")
	nodObjective = enemy.AddPrimaryObjective("Destroy all GDI troops.")

	--Trigger.AfterDelay(DateTime.Seconds(40), function() StartProduction({ "e1" }) end)

	Trigger.OnPlayerDiscovered(gdiBase, DiscoverGdiBase)

	Trigger.AfterDelay(DateTime.Seconds(40), AutoCreateTeam)
	
	Trigger.AfterDelay(DateTime.Seconds(960), AutoCreateMammothTanks)

	
	Camera.Position = UnitsRally.CenterPosition

	InsertGdiUnits()
end

Tick = function()
	if player.HasNoRequiredUnits() then
		if DateTime.GameTime > 2 then
			enemy.MarkCompletedObjective(nodObjective)
		end
	end
	if baseDiscovered and enemy.HasNoRequiredUnits() then
		player.MarkCompletedObjective(gdiObjective3)
	end
	
	if not firstBaseDefeated then
		if not Hand1.IsInWorld or Hand1.Owner == player then
			firstBaseDefeated = true
			
			Trigger.AfterDelay(DateTime.Seconds(20), AutoCreateTeam2)
		end
	end
	
end
