ChoosePOW2 =
{
	{ type = "powr", pos = CPos.New(21, 91), cost = 300 }
}

BuildPOW2 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePOW2) do
		if not v.exists then
			PlacePOW2(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW2)
end

PlacePOW2 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW2)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPOW2)
	end)
end

CheckHealthForPOW2 = function()
	Trigger.OnDamaged(POW2, function()
		if POW2.Owner == Player1 and POW2.Health < POW2.MaxHealth * 3/4 then
			POW2.StartBuildingRepairs()
		end
		if POW2.Owner == Player1 and POW2.Health < POW2.MaxHealth * 1/4 then
			POW2.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW2, BuildPOW2)
end