NormalUnitTypes =
{
	{ "e1", "e1", "e1", "e1", "e1" },
	{ "e3", "e3", "e3", "e3", "e3" },
	{ "e1", "e1", "e1", "e3", "e3" }
}

HardUnitTypes =
{
	{ "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" }
}

CheckExistenceForSCY1 = function()
	ConYard = Map.ActorsInBox(MCVTopLeft.CenterPosition, MCVBottomRight.CenterPosition, function(actor)
		return actor.Type == "fact" and actor.Owner == Player1
	end)

	return #ConYard >= 1
end

CheckHealth = function()
	if Map.LobbyOption("difficulty") == "hard" or Map.LobbyOption("difficulty") == "normal" then
		CheckHealthForSCY1()
		CheckHealthForPOW1()
		CheckHealthForPOW2()
		CheckHealthForTEN1()
		CheckHealthForPBO1()
		CheckHealthForPBO2()
		CheckHealthForPBO3()
		CheckHealthForPRO1()
		CheckHealthForSIL1()
	end
end

CheckHealthForSCY1 = function()
	Trigger.OnDamaged(SCY1, function()
		if SCY1.Owner == Player1 and SCY1.Health < SCY1.MaxHealth * 3/4 then
			SCY1.StartBuildingRepairs()
		end
		if SCY1.Owner == Player1 and SCY1.Health < SCY1.MaxHealth * 1/4 then
			SCY1.Sell()
		end
	end)

	Trigger.OnRemovedFromWorld(SCY1, StopUnitProduction)
end

StopUnitProduction = function()
	if TENSDestroyed then
		return
	end

	TENS.Destroy()
	TENSDestroyed = true
end

ProduceUnits = function()
	if Map.LobbyOption("difficulty") == "normal" or Map.LobbyOption("difficulty") == "easy" then
		local toBuild = Utils.Random(NormalUnitTypes)
		Player1.Build( toBuild, function(units)
			CreateTeam(units)
		end)
	end
	if Map.LobbyOption("difficulty") == "hard" then
		local toBuild = Utils.Random(HardUnitTypes)
		Player1.Build( toBuild, function(units)
			CreateTeam(units)
		end)
	end
end

CreateTeam = function(units)
	Utils.Do(units, function(unit)
		SendAttack(unit)
	end)
end

SendAttack = function(unit)
	if not unit.IsDead then
		Trigger.OnIdle(unit, unit.Hunt) 
	end 
end

ShowMissionDetails = function()
	Media.DisplayMessage("There is an additional side ready for challenge.", "Battlefield Control")
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Besides other possible opponents also Spain must be defeated in order to accomplish this mission.", "Battlefield Control")
	end)
end

CheckExistenceForInitialUnits = function()
	Guard1Exists = true
	Guard2Exists = true
	Guard3Exists = true
	Guard4Exists = true
	Guard5Exists = true
	Technician1Exists = true
	Technician2Exists = true

	Trigger.OnKilled(Guard1, function() Guard1Exists = false end)
	Trigger.OnKilled(Guard2, function() Guard2Exists = false end)
	Trigger.OnKilled(Guard3, function() Guard3Exists = false end)
	Trigger.OnKilled(Guard4, function() Guard4Exists = false end)
	Trigger.OnKilled(Guard5, function() Guard5Exists = false end)
	Trigger.OnKilled(Technician1, function() Technician1Exists = false end)
	Trigger.OnKilled(Technician2, function() Technician2Exists = false end)
end

SendDefence = function()
	local defenders = Player1.GetGroundAttackers()
	if #defenders > 0 then
		Utils.Do(defenders, function(unit)
			unit.Hunt()

			if Guard1Exists then
				Guard1.Stop()
			end
			if Guard2Exists then
				Guard2.Stop()
			end
			if Guard3Exists then
				Guard3.Stop()
			end
			if Guard4Exists then
				Guard4.Stop()
			end
			if Guard5Exists then
				Guard5.Stop()
			end
			if Technician1Exists then
				Technician1.Stop()
			end
			if Technician2Exists then
				Technician2.Stop()
			end
		end)
	end
end

ConsiderProtectionForHarvesters = function()
	Trigger.AfterDelay(DateTime.Seconds(60), function()
		DisableProtectionForHarvesters = false
		CheckHealthForHarvesters()
	end)
end

CheckHealthForHarvesters = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local Harvester = Player1.GetActorsByType("harv")

		Utils.Do(Harvester, function(unit)
			Trigger.OnDamaged(unit, function()
				if not DisableProtectionForHarvesters then
					SendDefence()
					DisableProtectionForHarvesters = true
				end
			end)
		end)
	end)
end

WorldLoaded = function()
	Player1 = Player.GetPlayer("Spain")
	Player1.Cash = 0

	Player2 = Player.GetPlayer("Multi0")
	Player3 = Player.GetPlayer("Multi1")
	Player4 = Player.GetPlayer("Multi2")
	Player5 = Player.GetPlayer("Multi3")

	ShowMissionDetails()
	CheckHealth()
	CheckExistenceForInitialUnits()
	CheckHealthForHarvesters()
	ConsiderProtectionForHarvesters()
end

Tick = function()
	if DateTime.GameTime % 100 == 0 then
		ProduceUnits()
	end
end