mdesc0 = "Welcome to last MCV standing\nThis is a fun Map and mostly depends on luck\nDrive around with your MCV and try to survive the bombardment\nYour MCV can´t deploy but it can chronoshift"
mdesc1 = "The Ground will break, so keep moving, because your MCV can´t swim\nThere are also some Healcrates, but use them wisely\nLast MCV alive wins\nMap done by V ( Trempler )"
mdesc2 = "3"
mdesc3 = "2"
mdesc4 = "1"
mdesc5 = "Go!"
fartsound = "teleport.wav"
fartsound2 = "teleport.wav"
counter = "mini.wav"

WorldLoaded = function()
	local civPlayer = Player.GetPlayer("Civilians")
	Creeps = Player.GetPlayer("Creeps")

	Players = { }
	Objectives = { }
	for h = 0, 11 do
		local player = Player.GetPlayer("Multi" .. h)
		if player then
			Players[h + 1] = player

			Objectives[player] = { }
			Objectives[player][1] = player.AddSecondaryObjective("Survive round 01!")
			Objectives[player][2] = player.AddSecondaryObjective("Survive round 02!")
			Objectives[player][3] = player.AddSecondaryObjective("Survive round 03!")
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(1), MapDesc0)
	Media.StopMusic()

	SpawnTiles()

	SpawnMCVs()
end

MapDesc0 = function()
	Media.PlaySound(fartsound)
	Media.DisplayMessage(mdesc0)
	Trigger.AfterDelay(DateTime.Seconds(10), MapDesc1)
end

MapDesc1 = function()
	Media.PlaySound(fartsound2)
	Media.DisplayMessage(mdesc1)
	Trigger.AfterDelay(DateTime.Seconds(10), MapDesc2)
end

MapDesc2 = function()
	Media.PlaySound(counter)
	Media.DisplayMessage(mdesc2)
	Trigger.AfterDelay(DateTime.Seconds(1), MapDesc3)
end

MapDesc3 = function()
	Media.DisplayMessage(mdesc3)
	Trigger.AfterDelay(DateTime.Seconds(1), MapDesc4)
end

MapDesc4 = function()
	Media.DisplayMessage(mdesc4)
	Trigger.AfterDelay(DateTime.Seconds(1), MapDesc5)
end

MapDesc5 = function()
	Media.PlaySound(fartsound)
	Media.DisplayMessage(mdesc5)
	Trigger.AfterDelay(DateTime.Seconds(1), CruiserBuild)
end

Cruisers = { }
CruiserBuild = function()
	Media.PlayMusic()

	Cruisers[1] = Actor.Create("ca", true, { Location = CPos.New(58,58), Owner = Creeps })
	Cruisers[2] = Actor.Create("ca", true, { Location = CPos.New(59,32), Owner = Creeps })
	Cruisers[3] = Actor.Create("ca", true, { Location = CPos.New(58,6), Owner = Creeps })
	Cruisers[4] = Actor.Create("ca", true, { Location = CPos.New(32,5), Owner = Creeps })
	Cruisers[5] = Actor.Create("ca", true, { Location = CPos.New(6,6), Owner = Creeps })
	Cruisers[6] = Actor.Create("ca", true, { Location = CPos.New(5,32), Owner = Creeps })
	Cruisers[7] = Actor.Create("ca", true, { Location = CPos.New(6,58), Owner = Creeps })
	Cruisers[8] = Actor.Create("ca", true, { Location = CPos.New(32,59), Owner = Creeps })

	Trigger.AfterDelay(0, function() ingame = true end)
end

Tiles = { }
SpawnTiles = function()
	local index = 1
	for i = 10,55 do
		for j = 9,54 do
			local tile = Tiles[index]

			if tile and not tile.IsDead then
				tile.Health = tile.MaxHealth
			else
				Tiles[index] = Actor.Create("maptile1b", true, { Location = CPos.New(i, j), Owner = Creeps })
			end

			index = index + 1
		end
	end
end

Spawns = { Spawn1, Spawn2, Spawn3, Spawn4, Spawn5, Spawn6, Spawn7, Spawn8, Spawn9, Spawn10, Spawn11, Spawn12 }
SpawnMCVs = function()
	local spawns = Utils.Shuffle(Spawns)
	local index = 1

	Utils.Do(Players, function(player)
		Actor.Create("mcv", true, { Owner = player, Location = spawns[index].Location })
		index = index + 1
	end)
end

Round = 1
NextRound = function()
	Round = Round + 1
	SpawnTiles()
	SpawnMCVs()

	Media.DisplayMessage("Round " .. Round)
	Trigger.AfterDelay(DateTime.Seconds(1), MapDesc2)
end

Tick = function()
	if ingame then
		local alive = Utils.Where(Players, function(player)
			if player.HasNoRequiredUnits() then
				player.MarkFailedObjective(Objectives[player][Round])
				return false
			end

			return true
		end)

		if #alive == 1 then
			ingame = false

			local winner = alive[1]
			winner.MarkCompletedObjective(Objectives[winner][Round])
			Media.DisplayMessage("" .. winner.Name .. " won the round!")
			Utils.Do(winner.GetActorsByType("mcv"), function(m) if not m.IsDead then m.Destroy() end end)
			if Round == 3 then
				Media.DisplayMessage("GAME OVER!")
				return
			end

			Media.DisplayMessage("Next round in 10 seconds...")
			Utils.Do(Cruisers, function(c) if not c.IsDead then c.Destroy() end end)
			Trigger.AfterDelay(DateTime.Seconds(10), NextRound)
		elseif #alive < 1 then
			ingame = false
			Media.DisplayMessage("Noone won.")
			if Round == 3 then
				Media.DisplayMessage("GAME OVER!")
				return
			end

			Media.DisplayMessage("Next round in 10 seconds...")
			Utils.Do(Cruisers, function(c) if not c.IsDead then c.Destroy() end end)
			Trigger.AfterDelay(DateTime.Seconds(10), NextRound)
		end
	end
end

