--This is a showcase map for a better understanding how a flaggame can be built in openra and for explaining a bit how lua works.
--I tryed to keep this as simple as possible further versions with more stuff inside will follow.


CTFFLagtypes = {"ctflag", "ctflagra", "ctmidflag"}	 -- add here new flag types defined in the rules.yaml

CTbs = {"oilb", "gap", "spen", "syrd", "silo", "miss"} 	-- these are the building types wich get captured with a flag. Only buildings that are there from beginning will be captured that way. You can list there up to 18 building types for more add more CTbs[19] 3 lines below

function GetNearFlag (flag) -- function for flag trigger and capture
		local flagactors = Map.ActorsInCircle(flag.CenterPosition , WDist.FromCells(10), function(bld)-- with this line the game checks the area 10 cells around the flag for buildings that will be captured with flag. WDist.FromCells(10) can be changed to any other value

			return  bld.Type == CTbs[1] or  bld.Type == CTbs[2] or  bld.Type == CTbs[3] or  bld.Type == CTbs[4] or  bld.Type == CTbs[5] or  bld.Type == CTbs[6] or  bld.Type == CTbs[7] or  bld.Type == CTbs[8] or  bld.Type == CTbs[9] or  bld.Type == CTbs[10] or  bld.Type == CTbs[11]or  bld.Type == CTbs[12] or  bld.Type == CTbs[13] or  bld.Type == CTbs[14] or  bld.Type == CTbs[15]or  bld.Type == CTbs[16] or  bld.Type == CTbs[17] or  bld.Type == CTbs[18]
		end)
	Trigger.OnEnteredProximityTrigger(flag.CenterPosition, WDist.FromCells(3), function(a, id)	-- this is the flagtrigger ich changed "WDist.FromCells(3)" for this map to make the flags on the islands better captureable usally i use a way distance of 2

		local mine = flag.Owner		-- simple variables
		local yours = a.Owner

		if mine ~= yours and  mine.IsAlliedWith(yours) ~= true and yours ~= Neutral and yours ~= Player.GetPlayer("Creeps") and Actor.CruiseAltitude(a.Type) == 0 and a.Type ~= "1tnk.husk" and a.Type ~= "2tnk.husk" and a.Type ~= "3tnk.husk" and a.Type ~= "4tnk.husk" and a.Type ~= "harv.fullhusk" and a.Type ~= "harv.emptyhusk" and a.Type ~= "mcv.husk" and a.Type ~= "mgg.husk" and a.Type ~= "camera" and a.Type ~= "camera.paradrop" and a.Type ~= "camera.spyplane" and a.Type ~= "lst"  then		
-- the cases in wich the flag should not be captured.  ~= means is not 
-- i excluded "lst" for this map, transportships should not be able to capture flags in this version
-- You could also type   if aType == "e6"  for example if only engies should be able to capture flags

			flag.Owner = yours				-- with this line the flag changes its owner

			if flagactors ~= nil  then 				-- these lines are for the buildings that will be captured with the flag
				for i,v in ipairs(flagactors) do	-- a counter for the buildings
					if v ~= nil then
						v.Owner = yours  			-- buildings changes owner
					end
				end 
			end
		end
	end)	
end


-- set up Flags
GetandsetFlags = function()
	CTFlags = {}
	Trigger.AfterDelay(DateTime.Seconds(1), function()	-- wait 1 second if you got lines like these with ( dont forgett to close it at  end)  below

		for i=1,#CTFFLagtypes do		-- all flagtypes get counted by type
			local T1 = Neutral.GetActorsByType(CTFFLagtypes[i])		--here the game gets the flags that are spreaded on the map owned by the neutral player
			if T1 ~= nil then
				joinMyTables(CTFlags, T1)	
			end
		end
	end)
	
	Trigger.AfterDelay(DateTime.Seconds(2), function()	 -- fuse flags after a delay of 2 sec
		for k,v in ipairs(CTFlags) do		-- flags getting counted
			GetNearFlag(v)					-- here the function above getting loaded (v) stands for all the flags
		end
		return CTFlags
	end)
end

num = 0
function joinMyTables(t1, t2) -- simple join tables
	for k,v in ipairs(t2) do
		table.insert(t1, v)
		num = num + 1
	end 
	return t1
end

function WorldLoaded()		-- the worldloaded funtion getting started at the beginning of the game, call not needed ;D
	Neutral = Player.GetPlayer("Neutral")		-- needed for that lua knows who the neutral player is

	GetandsetFlags()	-- with this function call the flag setup starts

	Trigger.AfterDelay(DateTime.Seconds(3), function()		-- 3 sec delay ...
		Media.DisplayMessage("capture flags to get money")	-- player announcements
	end)

end
