
Mutants = { "pvice" }
Mutantsx2 = { "pvice", "pvice" }
Arachnotron = { "bspi" }
Arachnotronx2 = { "bspi", "bspi" }
Reve = { "reve" }
Revex2 = { "reve", "reve" }
Imp = { "imp" }
Impx2 = { "imp", "imp" }
Demon = { "pinky" }
Demonx2 = { "pinky", "pinky" }
Mancubus = { "manc" }
Mancubusx2 = { "manc", "manc" }

EggWaves =
{
	{ delay = 30, units = { Mutants } },
	{ delay = 42, units = { Mutantsx2 } },
	{ delay = 55, units = { Mutants, Arachnotron } },
	{ delay = 71, units = { Mutants, Mutantsx2, Arachnotronx2 } },
	{ delay = 18, units = { Mutants } },
	{ delay = 53, units = { Mutants, Reve, Mutants } },
	{ delay = 67, units = {  } },
	{ delay = 1, units = { Mutantsx2, Arachnotron } },
	{ delay = 40, units = {  } },
	{ delay = 1, units = { Mutantsx2, Mutants, Mutantsx2 } },
	{ delay = 80, units = {  } },
	{ delay = 1, units = { Mutantsx2, Arachnotron, Mutants, Mutantsx2 } },
	{ delay = 60, units = {  } },
	{ delay = 1, units = { Mutantsx2, Mutants, Arachnotron, Reve, Mutantsx2 } },
	{ delay = 110, units = {  } },
	{ delay = 1, units = { Arachnotron, Imp, Mutants, Mutants } },
	{ delay = 138, units = {  } },
	{ delay = 1, units = { Reve, Mutantsx2, Arachnotronx2, Imp, Mutantsx2 } },
	{ delay = 148, units = {  } },
	{ delay = 1, units = { Imp, Arachnotronx2, Mutantsx2, Mutantsx2, Reve } },
	{ delay = 124, units = {  } },
	{ delay = 1, units = { Imp, Mutantsx2, Reve } },
	{ delay = 112, units = {  } },
	{ delay = 1, units = { Imp, Reve, Arachnotronx2, Mutantsx2 } },
	{ delay = 120, units = {  } },
	{ delay = 1, units = { Mutants, Mutantsx2, Mancubus } },
	{ delay = 124, units = {  } },
	{ delay = 1, units = { Demon, Mutantsx2, Mutantsx2, Imp, Reve } },
	{ delay = 146, units = {  } },
	{ delay = 1, units = { Demon, Arachnotronx2, Demon, Mutantsx2 } },
	{ delay = 165, units = {  } },
	{ delay = 1, units = { Mutants, Mutants, Mancubus, Mutantsx2, Reve } },
	{ delay = 140, units = {  } },
	{ delay = 1, units = { Mancubus, Mancubus, Mutantsx2, Arachnotronx2 } }
}

Egg1MonsterEntryPoints = { Egg1.Location - CVec.New(1, 0), Egg1.Location + CVec.New(0, 1) }
Egg1PathPoints = { Waypoint16, Waypoint15, Waypoint14, Waypoint13, Waypoint12, Waypoint1 }

Egg2MonsterEntryPoints = { Egg2.Location - CVec.New(1, 0), Egg2.Location + CVec.New(0, 1) }
Egg2PathPoints = { Waypoint26, Waypoint25, Waypoint24, Waypoint23, Waypoint22, Waypoint2 }

Egg3MonsterEntryPoints = { Egg3.Location + CVec.New(1, 0), Egg3.Location + CVec.New(0, 1) }
Egg3PathPoints = { Waypoint35, Waypoint34, Waypoint33, Waypoint32, Waypoint3 }

Egg4MonsterEntryPoints = { Egg4.Location + CVec.New(1, 0), Egg4.Location - CVec.New(0, 1) }
Egg4PathPoints = { Waypoint45, Waypoint44, Waypoint43, Waypoint42, Waypoint4 }

SendUnits = function(entryCell, unitTypes, path)
	Reinforcements.Reinforce(Creeps, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Utils.Do(path, function(cell)
				a.Move(cell.Location)
			end)

			Trigger.OnIdle(a, function(a)
				a.Move(path[#path].Location)
			end)
			return
		end

		Utils.Do(path, function(cell)
			a.AttackMove(cell.Location)
		end)

		Trigger.OnIdle(a, function(a)
			a.Hunt()
		end)
	end)
end

EggSendWave = function(egg, waves, wave, entries, path)
	if egg.IsDead then
		return
	end

	wave = wave + 1
	local waveContents = waves[wave]
	Trigger.AfterDelay(DateTime.Seconds(waveContents.delay), function()
		Utils.Do(waveContents.units, function(units)
			local entry = Utils.Random(entries)
			SendUnits(entry, units, path)
		end)

		if wave >= #waves then
			wave = 0

			local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
			Utils.Do(waves, function(w)
				w.units[#w.units + 1] = Utils.Random(additions)
			end)
		end

		EggSendWave(egg, waves, wave, entries, path)
	end)
end

StartWaves = function()
	EggSendWave(Egg1, EggWaves, 0, Egg1MonsterEntryPoints, Egg1PathPoints)
	EggSendWave(Egg2, EggWaves, 0, Egg2MonsterEntryPoints, Egg2PathPoints)
	EggSendWave(Egg3, EggWaves, 0, Egg3MonsterEntryPoints, Egg3PathPoints)
	EggSendWave(Egg4, EggWaves, 0, Egg4MonsterEntryPoints, Egg4PathPoints)
end
