Transports={}
TrackedHijackers={}
TrackedMADTanks={}
MadFactor=0.50

WorldLoaded = function()
	players=Player.GetPlayers(function(p) return p end)
	table.remove(players) -- remove 'everyone'
	table.remove(players,1) -- remove 'neutral'
	table.remove(players,1) -- remove 'creeps'
end

Tick = function()
	local cossacks
	local hijackers={}
	local MADTanks={}
	for _,p in pairs(players) 
	do 
		--handle cossacks
		cossacks = p.GetActorsByType("cossack") 
		for _,c in pairs(cossacks) 
		do
			if c.AmmoCount("primary")<1 and Transports[tostring(c)]==nil
			then
				Transports[tostring(c)]='unloading'
				local start=c.Location
				local angle=c.Facing/255*2*math.pi
				local dist=5
				local vector=CVec.New(-math.floor(math.sin(angle)*dist),-math.floor(math.cos(angle)*dist))
				c.Paradrop(start+vector)
			elseif c.AmmoCount("primary")==1 and Transports[tostring(c)]=='unloading'
			then 
				Transports[tostring(c)]=nil
				c.Paradrop(CPos.New(0,0)) --HACK: relocate (non-removable) landing zone to remote location
				c.Stop()
			--transports killed while unlading will remain in the list forever, but will not appear in GetActorsByType, so no problem there. this is better for performance then checking and removing.
			end
		end
		--handle hijackers
		hijackers = p.GetActorsByType("hijacker")
		for _,h in pairs(hijackers)
		do
			if not TrackedHijackers[tostring(h)]
			then 
				TrackedHijackers[tostring(h)]=true
				Trigger.OnKilled(h,function(act,killer)
					local target=Map.ActorsInCircle(Map.CenterOfCell(act.Location),WDist.New(1000),function(actor)
						if actor==killer
						then 
							local T=actor.Type
							if T=="1tnk" or T=="2tnk" or T=="3tnk" or T=="4tnk" or T=="harv" or T=="apc" or T=="mcv" or T=="mnly" or T=="stnk" or T=="qtnk" or T=="ctnk" or T=="ttnk"
							then return actor
							else return nil
							end
						else return nil
						end
						end)
					if target[1] 
					then 
						target[1].Owner=act.Owner
						target[1].Stop() 
					end
					end)
			end
		end
		--handle mad tanks
		MADTanks = p.GetActorsByType("qtnk")
		for _,mad in pairs(MADTanks)
		do
			if not TrackedMADTanks[tostring(mad)]
			then 
				TrackedMADTanks[tostring(mad)]=true
				Trigger.OnKilled(mad,function(act,killer)
					if killer==act 
					then
						local targets=Map.ActorsInCircle(Map.CenterOfCell(act.Location),WDist.New(7168),function(act)
							if not act.HasProperty("Move") and act.HasProperty("Health")
							then return act
							else return nil
							end
							end)
						for _,t in pairs(targets)
						do
							t.Health=t.Health*(1-MadFactor)
						end
					end
					end)
			end
		end
	end	
end