Players = {}
Creeps = {}
Rounds = 3

DefenceCycle = {'tsla'} -- ,'ftur','gun','pbox','tsla'

Round = {
	Number = 1,
	Status = 0, -- 0 = not started, 1 = spawning units, 2 = in progress, 2 = finished
	Times = {},
	TimesStatus = {},
	CreepsReleased = false
}

MissionText = {
	Title = "First to " .. Rounds .. " rounds",
	Scores = "",
	Countdown = ""
}

GameReady = false

Starts = {
	{
		path = {CPos.New(1,1), CPos.New(5,5)},
		name = 'Top Left'
	},{
		path = {CPos.New(48,48), CPos.New(44,44)},
		name = 'Bottom Right'
	},{
		path = {CPos.New(48,1), CPos.New(44,5)},
		name = 'Top Right'
	},{
		path = {CPos.New(1,48), CPos.New(5,44)},
		name = 'Bottom Left'
	}
}

Positions = {
	DeathCam = CPos.New(24,24),
	Crates = {
						CPos.New(16, 8),	CPos.New(29, 4),
	CPos.New(11,20),	CPos.New(19,19),	CPos.New(29,19),	CPos.New(45,13),
	CPos.New(10,29),	CPos.New(19,29),	CPos.New(29,29),	CPos.New(46,30),
						CPos.New(17,43),	CPos.New(33,43)
	}
}

OuterDefences = {
	{8,1,9,1}, {24,1,25,1}, {40,1,41,1}, -- T
	{48,10,48,12}, {48,23,48,24}, {48,38,48,42}, -- R
	{40,48,41,48}, {24,48,25,48}, {6,48,10,48}, -- B
	{1,7,1,8}, {1,21,1,24}, {1,39,1,42} --L
}

InnerDefences = {
	{13,14,13,15}, {14,13,14,15}, {15,12,15,15}, {16,12,16,13}, -- TL
	{32,12,32,15}, {33,14,33,15}, -- TR
	{16,34,16,35}, {15,34,15,35}, {14,32,14,35}, {13,32,13,35}, -- BL
	{31,35,33,35}, {32,34,33,34}, {32,33,33,33}, {32,32,33,32} --BR
}

function OnPlayerLost(player_object)
	player_id = PlayerIdFromPlayer(player_object)
	for j, w in pairs(player_object.GetActors()) do
		if w.HasProperty('Health') and w.IsInWorld then
			w.Kill()
		end
	end
	Players[player_id].State = 'lost'
	RefreshScores()
end

function InitPlayers()
	local names = {'Multi0', 'Multi1', 'Multi2', 'Multi3'}
	for i,v in pairs(names) do
		local player = Player.GetPlayer(v)
		if player ~= nill then
			Players[#Players+1] = {
				Ref = v,
				Name = player.Name,
				Object = player,
				State = 'alive',
				Squad = nil,
				Start = nil,
				Wins = 0,
				Bonus = 0,
				DeathCam = nil,
				Objective = player.AddPrimaryObjective("Be the last one standing for " .. Rounds .. " rounds.")
			}
			Trigger.OnPlayerLost(player, OnPlayerLost)
		end
	end
	Creeps.Object = Player.GetPlayer('Creeps')
end

function SpawnDefences(line_list, cycle)
	local start_pos_x
	local start_pos_y
	local end_pos_x
	local end_pos_y
	local mod_x
	local mod_y
	local x
	local y
	local creeps = Creeps.Object
	local cycle_i = 1
	local cycle_length = #cycle
	local cycle_current
	for i,v in pairs(line_list) do
		start_pos_x = v[1]
		start_pos_y = v[2]
		end_pos_x = v[3]
		end_pos_y = v[4]
		
		if start_pos_x <= end_pos_x then
			mod_x = 1
		else
			mod_x = -1
		end
		
		if start_pos_y <= end_pos_y then
			mod_y = 1
		else
			mod_y = -1
		end

		x = start_pos_x
		y = start_pos_y
		while true do
			cycle_current = cycle[cycle_i]
			cycle_i = cycle_i + 1
			if cycle_i > cycle_length then
				cycle_i = 1
			end
			
			Actor.Create(cycle_current, true, {
				Owner = creeps,
				Location = CPos.New(x,y)
			})
			-- maybe should work out a ratio and use that to get a nice even slope but for now just add 1 each time
			if x == end_pos_x and y == end_pos_y then
				break
			end
			if x ~= end_pos_x then
				x = x + mod_x
			end
			if y ~= end_pos_y then
				y = y + mod_y
			end
		end
	end
end

-- A bit fiddly so in its own function until I find a cleaner way
function RandomiseStarts()
	local starts = Utils.Shuffle({1,2,3,4})
	for i,v in pairs(Players) do
		Players[i].Start = starts[i]
	end
end

function PlayerIdFromPlayer(player)
	local ref = player.InternalName
	for i,v in pairs(Players) do
		if v.Ref == ref then
			return i
		end
	end
end

function RefreshScores()
	local buffer = ""
	local first = true
	
	for i,v in pairs(Players) do
		if(first) then
			first = false
		else
			buffer = buffer .. " | "
		end
		buffer = buffer .. v.Name .. ': ' .. v.Wins
		if v.State == 'lost' then
			buffer = buffer .. ' (Lost)'
		end
	end
	
	MissionText.Scores = buffer
	ShowMissionText()
end

function RefreshCountdown()
	local buffer = ""
	if Round.Status ~= 3 then
		if Intervals.HasInterval() then 
			buffer = Intervals.Text() .. ": " .. math.floor(Intervals.TicksRemaining() / 25)
		end
	end
	MissionText.Countdown = buffer
	ShowMissionText()
end

function ShowMissionText()
	UserInterface.SetMissionText(MissionText.Title .. "\n\n" .. MissionText.Scores .. "\n\n" .. MissionText.Countdown)
end

function PrepareRound()

	local creeps = Creeps.Object
	
	Army.RandomiseValues()
	
	Round.CreepsReleased = false
	Intervals.SetDelay("ArmyDelay", Army.GetSizeDelay())
	
	local mirror_text
	if Army.IsMirror() then
		mirror_text = "Mirrored Armies"
	else
		mirror_text = "Different Armies"
	end
	Media.DisplayMessage(Round.Number .. ' | Army Value: ' .. Army.GetSizeName() .. ' | ' .. mirror_text, 'Round')
	Media.DisplayMessage(Army.GetTechDescription(), 'Tech')
	
	if Round.Number > 1 then
		local buffer = ""
		local first = true
		for i,v in pairs(Players) do
			if Players[i].State ~= "lost" then
				if first then
					first = false
				else
					buffer = buffer .. ' | '
				end
				local bonus = math.floor((Players[i].Object.Cash / 100) * (Army.GetSizeValue() / 100))
				Players[i].Object.Cash = 0
				if Players[i].State == "alive" then
					-- the winner of the last round also gets the creeps bonus
					bonus = bonus + math.floor((creeps.Cash / 100) * (Army.GetSizeValue() / 100))
					creeps.Cash = 0
				end
				buffer = buffer .. Players[i].Name .. ': ' .. bonus
				Players[i].State = "alive"
				Players[i].Bonus = bonus
				EnableDeathCam(i)
			end
		end	
		Media.DisplayMessage(buffer, 'Bonus Army')
	end
	
	RandomiseStarts()
	Intervals.Reset()
	
	for i,v in pairs(Positions.Crates) do
		Actor.Create('squishcrate', true, {
			Owner = creeps,
			Location = v
		})
	end
end

function StartRound()
	DisableDeathCams()
	local army
	if Army.IsMirror() then
		army = Army.GenerateArmy()
	end
	for i,v in pairs(Players) do
		if v.State == 'alive' then
			local player_units = {}
			if not Army.IsMirror() then
				player_units = Army.UnitsAddArmy(player_units, Army.GenerateArmy())
			else
				player_units = Army.UnitsAddArmy(player_units, army)
			end
			if Players[i].Bonus > 0 then
				player_units = Army.UnitsAddArmy(player_units, Army.GenerateBonusArmy(Players[i].Bonus))
			end
			Reinforcements.Reinforce(v.Object, player_units, Starts[v.Start].path, 1)
		end
	end
end

function ResetArena() 
	local creeps = Creeps.Object
	for i,v in pairs(creeps.GetActorsByType('ant')) do
		if v.IsInWorld and not v.IsDead then
			v.Kill()
		end
	end
	for j, w in pairs(creeps.GetActors()) do
		if w.HasProperty('Health') and w.IsInWorld then
			w.Destroy()
		end
	end  
	for i,v in pairs(Players) do
		for j, w in pairs(v.Object.GetActors()) do
			if w.HasProperty('Health') and w.IsInWorld then
				w.Kill()
			end
		end
	end
	for j,w in pairs(Starts) do
		w.taken = false
	end
end

function WorldLoaded()
	Media.DisplayMessage('Squish v0.9', 'Briefing')  
	Media.DisplayMessage('Last man standing for ' .. Rounds .. ' rounds wins the game.', 'Briefing')
	Media.DisplayMessage('Defences will spawn from the outside in, only the middle is safe!', 'Briefing')
	Media.DisplayMessage('Get cash from bounties and crates to get a small army bonus next round.', 'Briefing')
	Media.DisplayMessage('Bounties from defences or ants go to the winner.', 'Briefing')
	
	InitPlayers()
	PrepareRound()
	RefreshScores()
	RefreshCountdown()
	GameReady = true
end

function GameWon()
	for i,v in pairs(Players) do
		if v.State == 'winner' then
			v.Object.MarkCompletedObjective(v.Objective)
		else
			v.Object.MarkFailedObjective(v.Objective)
		end
	end
end

function EnableDeathCam(player_i)
	if Players[player_i].DeathCam == nil then	
		Players[player_i].DeathCam = Actor.Create("deathcam" , true, {
			Owner = Players[player_i].Object,
			Location = Positions.DeathCam
		})
	end
end

function DisableDeathCams()
	for i,v in pairs(Players) do
		if v.DeathCam ~= nil then
			v.DeathCam.Destroy()
			Players[i].DeathCam = nil
		end
	end
end

function EachSecond()
	for i,v in pairs(Players) do
		if v.State == 'alive' then
			for j,w in pairs(v.Object.GetActorsByType('mnly')) do
				if w.IsInWorld and not w.IsDead then
					if w.AmmoCount() < w.MaximumAmmoCount() then 
						w.Reload()
					end
				end
			end
		end
	end

	if Round.CreepsReleased then
		local count = 0
		for i,v in pairs(Creeps.Object.GetActorsByType('ant')) do
			if v.IsInWorld and not v.IsDead then
				if v.IsIdle then
					v.AttackMove(CPos.New(Utils.RandomInteger(1,48),Utils.RandomInteger(1,48)), 5)
				end
				count = count + 1
			end
		end
		if count < 10 then
			Reinforcements.Reinforce(Creeps.Object, {'ant'}, Starts[Utils.RandomInteger(1, #Starts + 1)].path, 3)
		end
	end
	
	RefreshCountdown()
end


Tick = function()
	if GameReady == false then
		return
	end
	local interval_complete = Intervals.HasInterval() and Intervals.IsComplete()
	if interval_complete then
		interval_name = Intervals.Name()
		Intervals.Next()
	end
	if Round.Status == 2 then
		local alive = 0
		for i,v in pairs(Players) do
			if v.State == 'alive' then
				local player_alive = false
				for j,w in pairs(v.Object.GetActors()) do
					if w.IsInWorld and w.HasProperty('Health') and not w.IsDead and w.HasProperty('IsMobile') then
						player_alive = true
						break
					end
				end
				if player_alive then
					alive = alive + 1
				else
					Media.DisplayMessage(v.Name .. ' has been squished.', 'Briefing')
					Players[i].State = 'dead'
					EnableDeathCam(i)
				end
			end
		end
		if alive <= 1 then
			Round.Status = 3
			local won = false
			for i,v in pairs(Players) do
				if v.State == 'alive' then
					Players[i].Wins = v.Wins + 1
					if v.Wins >= Rounds then
						Players[i].State = 'winner'
						won = true
						Media.DisplayMessage(v.Name .. ' is the match winner!', 'Briefing')
					else
						Media.DisplayMessage(v.Name .. ' is has won the round!', 'Briefing')
					end
				end
			end
			RefreshScores()
			if won == true then
				GameWon()
			else
				ResetArena()
				Round.Status = 0
				Round.Number = Round.Number + 1
				PrepareRound()
			end
		end
		
		if interval_complete then
			if interval_name == "OuterEngage" then
				SpawnDefences(OuterDefences, DefenceCycle)
			end
			
			if interval_name == "InnerEngage" then
				SpawnDefences(InnerDefences, DefenceCycle)
			end
			
			if interval_name == "CreepUnits" then
				Media.DisplayMessage('Hungry ants detected!', 'Briefing')
				Round.CreepsReleased = true
				
				-- Just kill off any spies at this point to prevent the civilian exploit
				for i,v in pairs(Players) do
					for j, w in pairs(v.Object.GetActorsByType('spy')) do
						if w.HasProperty('Health') and w.IsInWorld then
							w.Kill()
						end
					end
				end
				
			end
		end

	end
	if interval_complete then
		if Round.Status == 0 and interval_name == "RoundStart" then
			StartRound()
			Round.Status = 1
		end
		if Round.Status == 1 and interval_name == "Spawning" then
			Round.Status = 2
		end
	end
	
	if DateTime.GameTime % 25 == 0 then
		EachSecond()
	end
end