Players = {}
Creeps = {}
Rounds = 3

-- 25 ticks per second
Intervals = {
	current = 1,
	completes = 0,
	data = {
		{
			name = "RoundStart",
			delay = 5 * 25,
			text = "Army Arrives"
		},{
			name = "Spawning",
			delay = 5 * 25,
			text = "Army Ready"
			
		},{
			name = "ArmyDelay",
			delay = 0,
			text = "Prepare Army"
		},{
			name = "OuterEngage",
			delay = 50 * 25,
			text = "Outer Defences"
			
		},{
			name = "InnerEngage",
			delay = 50 * 25,
			text = "Inner Defences"
			
		},{
			name = "CreepUnits",
			delay = 10 * 25,
			text = "Hungry Ants"
		}
	},
}
function Intervals.Reset()
	Intervals.current = 1
	Intervals.completes = DateTime.GameTime + Intervals.data[1].delay
end

function Intervals.Next()
	Intervals.current = Intervals.current + 1
	if Intervals.data[Intervals.current] == nil then
		Intervals.current = nil
	else
		Intervals.completes = DateTime.GameTime + Intervals.data[Intervals.current].delay
	end
end

function Intervals.IsComplete()
	return DateTime.GameTime >= Intervals.completes
end

function Intervals.TicksRemaining()
	return Intervals.completes - DateTime.GameTime
end

function Intervals.HasInterval()
	return Intervals.current ~= nil
end

function Intervals.Name()
	return Intervals.data[Intervals.current].name
end

function Intervals.Text()
	return Intervals.data[Intervals.current].text
end

function Intervals.SetDelay(name, delay)
	for i,v in pairs(Intervals.data) do
		if v.name == name then
			Intervals.data[i].delay = delay
			break
		end
	end
end

ArmySizes = {
	{
		name = "Very Low",
		value = 40,
		delay = 5
	},{
		name = "Low",
		value = 65,
		delay = 10 * 25
	},{
		name = "Medium",
		value = 100,
		delay = 15 * 25
	},{	
		name = "High",
		value = 130,
		delay = 20 * 25
	},{
		name = "Huge",
		value = 150,
		delay = 25 * 25
	},{
		name = "Epic",
		value = 200,
		delay = 30 * 25
	}
}

DefenceCycle = {'tsla'} -- ,'ftur','gun','pbox','tsla'

Round = {
	Number = 1,
	Status = 0, -- 0 = not started, 1 = spawning units, 2 = in progress, 2 = finished
	Times = {},
	TimesStatus = {},
	ArmySize = nil,
	Mirror = nil,
	CreepsReleased = false
}

MissionText = {
	Title = "First to " .. Rounds .. " rounds",
	Scores = "",
	Countdown = ""
}

GameReady = false

ArmyTypes = {
	'infantry', 'heavy', 'light', 'ranged'
}

Starts = {
	{
		taken = false,
		path = {CPos.New(1,1), CPos.New(5,5)},
		name = 'Top Left'
	},{
		taken = false,
		path = {CPos.New(48,48), CPos.New(44,44)},
		name = 'Bottom Right'
	},{
		taken = false,
		path = {CPos.New(48,1), CPos.New(44,5)},
		name = 'Top Right'
	},{
		taken = false,
		path = {CPos.New(1,48), CPos.New(5,44)},
		name = 'Bottom Left'
	}
}

Positions = {
	DeathCam = CPos.New(24,24),
	Crates = {
						CPos.New(16, 8),	CPos.New(29, 4),
	CPos.New(11,20),	CPos.New(19,19),	CPos.New(29,19),	CPos.New(45,13),
	CPos.New(10,29),	CPos.New(19,29),	CPos.New(29,29),	CPos.New(46,30),
						CPos.New(17,43),	CPos.New(33,43)
	}
}

OuterDefences = {
	{8,1,9,1}, {24,1,25,1}, {40,1,41,1}, -- T
	{48,10,48,12}, {48,23,48,24}, {48,38,48,42}, -- R
	{40,48,41,48}, {24,48,25,48}, {6,48,10,48}, -- B
	{1,7,1,8}, {1,21,1,24}, {1,39,1,42} --L
}

InnerDefences = {
	{13,14,13,15}, {14,13,14,15}, {15,12,15,15}, {16,12,16,13}, -- TL
	{32,12,32,15}, {33,14,33,15}, -- TR
	{16,34,16,35}, {15,34,15,35}, {14,32,14,35}, {13,32,13,35}, -- BL
	{31,35,33,35}, {32,34,33,34}, {32,33,33,33}, {32,32,33,32} --BR
}

function OnPlayerLost(player_object)
	player_id = PlayerIdFromPlayer(player_object)
	for j, w in pairs(player_object.GetActors()) do
		if w.HasProperty('Health') and w.IsInWorld then
			w.Kill()
		end
	end
	Players[player_id].State = 'lost'
	RefreshScores()
end

function InitPlayers()
	local names = {'Multi0', 'Multi1', 'Multi2', 'Multi3'}
	for i,v in pairs(names) do
		local player = Player.GetPlayer(v)
		if player ~= nill then
			Players[#Players+1] = {
				Ref = v,
				Name = player.Name,
				Object = player,
				State = 'alive',
				Squad = nil,
				Start = nil,
				Wins = 0,
				Bonus = 0,
				DeathCam = nil,
				Objective = player.AddPrimaryObjective("Be the last one standing for " .. Rounds .. " rounds.")
			}
			Trigger.OnPlayerLost(player, OnPlayerLost)
		end
	end
	Creeps.Object = Player.GetPlayer('Creeps')
end

function SpawnDefences(line_list, cycle)
	local start_pos_x
	local start_pos_y
	local end_pos_x
	local end_pos_y
	local mod_x
	local mod_y
	local x
	local y
	local creeps = Creeps.Object
	local cycle_i = 1
	local cycle_length = #cycle
	local cycle_current
	for i,v in pairs(line_list) do
		start_pos_x = v[1]
		start_pos_y = v[2]
		end_pos_x = v[3]
		end_pos_y = v[4]
		
		if start_pos_x <= end_pos_x then
			mod_x = 1
		else
			mod_x = -1
		end
		
		if start_pos_y <= end_pos_y then
			mod_y = 1
		else
			mod_y = -1
		end

		x = start_pos_x
		y = start_pos_y
		while true do
			cycle_current = cycle[cycle_i]
			cycle_i = cycle_i + 1
			if cycle_i > cycle_length then
				cycle_i = 1
			end
			
			Actor.Create(cycle_current, true, {
				Owner = creeps,
				Location = CPos.New(x,y)
			})
			-- maybe should work out a ratio and use that to get a nice even slope but for now just add 1 each time
			if x == end_pos_x and y == end_pos_y then
				break
			end
			if x ~= end_pos_x then
				x = x + mod_x
			end
			if y ~= end_pos_y then
				y = y + mod_y
			end
		end
	end

end

-- A bit fiddly so in its own function until I find a cleaner way
function RandomiseStarts()
	local available
	local spawn_id
	for i,v in pairs(Players) do
		-- Get available start_ids
		available = {}
		for j,w in pairs(Starts) do
			if w.taken == false then
				available[#available + 1] = j
			end
		end
		spawn_id = available[Utils.RandomInteger(1, #available + 1)]
		Starts[spawn_id].taken = true
		Players[i].Start = spawn_id
	end
end

function PlayerIdFromPlayer(player)
	local ref = player.InternalName
	for i,v in pairs(Players) do
		if v.Ref == ref then
			return i
		end
	end
end

function RefreshScores()
	local buffer = ""
	local first = true
	
	for i,v in pairs(Players) do
		if(first) then
			first = false
		else
			buffer = buffer .. " | "
		end
		buffer = buffer .. v.Name .. ': ' .. v.Wins
		if v.State == 'lost' then
			buffer = buffer .. ' (Lost)'
		end
	end
	
	MissionText.Scores = buffer
	ShowMissionText()
end

function RefreshCountdown()
	local buffer = ""
	if Round.Status ~= 3 then
		if Intervals.HasInterval() then 
			buffer = Intervals.Text() .. ": " .. math.floor(Intervals.TicksRemaining() / 25)
		end
	end
	MissionText.Countdown = buffer
	ShowMissionText()
end

function ShowMissionText()
	UserInterface.SetMissionText(MissionText.Title .. "\n\n" .. MissionText.Scores .. "\n\n" .. MissionText.Countdown)
end

function PrepareRound()

	local creeps = Creeps.Object
	
	Round.ArmySize = Utils.RandomInteger(1, #ArmySizes + 1)
	Round.Mirror = Utils.RandomInteger(1, 3) == 1
	Round.CreepsReleased = false
	Intervals.SetDelay("ArmyDelay", ArmySizes[Round.ArmySize].delay)
	
	local mirror_text
	if Round.Mirror then
		mirror_text = "Mirrored Armies"
	else
		mirror_text = "Different Armies"
	end
	Media.DisplayMessage(Round.Number .. ' | Army Value: ' .. ArmySizes[Round.ArmySize].name .. ' | ' .. mirror_text, 'Round')
	
	if Round.Number > 1 then
		local buffer = ""
		local first = true
		for i,v in pairs(Players) do
			if Players[i].State ~= "lost" then
				if first then
					first = false
				else
					buffer = buffer .. ' | '
				end
				local bonus = math.floor((Players[i].Object.Cash / 100) * (ArmySizes[Round.ArmySize].value / 100))
				Players[i].Object.Cash = 0
				if Players[i].State == "alive" then
					-- the winner of the last round also gets the creeps bonus
					bonus = bonus + math.floor((creeps.Cash / 100) * (ArmySizes[Round.ArmySize].value / 100))
					creeps.Cash = 0
				end
				buffer = buffer .. Players[i].Name .. ': ' .. bonus
				Players[i].State = "alive"
				Players[i].Bonus = bonus
				EnableDeathCam(i)
			end
		end	
		Media.DisplayMessage(buffer, 'Bonus Army')
	end
	
	RandomiseStarts()
	Intervals.Reset()
	
	for i,v in pairs(Positions.Crates) do
		Actor.Create('squishcrate', true, {
			Owner = creeps,
			Location = v
		})
	end
end

Armys = {
	MinValues = {},
	RemainMin = {},
	Cheapest = 1000
}

function InitArmyValues()
	for i,v in pairs(ArmyTypes) do
		Armys.MinValues[v] = 1000;
	end
	for i,v in pairs(Squads) do
		for j,w in pairs(v.kills) do
			if v.support == false and v.value < Armys.MinValues[w] then
				Armys.MinValues[w] = v.value
			end
		end
		if v.value < Armys.Cheapest then
			Armys.Cheapest = v.value
		end
	end
	local i = #ArmyTypes
	local total = 0
	while i > 0 do
		local army_type = ArmyTypes[i]
		Armys.RemainMin[army_type] = total
		total = total + Armys.MinValues[army_type]
		i = i - 1
	end
end

function RandomSquad(max_value, must_kill, max_support)
	local available = {}
	for i,v in pairs(Squads) do
		if v.value <= max_value and (v.support == false or v.value <= max_support) then
			local matches = must_kill == nil
			if not matches then
				for j,w in pairs(v.kills) do
					if w == must_kill then
						matches = true
						break
					end
				end
			end
			if matches then
				available[#available + 1] = i
			end
		end
	end
	
	if #available == 0 then
		return nil
	end
	return available[Utils.RandomInteger(1, #available + 1)]
end

-- An army must be able to kill every type
function GenerateArmy(size)
	local remaining = size
	local support_remaining = math.floor(size / 5)
	local army = {}
	
	-- Smaller than 100 don't try to balance
	if(size >= 100) then
		for i,v in pairs(ArmyTypes) do
			local squad_id = RandomSquad(remaining - Armys.RemainMin[v], v, support_remaining)
			remaining = remaining - Squads[squad_id].value
			if Squads[squad_id].support then
				support_remaining = support_remaining - Squads[squad_id].value
			end
			army[#army+1] = squad_id
		end
	end
	
	while remaining >= Armys.Cheapest do
		local squad_id = RandomSquad(remaining, nil, support_remaining)
		remaining = remaining - Squads[squad_id].value
		if Squads[squad_id].support then
			support_remaining = support_remaining - Squads[squad_id].value
		end
		army[#army+1] = squad_id
	end
	
	return army;
end

function GenerateBonusArmy(size)
	local remaining = size
	-- Bonus armys can be up to 50% support
	local support_remaining = math.floor(size / 2)
	local army = {}
	
	-- Don't try to balance
	while remaining >= Armys.Cheapest do
		local squad_id = RandomSquad(remaining, nil, support_remaining)
		remaining = remaining - Squads[squad_id].value
		if Squads[squad_id].support then
			support_remaining = support_remaining - Squads[squad_id].value
		end
		army[#army+1] = squad_id
	end
	
	return army;
end

function ArmyAddUnits(units, army)
	for i,v in pairs(army) do
		for j,w in pairs(Squads[v].units) do
			units[#units+1] = w
		end
	end
	return units
end

function ArmyDescription(army)
	local buffer = ""
	local first = true
	for i,v in pairs(army) do
		if first then
			first = false
		else
			if i == #army then
				buffer = buffer .. " and "
			else
				buffer = buffer .. ", "
			end
		end
		buffer = buffer .. Squads[v].name
	end
	return buffer
end

function StartRound()
	DisableDeathCams()
	local army
	if Round.Mirror then
		army = GenerateArmy(ArmySizes[Round.ArmySize].value)
	end
	for i,v in pairs(Players) do
		if v.State == 'alive' then
			local player_units = {}
			if not Round.Mirror then
				player_units = ArmyAddUnits(player_units, GenerateArmy(ArmySizes[Round.ArmySize].value))
			else
				player_units = ArmyAddUnits(player_units, army)
			end
			if Players[i].Bonus > 0 then
				player_units = ArmyAddUnits(player_units, GenerateBonusArmy(Players[i].Bonus))
			end
			Reinforcements.Reinforce(v.Object, player_units, Starts[v.Start].path, 6)
		end
	end
end

function ResetArena() 
	local creeps = Creeps.Object
	for i,v in pairs(creeps.GetActorsByType('ant')) do
		if v.IsInWorld and not v.IsDead then
			v.Kill()
		end
	end
	for j, w in pairs(creeps.GetActors()) do
		if w.HasProperty('Health') and w.IsInWorld then
			w.Destroy()
		end
	end  
	for i,v in pairs(Players) do
		for j, w in pairs(v.Object.GetActors()) do
			if w.HasProperty('Health') and w.IsInWorld then
				w.Kill()
			end
		end
	end
	for j,w in pairs(Starts) do
		w.taken = false
	end
end

function WorldLoaded()
	Media.DisplayMessage('Squish v0.9', 'Briefing')  
	Media.DisplayMessage('Last man standing for ' .. Rounds .. ' rounds wins the game.', 'Briefing')
	Media.DisplayMessage('Defences will spawn from the outside in, only the middle is safe!', 'Briefing')
	Media.DisplayMessage('Get cash from bounties and crates to get a small army bonus next round.', 'Briefing')
	Media.DisplayMessage('Bounties from defences or ants go to the winner.', 'Briefing')
	
	InitPlayers()
	InitArmyValues()
	PrepareRound()
	RefreshScores()
	RefreshCountdown()
	GameReady = true
end

function GameWon()
	for i,v in pairs(Players) do
		if v.State == 'winner' then
			v.Object.MarkCompletedObjective(v.Objective)
		else
			v.Object.MarkFailedObjective(v.Objective)
		end
	end
end

function EnableDeathCam(player_i)
	if Players[player_i].DeathCam == nil then	
		Players[player_i].DeathCam = Actor.Create("deathcam" , true, {
			Owner = Players[player_i].Object,
			Location = Positions.DeathCam
		})
	end
end

function DisableDeathCams()
	for i,v in pairs(Players) do
		if v.DeathCam ~= nil then
			v.DeathCam.Destroy()
			Players[i].DeathCam = nil
		end
	end
end

function EachSecond()
	for i,v in pairs(Players) do
		if v.State == 'alive' then
			for j,w in pairs(v.Object.GetActorsByType('mnly')) do
				if w.IsInWorld and not w.IsDead then
					if w.AmmoCount() < w.MaximumAmmoCount() then 
						w.Reload()
					end
				end
			end
		end
	end

	if Round.CreepsReleased then
		local count = 0
		for i,v in pairs(Creeps.Object.GetActorsByType('ant')) do
			if v.IsInWorld and not v.IsDead then
				if v.IsIdle then
					v.AttackMove(CPos.New(Utils.RandomInteger(1,48),Utils.RandomInteger(1,48)), 5)
				end
				count = count + 1
			end
		end
		if count < 10 then
			Reinforcements.Reinforce(Creeps.Object, {'ant'}, Starts[Utils.RandomInteger(1, #Starts + 1)].path, 3)
		end
	end
	
	RefreshCountdown()
end


Tick = function()
	if GameReady == false then
		return
	end
	local interval_complete = Intervals.HasInterval() and Intervals.IsComplete()
	if interval_complete then
		interval_name = Intervals.Name()
		Intervals.Next()
	end
	if Round.Status == 2 then
		local alive = 0
		for i,v in pairs(Players) do
			if v.State == 'alive' then
				local player_alive = false
				for j,w in pairs(v.Object.GetActors()) do
					if w.IsInWorld and w.HasProperty('Health') and not w.IsDead and w.HasProperty('IsMobile') then
						player_alive = true
						break
					end
				end
				if player_alive then
					alive = alive + 1
				else
					Media.DisplayMessage(v.Name .. ' has been squished.', 'Briefing')
					Players[i].State = 'dead'
					EnableDeathCam(i)
				end
			end
		end
		if alive <= 1 then
			Round.Status = 3
			local won = false
			for i,v in pairs(Players) do
				if v.State == 'alive' then
					Players[i].Wins = v.Wins + 1
					if v.Wins >= Rounds then
						Players[i].State = 'winner'
						won = true
						Media.DisplayMessage(v.Name .. ' is the match winner!', 'Briefing')
					else
						Media.DisplayMessage(v.Name .. ' is has won the round!', 'Briefing')
					end
				end
			end
			RefreshScores()
			if won == true then
				GameWon()
			else
				ResetArena()
				Round.Status = 0
				Round.Number = Round.Number + 1
				PrepareRound()
			end
		end
		
		if interval_complete then
			if interval_name == "OuterEngage" then
				SpawnDefences(OuterDefences, DefenceCycle)
			end
			
			if interval_name == "InnerEngage" then
				SpawnDefences(InnerDefences, DefenceCycle)
			end
			
			if interval_name == "CreepUnits" then
				Media.DisplayMessage('Hungry ants detected!', 'Briefing')
				Round.CreepsReleased = true
			end
		end

	end
	if interval_complete then
		if Round.Status == 0 and interval_name == "RoundStart" then
			StartRound()
			Round.Status = 1
		end
		if Round.Status == 1 and interval_name == "Spawning" then
			Round.Status = 2
		end
	end
	
	if DateTime.GameTime % 25 == 0 then
		EachSecond()
	end
end