Players = {}
Creeps = {}
Rounds = 3

-- 25 ticks per second
Intervals = {
	RoundStart = 5 * 25,
	Spawning = 10 * 25,
	OuterEngage = 75 * 25,
	InnerEngage = 135 * 25,
	CreepUnits = 145 * 25
	-- Debug values
	--OuterEngage = 15 * 25,
	--InnerEngage = 25 * 25,
	--CreepUnits = 35 * 25
}

ArmySizes = {
	{
		name = "Cheap",
		value = 50
	},{
		name = "Medium",
		value = 100
	},{
		name = "High",
		value = 150
	},{
		name = "Huge",
		value = 200
	}
}

Countdowns = {
	{
		Interval = "RoundStart",
		Text = "Units Arrive"
	},{
		Interval = "OuterEngage",
		Text = "Outer Defences"
	},{
		Interval = "InnerEngage",
		Text = "Inner Defences"
	},{
		Interval = "CreepUnits",
		Text = "Hungry Ants"
	}
}

DefenceCycle = {'tsla'} -- ,'ftur','gun','pbox','tsla'

Round = {
	Number = 1,
	Status = 0, -- 0 = not started, 1 = spawning units, 2 = in progress, 2 = finished
	Times = {},
	TimesStatus = {},
	ArmySize = nil
}

MissionText = {
	Title = "First to " .. Rounds .. " rounds",
	Scores = "",
	Countdown = ""
}

GameReady = false

ArmyTypes = {
	'infantry', 'heavy', 'light', 'ranged'
}

Starts = {
	{
		taken = false,
		path = {CPos.New(1,1), CPos.New(5,5)},
		name = 'Top Left'
	},{
		taken = false,
		path = {CPos.New(48,48), CPos.New(44,44)},
		name = 'Bottom Right'
	},{
		taken = false,
		path = {CPos.New(48,1), CPos.New(44,5)},
		name = 'Top Right'
	},{
		taken = false,
		path = {CPos.New(1,48), CPos.New(5,44)},
		name = 'Bottom Left'
	}
}

Positions = {
	DeathCam = CPos.New(24,24),
	Crates = {
						CPos.New(16, 8),	CPos.New(29, 4),
	CPos.New(11,20),	CPos.New(19,19),	CPos.New(29,19),	CPos.New(45,13),
	CPos.New(10,29),	CPos.New(19,29),	CPos.New(29,29),	CPos.New(46,30),
						CPos.New(17,43),	CPos.New(33,43)
	}
}

OuterDefences = {
	{8,1,9,1}, {24,1,25,1}, {40,1,41,1}, -- T
	{48,10,48,12}, {48,23,48,24}, {48,38,48,42}, -- R
	{40,48,41,48}, {24,48,25,48}, {6,48,10,48}, -- B
	{1,7,1,8}, {1,21,1,24}, {1,39,1,42} --L
}

InnerDefences = {
	{13,14,13,15}, {14,13,14,15}, {15,12,15,15}, {16,12,16,13}, -- TL
	{31,12,31,15}, {32,14,32,15}, -- TR
	{16,34,16,35}, {15,34,15,35}, {14,32,14,35}, {13,32,13,35}, -- BL
	{31,35,33,35}, {31,36,33,36} --BR
}

function InitPlayers()
	local names = {'Multi0', 'Multi1', 'Multi2', 'Multi3'}
	for i,v in pairs(names) do
		local player = Player.GetPlayer(v)
		if player ~= nill then
			Players[#Players+1] = {
				Ref = v,
				Name = player.Name,
				Object = player,
				State = 'alive',
				Squad = nil,
				Start = nil,
				Wins = 0,
				DeathCam = nil,
				Objective = player.AddPrimaryObjective("Be the last one standing for " .. Rounds .. " rounds.")
			}
		end
	end
	Creeps.Object = Player.GetPlayer('Creeps')
end

function SpawnDefences(line_list, cycle)
	local start_pos_x
	local start_pos_y
	local end_pos_x
	local end_pos_y
	local mod_x
	local mod_y
	local x
	local y
	local creeps = Creeps.Object
	local cycle_i = 1
	local cycle_length = #cycle
	local cycle_current
	for i,v in pairs(line_list) do
		start_pos_x = v[1]
		start_pos_y = v[2]
		end_pos_x = v[3]
		end_pos_y = v[4]
		
		if start_pos_x <= end_pos_x then
			mod_x = 1
		else
			mod_x = -1
		end
		
		if start_pos_y <= end_pos_y then
			mod_y = 1
		else
			mod_y = -1
		end

		x = start_pos_x
		y = start_pos_y
		while true do
			cycle_current = cycle[cycle_i]
			cycle_i = cycle_i + 1
			if cycle_i > cycle_length then
				cycle_i = 1
			end
			
			Actor.Create(cycle_current, true, {
				Owner = creeps,
				Location = CPos.New(x,y)
			})
			-- maybe should work out a ratio and use that to get a nice even slope but for now just add 1 each time
			if x == end_pos_x and y == end_pos_y then
				break
			end
			if x ~= end_pos_x then
				x = x + mod_x
			end
			if y ~= end_pos_y then
				y = y + mod_y
			end
		end
	end

end

-- A bit fiddly so in its own function until I find a cleaner way
function RandomiseStarts()
	local available
	local spawn_id
	for i,v in pairs(Players) do
		-- Get available start_ids
		available = {}
		for j,w in pairs(Starts) do
			if w.taken == false then
				available[#available + 1] = j
			end
		end
		spawn_id = available[Utils.RandomInteger(1, #available + 1)]
		Starts[spawn_id].taken = true
		Players[i].Start = spawn_id
	end
end

function PlayerIdFromPlayer(player)
	local name = player.InternalName
	for i,v in pairs(Players) do
		if v.Name == name then
			return i
		end
	end
end

function RefreshScores()
	local buffer = ""
	local first = true
	
	for i,v in pairs(Players) do
		if(first) then
			first = false
		else
			buffer = buffer .. " | "
		end
		buffer = buffer .. v.Name .. ': ' .. v.Wins
	end
	
	MissionText.Scores = buffer
	ShowMissionText()
end

function RefreshCountdown()
	local buffer = ""
	if Round.Status ~= 3 then
		for i,v in pairs(Countdowns) do
			local remaining =  Round.Times[v.Interval] - DateTime.GameTime
			if remaining >= 0 then
				buffer = v.Text .. ": " .. math.floor(remaining / 25)
				break
			end
		end
	end
	MissionText.Countdown = buffer
	ShowMissionText()
end

function ShowMissionText()
	UserInterface.SetMissionText(MissionText.Title .. "\n\n" .. MissionText.Scores .. "\n\n" .. MissionText.Countdown)
end

function PrepareRound()

	Round.ArmySize = Utils.RandomInteger(1, #ArmySizes + 1)
	Media.DisplayMessage(Round.Number .. ' | Army Value: ' .. ArmySizes[Round.ArmySize].name, 'Round')
	
	for i,v in pairs(Players) do
		Players[i].State = "alive"
		EnableDeathCam(i)
	end

	RandomiseStarts()

	local CurrentTime = DateTime.GameTime
	for i,v in pairs(Intervals) do
		Round.TimesStatus[i] = false
		Round.Times[i] = CurrentTime + v
	end
	
	local creeps = Creeps.Object
	for i,v in pairs(Positions.Crates) do
		Actor.Create('squishcrate', true, {
			Owner = creeps,
			Location = v
		})
	end
end

Armys = {
	MinValues = {},
	RemainMin = {},
	Cheapest = 1000
}

function InitArmyValues()
	for i,v in pairs(ArmyTypes) do
		Armys.MinValues[v] = 1000;
	end
	for i,v in pairs(Squads) do
		for j,w in pairs(v.kills) do
			if v.value < Armys.MinValues[w] then
				Armys.MinValues[w] = v.value
			end
		end
		if v.value < Armys.Cheapest then
			Armys.Cheapest = v.value
		end
	end
	local i = #ArmyTypes
	local total = 0
	while i > 0 do
		local army_type = ArmyTypes[i]
		Armys.RemainMin[army_type] = total
		total = total + Armys.MinValues[army_type]
		i = i - 1
	end
end

function RandomSquad(max_value, must_kill)
	local available = {}
	for i,v in pairs(Squads) do
		if v.value <= max_value then
			local matches = must_kill == nil
			if not matches then
				for j,w in pairs(v.kills) do
					if w == must_kill then
						matches = true
						break
					end
				end
			end
			if matches then
				available[#available + 1] = i
			end
		end
	end
	
	if #available == 0 then
		return nil
	end
	return available[Utils.RandomInteger(1, #available + 1)]
end

-- An army must be able to kill every type
function GenerateArmy(size)
	local remaining = size
	local army = {}
	
	-- Small than 100 don't try to balance
	if(size >= 100) then
		for i,v in pairs(ArmyTypes) do
			local squad_id = RandomSquad(remaining - Armys.RemainMin[v], v)
			remaining = remaining - Squads[squad_id].value
			army[#army+1] = squad_id
		end
	end
	
	while remaining >= Armys.Cheapest do
		local squad_id = RandomSquad(remaining, nil)
		remaining = remaining - Squads[squad_id].value
		army[#army+1] = squad_id
	end
	
	return army;
end

function ArmyUnits(army)
	local units = {}
	for i,v in pairs(army) do
		for j,w in pairs(Squads[v].units) do
			units[#units+1] = w
		end
	end
	return units
end

function ArmyDescription(army)
	local buffer = ""
	local first = true
	for i,v in pairs(army) do
		if first then
			first = false
		else
			if i == #army then
				buffer = buffer .. " and "
			else
				buffer = buffer .. ", "
			end
		end
		buffer = buffer .. Squads[v].name
	end
	return buffer
end

function StartRound()
	DisableDeathCams()
	for i,v in pairs(Players) do
		if v.State == 'alive' then
			local army = GenerateArmy(ArmySizes[Round.ArmySize].value)
			Media.DisplayMessage(v.Name .. ' in the ' .. Starts[v.Start].name .. ' with ' .. ArmyDescription(army), 'Game')
			Reinforcements.Reinforce(v.Object, ArmyUnits(army), Starts[v.Start].path, 3)
		end
	end
end

function ResetArena() 
	local creeps = Creeps.Object
	for i,v in pairs(creeps.GetActorsByType('ant')) do
		if v.IsInWorld and not v.IsDead then
			v.Kill()
		end
	end
	for j, w in pairs(creeps.GetActors()) do
		if w.HasProperty('Health') and w.IsInWorld then
			w.Destroy()
		end
	end  
	for i,v in pairs(Players) do
		for j, w in pairs(v.Object.GetActors()) do
			if w.HasProperty('Health') and w.IsInWorld then
				w.Kill()
			end
		end
	end
	for j,w in pairs(Starts) do
		w.taken = false
	end
end

function WorldLoaded()
	Media.DisplayMessage('Squish v0.8', 'Briefing')  
	Media.DisplayMessage('Last man standing for ' .. Rounds .. ' rounds wins the game.', 'Briefing')
	Media.DisplayMessage('Defences will spawn from the outside in, only the middle is safe!', 'Briefing')
	
	InitPlayers()
	InitArmyValues()
	PrepareRound()
	RefreshScores()
	RefreshCountdown()
	GameReady = true
end

function GameWon()
	for i,v in pairs(Players) do
		if v.State == 'winner' then
			v.Object.MarkCompletedObjective(v.Objective)
		else
			v.Object.MarkFailedObjective(v.Objective)
		end
	end
end

function EnableDeathCam(player_i)
	if Players[player_i].DeathCam == nil then	
		Players[player_i].DeathCam = Actor.Create("deathcam" , true, {
			Owner = Players[player_i].Object,
			Location = Positions.DeathCam
		})
	end
end

function DisableDeathCams()
	for i,v in pairs(Players) do
		if v.DeathCam ~= nil then
			v.DeathCam.Destroy()
			Players[i].DeathCam = nil
		end
	end
end

function EachSecond()
	for i,v in pairs(Players) do
		if v.State == 'alive' then
			for j,w in pairs(v.Object.GetActorsByType('mnly')) do
				if w.IsInWorld and not w.IsDead then
					if w.AmmoCount() < w.MaximumAmmoCount() then 
						w.Reload()
					end
				end
			end
		end
	end	
	
	if Round.Status == 2 and DateTime.GameTime > Round.Times.CreepUnits then
		if Round.TimesStatus.CreepUnits == false then
			Media.DisplayMessage('Hungry ants detected!', 'Briefing')
			Round.TimesStatus.CreepUnits = true
		end
		local count = 0
		for i,v in pairs(Creeps.Object.GetActorsByType('ant')) do
			if v.IsInWorld and not v.IsDead then
				if v.IsIdle then
					v.AttackMove(CPos.New(Utils.RandomInteger(1,48),Utils.RandomInteger(1,48)), 5)
				end
				count = count + 1
			end
		end
		if count < 10 then
			Reinforcements.Reinforce(Creeps.Object, {'ant'}, Starts[Utils.RandomInteger(1, #Starts + 1)].path, 3)
		end	
	end
	
	RefreshCountdown()
end


Tick = function()
	if GameReady == false then
		return
	end
	if Round.Status == 2 then
		local alive = 0
		for i,v in pairs(Players) do
			if v.State == 'alive' then
				local player_alive = false
				for j,w in pairs(v.Object.GetActors()) do
					if w.IsInWorld and w.HasProperty('Health') and not w.IsDead and w.HasProperty('IsMobile') then
						player_alive = true
						break
					end
				end
				if player_alive then
					alive = alive + 1
				else
					Media.DisplayMessage(v.Name .. ' has been squished.', 'Briefing')
					Players[i].State = 'dead'
					EnableDeathCam(i)
				end
			end
		end
		if alive <= 1 then
			Round.Status = 3
			local won = false
			for i,v in pairs(Players) do
				if v.State == 'alive' then
					Players[i].Wins = v.Wins + 1
					if v.Wins >= Rounds then
						Players[i].State = 'winner'
						won = true
						Media.DisplayMessage(v.Name .. ' is the match winner!', 'Briefing')
					else
						Media.DisplayMessage(v.Name .. ' is has won the round!', 'Briefing')
					end
				end
			end
			RefreshScores()
			if won == true then
				GameWon()
			else
				ResetArena()
				Round.Status = 0
				Round.Number = Round.Number + 1
				PrepareRound()
			end
		end
		
		if DateTime.GameTime > Round.Times.OuterEngage and Round.TimesStatus.OuterEngage == false then
			Round.TimesStatus.OuterEngage = true
			SpawnDefences(OuterDefences, DefenceCycle)
		end
		
		if DateTime.GameTime > Round.Times.InnerEngage and Round.TimesStatus.InnerEngage == false then
			Round.TimesStatus.InnerEngage = true
			SpawnDefences(InnerDefences, DefenceCycle)
		end
	end	
	if Round.Status == 0 and DateTime.GameTime > Round.Times.RoundStart and Round.TimesStatus.RoundStart == false then
		Round.TimesStatus.RoundStart = true
		StartRound()
		Round.Status = 1
	end
	if Round.Status == 1 and DateTime.GameTime > Round.Times.Spawning and Round.TimesStatus.Spawning == false then
		Round.TimesStatus.Spawning = true
		Round.Status = 2
	end
	
	if DateTime.GameTime % 25 == 0 then
		EachSecond()
	end
end