PlayerNames = {'Multi0', 'Multi1', 'Multi2', 'Multi3'}
PlayerObjects = {}
PlayerObjectives = {}
PlayerState = {}
PlayerSquads = {}
PlayerStarts = {}
PlayerWins = {}
PlayerDeathCams = {}

Rounds = 3

-- 25 ticks per second
Intervals = {
	RoundStart = 5 * 25,
	Spawning = 15 * 25,
	OuterWarning = 45 * 25,
	OuterEngage = 75 * 25,
	InnerWarning = 105 * 25,
	InnerEngage = 135 * 25
	-- Debug values
	--OuterWarning = 15 * 25,
	--OuterEngage = 15 * 25,
	--InnerWarning = 15 * 25,
	--InnerEngage = 15 * 25
}

DefenceCycle = {'pbox','tsla'} -- ,'ftur','gun'

Round = {
	Number = 1,
	Status = 0, -- 0 = not started, 1 = spawning units, 2 = in progress, 2 = finished
	Times = {},
	TimesStatus = {}
}

GameReady = false

Squads = {
	{
		name = 'the Rocket Crew',
		units = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1',
			'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3',
			'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3',
			'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3',
			'e3', 'e3', 'e3', 'e3'
		}
	},{
		name = 'the Rifle Squad',
		units = {
			'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1','e1', 'e1', 'e1', 'e1',
			'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1',
			'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1',
			'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1',
			'e1', 'e1', 'e1', 'e1'
		}
	},{
		name = 'the Civilian Wanderers',
		units = {
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'mnly', 'medi', 'medi', 'medi', 'medi', 'medi', 'dog', 'dog'
		}
	},{
		name = 'Tanya',
		units = {
			'e7', 'jeep'
		}
	},{
		name = 'the Soviet Infantry Mixup',
		units = {
			'hijacker', 'hijacker', 'e4', 'e4', 'e4', 'e4', 'e4', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 
			'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'shok', 'shok', 'shok', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2'
		}
	},{
		name = 'MAMMOTH TANKS',
		units = {
			'4tnk', '4tnk',
		}
	},{
		name = 'Chrono Tanks',
		units = {
			'ctnk', 'ctnk', 'ctnk',
		}
	},{
		name = 'Arty Spam',
		units = {
			'arty', 'arty', 'arty', 'arty', 'jeep', 'jeep'
		}
	},{
		name = 'the V2 Cleanup Crew',
		units = {
			'v2rl', 'v2rl', 'v2rl', 'v2rl', 'ftrk', 'ftrk'
		}
	},{
		name = 'Tesla V2s',
		units = {
			'v2rl', 'v2rl', 'ttnk', 'ttnk'
		}
	},{
		name = 'a little suprise',
		units = {
			'apc', 'apc', 'apc', 'dtrk'
		}
	},{
		name = 'an Allied Tank Battalion',
		units = {
			'1tnk', '1tnk', '2tnk', '2tnk'
		}
	}
}

Starts = {
	{
		taken = false,
		path = {CPos.New(1,1), CPos.New(10,10)},
		name = 'Top Left'
	},{
		taken = false,
		path = {CPos.New(48,48), CPos.New(39,39)},
		name = 'Bottom Right'
	},{
		taken = false,
		path = {CPos.New(48,1), CPos.New(39,10)},
		name = 'Top Right'
	},{
		taken = false,
		path = {CPos.New(1,48), CPos.New(10,39)},
		name = 'Bottom Left'
	}
}

Positions = {
	DeathCam = CPos.New(24,24),
	Crates = {
						CPos.New(21, 8),	CPos.New(28, 8),
	CPos.New( 7,21),	CPos.New(21,21),	CPos.New(28,21),	CPos.New(41,21),
	CPos.New( 7,28),	CPos.New(21,28),	CPos.New(28,28),	CPos.New(41,28),
						CPos.New(21,41),	CPos.New(28,41)
	}
}

function SpawnDefences(line_list, cycle)
	local start_pos_x
	local start_pos_y
	local end_pos_x
	local end_pos_y
	local mod_x
	local mod_y
	local x
	local y
	local creeps = Player.GetPlayer('Creeps')
	local cycle_i = 1
	local cycle_length = #cycle
	local cycle_current
	for i,v in pairs(line_list) do
		start_pos_x = v[1]
		start_pos_y = v[2]
		end_pos_x = v[3]
		end_pos_y = v[4]
		
		if start_pos_x <= end_pos_x then
			mod_x = 1
		else
			mod_x = -1
		end
		
		if start_pos_y <= end_pos_y then
			mod_y = 1
		else
			mod_y = -1
		end

		x = start_pos_x
		y = start_pos_y
		while true do
			cycle_current = cycle[cycle_i]
			cycle_i = cycle_i + 1
			if cycle_i > cycle_length then
				cycle_i = 1
			end
			
			Actor.Create(cycle_current, true, {
				Owner = creeps,
				Location = CPos.New(x,y)
			})
			-- maybe should work out a ratio and use that to get a nice even slope but for now just add 1 each time
			if x == end_pos_x and y == end_pos_y then
				break
			end
			if x ~= end_pos_x then
				x = x + mod_x
			end
			if y ~= end_pos_y then
				y = y + mod_y
			end
		end
	end

end

-- A bit fiddly so in its own function until I find a cleaner way
function RandomiseStarts()
	local available
	local spawn_id
	for i,v in pairs(PlayerNames) do
		-- Get available start_ids
		available = {}
		for j,w in pairs(Starts) do
			if w.taken == false then
				available[#available + 1] = j
			end
		end
		spawn_id = available[Utils.RandomInteger(1, #available + 1)]
		Starts[spawn_id].taken = true
		PlayerStarts[i] = spawn_id
	end
end

function PlayerIdFromPlayer(player)
	local name = player.InternalName
	for i,v in pairs(PlayerNames) do
		if v == name then
			return i
		end
	end
end

function PrepareRound()
	RandomiseStarts()

	local CurrentTime = DateTime.GameTime
	for i,v in pairs(Intervals) do
		Round.TimesStatus[i] = false
		Round.Times[i] = CurrentTime + v
	end
	
	for i,v in pairs(PlayerNames) do
		local player = Player.GetPlayer(v)
		if player == nill then
			PlayerState[i] = 'dead'
		else
			PlayerObjects[i] = player
			PlayerState[i] = 'alive'
			Media.DisplayMessage(player.Name .. ' - ' .. PlayerWins[i], 'Score')
		end
	end
	
	DisableDeathCams()
	
end

function StartRound()
	for i,player in pairs(PlayerObjects) do
		if PlayerState[i] == 'alive' then
			local squad_id = Utils.RandomInteger(1, #Squads + 1)
			PlayerSquads[i] = squad_id
			Media.DisplayMessage(player.Name .. ' has started with ' .. Squads[squad_id].name .. ' in the ' .. Starts[PlayerStarts[i]].name, 'Game')
			Reinforcements.Reinforce(player, Squads[squad_id].units, Starts[PlayerStarts[i]].path, 3)
		end
	end
	
	local creeps = Player.GetPlayer('Creeps')
	for i,v in pairs(Positions.Crates) do
		Actor.Create('crate', true, {
			Owner = creeps,
			Location = v
		})
	end
end

function all_players()
	return true
end

function ResetArena()
  Media.DisplayMessage('Resetting', 'Briefing')  
  local actors
  for i,v in pairs(Player.GetPlayers(all_players)) do
	for j, w in pairs(v.GetActors()) do
		if w.HasProperty('Health') and w.IsInWorld then
			w.Kill()
		end
	end  
  end  
	for j,w in pairs(Starts) do
		w.taken = false
	end
end

function WorldLoaded()
	Media.DisplayMessage('Welcome to squish v0.3!', 'Briefing')  
	Media.DisplayMessage('It\'s a fight to the death. Last man standing wins the game.', 'Briefing')
	Media.DisplayMessage('Collect the crates for power-ups.', 'Briefing')
	Media.DisplayMessage('Defences will spawn from the outside in, so get control of the middle to win!', 'Briefing')

	for i,v in pairs(PlayerNames) do
		local player = Player.GetPlayer(v)
		if player ~= nill then
			PlayerObjectives[i] = player.AddPrimaryObjective("Be the last one standing for " .. Rounds .. " rounds.")
		end
		PlayerWins[i] = 0
	end
	
	PrepareRound()
	GameReady = true
end

function GameWon()
	for i,v in pairs(PlayerObjects) do
		if PlayerState[i] == 'winner' then
			v.MarkCompletedObjective(PlayerObjectives[i])
		else
			v.MarkFailedObjective(PlayerObjectives[i])
		end
	end
end

function EnableDeathCam(player_i)
  PlayerDeathCams[player_i] = Actor.Create("deathcam" , true, {
     Owner = PlayerObjects[player_i],
     Location = Positions.DeathCam
  })
end

function DisableDeathCams()
	for i,v in pairs(PlayerDeathCams) do
		if not v.IsDead then
			v.Destroy()
		end
	end
end


Tick = function()
	if GameReady == false then
		return
	end
	if Round.Status == 2 then
		local alive = 0
		for i,v in pairs(PlayerObjects) do
			if PlayerState[i] == 'alive' then
				if next(v.GetGroundAttackers()) == nil then
				Media.DisplayMessage(v.Name .. ' has been squished.', 'Briefing')
					PlayerState[i] = 'dead'
					EnableDeathCam(i)
				else
					alive = alive + 1
				end
			end
		end
		if alive <= 1 then
			Round.Status = 3
			local won = false
			for i,v in pairs(PlayerObjects) do
				if PlayerState[i] == 'alive' then
					PlayerWins[i] = PlayerWins[i] + 1
					if PlayerWins[i] >= Rounds then
						PlayerState[i] = 'winner'
						won = true
						Media.DisplayMessage(v.Name .. ' is the match winner!', 'Briefing')
					else
						Media.DisplayMessage(v.Name .. ' is has won the round!', 'Briefing')
					end
				end
			end
			if won == true then
				GameWon()
			else
				ResetArena()
				PrepareRound()
				Round.Status = 0
				Round.Number = Round.Number + 1
			end
		end		
		
		if DateTime.GameTime > Round.Times.OuterEngage and Round.TimesStatus.OuterEngage == false then
			Round.TimesStatus.OuterEngage = true
			SpawnDefences({
				{8,1,43,1},
				{6,48,43,48},
				{1,7,1,42},
				{48,9,48,42}
			},DefenceCycle)
		end
		
		if DateTime.GameTime > Round.Times.InnerEngage and Round.TimesStatus.InnerEngage == false then
			Round.TimesStatus.InnerEngage = true	
			SpawnDefences({
				{14,19,14,14},
				{15,14,19,14},
				{30,14,35,14},
				{35,15,35,19},
				{14,30,14,35},
				{15,35,19,35},
				{30,35,35,35},
				{35,34,35,30},
			},DefenceCycle)
		end
		
		if DateTime.GameTime > Round.Times.OuterWarning and Round.TimesStatus.OuterWarning == false then
			Round.TimesStatus.OuterWarning = true
			Media.DisplayMessage('Outer defences will be engaged in 30 seconds!', 'Warning')
		end
		
		if DateTime.GameTime > Round.Times.InnerWarning and Round.TimesStatus.InnerWarning == false then
			Round.TimesStatus.InnerWarning = true
			Media.DisplayMessage('Inner defences will be engaged in 30 seconds!', 'Warning')
		end
	end	
	if Round.Status == 0 and DateTime.GameTime > Round.Times.RoundStart and Round.TimesStatus.RoundStart == false then
		Round.TimesStatus.RoundStart = true
		StartRound()
		Round.Status = 1
	end
	if Round.Status == 1 and DateTime.GameTime > Round.Times.Spawning and Round.TimesStatus.Spawning == false then
		Round.TimesStatus.Spawning = true
		Round.Status = 2
	end
end