mapbounds= {Left=2,Top=2,Width=80,Height=80} --ADJUST for new maps!!
ActorRegister={}
Upgrade_Producers = {}
ReinforcementSquads = {
	{"vet_light_inf","vet_light_inf","vet_light_inf","vet_trooper","vet_trooper"},
	{"quad","quad","sardaukar", "sardaukar"},
	{"trooper","trooper","trooper","trooper", "trooper"},
	}
HarvestAmmout=12000
ResourceVictory=false
Annihillated = { ordos=true,atreides=true,mercenaries=true}
MissionText={"Commander, our advance in this funeral plain is facing growing ORDOS resistance. Also, the allegiance of the local MERCENARIES is unsure yet.\nAIR REINFORCEMENTS pour in to strengthen our enemies, but we can also call in reinforcements, once the OUTPOST UPGRADE is complete.\nEither DESTROY all opposing forces OR HARVEST ".. tostring(HarvestAmmout) .." solaris worth of spice to complete this mission.\n--Good luck!",
"Commander, the ATREIDES are invading our territory!\nDESTROY all attackers threatening this espionage outpost of ours or at least harvest a gain of "..tostring(HarvestAmmout).." solaris for our house.\nAIR REINFORCEMENTS are available after an OUTPOST UPGRADE.\nOur intelligence sources indicate the atreides may have bribed the MERCENARIES in this area. Beware.\n--Transmission End",
"Mercenary Captain, I have received the ATREIDES answer to our modest price for military aid against the ORDOS - Those stuck-ups declined!\nI want you to either HARVEST those "..tostring(HarvestAmmout).." solaris from this damned place anyway or to CAST OUT BOTH of those houses from here!\nYou have my permission to use AIR REINFORCEMENTS after an OUTPOST UPGRADE.\nNow go and make money!!"}
Warning={	"Atreides  have over 9000 resources!!\n" ,
			"The Ordos have over 9000 resources!!\n" ,
			"The Mercs have over 9000 resources!!\n" }


WorldLoaded = function()
	--players
	atreides = Player.GetPlayer("Atreides")
	ordos    = Player.GetPlayer("Ordos")
	mercenaries = Player.GetPlayer("Mercenaries")
	if atreides 
	then 
		Annihillated.atreides=false
		--set starting cash (rules:	PlayerResources: DefaultCashLocked: True currently bugged -> prevents players from joining)
		atreides.Cash =0
	end
	if ordos 
	then 
		Annihillated.ordos=false 
		ordos.Cash=0
	end
	if mercenaries 
	then 
		Annihillated.mercenaries=false 
		mercenaries.Cash=0
	end
	
	--smugglers setup
	smugglers = Player.GetPlayer("Smugglers")
	Trigger.AfterDelay(DateTime.Seconds(0.1),function()
		for _,act in pairs(smugglers.GetActors())
		do 
			if act.Type=="carryall.reinforce" then act.Kill() end
		end
	end)

	--mission text
	if mercenaries 
	then
		--Objectives and Mission
		ObjectiveM = mercenaries.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(mercenaries, 
			function(p)
				if Annihillated.ordos and Annihillated.atreides 
				then
					Media.DisplayMessage("The Mercenaries have annihilated all opposition!","Mission Success",HSLColor.Gold) 
				else
					Media.DisplayMessage("The Mercenaries have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.Gold)
				end
			end)
		Trigger.OnPlayerLost(mercenaries, function(p) if not ResourceVictory then annihillate(p) end end)
		if mercenaries.IsLocalPlayer
		then 
			Media.DisplayMessage(MissionText[3],"Your Mission",HSLColor.Gold)
		end
	end
	if ordos
	then
		--Objectives and Mission
		ObjectiveO = ordos.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(ordos, 
			function(p)
				if Annihillated.mercenaries and Annihillated.atreides 
				then
					Media.DisplayMessage("The Ordos have annihilated all opposition!","Mission Success",HSLColor.LawnGreen) 
				else
					Media.DisplayMessage("The Ordos have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.LawnGreen)
				end
			end)
		Trigger.OnPlayerLost(ordos, function(p) if not ResourceVictory then annihillate(p) end end)
		if ordos.IsLocalPlayer 
		then
			Media.DisplayMessage(MissionText[2],"Your Mission",HSLColor.LawnGreen) 
		end
	end
	if atreides
	then
		--Objectives and Mission
		ObjectiveA = atreides.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(atreides, 
			function(p)
				if Annihillated.ordos and Annihillated.mercenaries 
				then
					Media.DisplayMessage("The Atreides have annihilated all opposition!","Mission Success",HSLColor.Blue) 
				else
					Media.DisplayMessage("The Atreides have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.Blue)
				end
			end)
		Trigger.OnPlayerLost(atreides, function(p) if not ResourceVictory then annihillate(p) end end)
		if atreides.IsLocalPlayer 
		then 
			Media.DisplayMessage(MissionText[1],"Your Mission",HSLColor.Blue) 
		end
	end	
end
			
Tick = function()
	--check register for new actors and only call act.Type=="whatever" when neccessary since it is expensive
	local new_actors = ActorsAddedToWorld(Map.ActorsInWorld,ActorRegister)
	
	for _,act in pairs(new_actors) 
	do
	--ACTOR TYPE CHECKS
		local T=act.Type
		--needed for airdrop powers
		if (T=="waypoint_dummy_a" or T=="waypoint_dummy_h" or T=="waypoint_dummy_o")
		then
			dropAirReinforcements(act.Location,act)
		--...handle advanced_silo upgrade
		elseif T=="outpost" 
		then
			table.insert(Upgrade_Producers,act)
			--for each new producer set a trigger
			Trigger.OnProduction(act, 
				function(producer, produced)		
					if produced.Type=="upgrade.silo"
					then --advanced silo upgrade trigger
						replace_silos(act.Owner)
					end
				end)
		end	
	end
 
	--resource victory check
	if atreides and atreides.Cash+atreides.Resources >= HarvestAmmout and not atreides.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		atreides.MarkCompletedObjective(ObjectiveA)
		if ordos then ordos.MarkFailedObjective(ObjectiveO) end
		if mercenaries then mercenaries.MarkFailedObjective(ObjectiveM) end
	end
	if mercenaries and mercenaries.Cash+mercenaries.Resources >= HarvestAmmout and not mercenaries.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		if atreides then atreides.MarkFailedObjective(ObjectiveA) end
		if ordos then ordos.MarkFailedObjective(ObjectiveO) end 
		mercenaries.MarkCompletedObjective(ObjectiveM)
	end
	if ordos and ordos.Cash+ordos.Resources >= HarvestAmmout and not ordos.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		if atreides then atreides.MarkFailedObjective(ObjectiveA) end 
		ordos.MarkCompletedObjective(ObjectiveO)
		if mercenaries then mercenaries.MarkFailedObjective(ObjectiveM) end
	end

	--custom short game defeat check
	if atreides and atreides.HasNoRequiredUnits() then atreides.MarkFailedObjective(ObjectiveA) end
	if mercenaries and mercenaries.HasNoRequiredUnits() then mercenaries.MarkFailedObjective(ObjectiveM) end
	if ordos and ordos.HasNoRequiredUnits() then ordos.MarkFailedObjective(ObjectiveO) end
	
	--spice-meter and victory warnings:
	local warning = ""
	local resourcetext = ""
	local pcolor = HSLColor.Gray
	if not Annihillated.atreides and not atreides.IsLocalPlayer and atreides.Cash+atreides.Resources>9000 then warning = warning..Warning[1] end
	if not Annihillated.ordos and not ordos.IsLocalPlayer and ordos.Cash+ordos.Resources>9000 then warning = warning..Warning[2] end
	if not Annihillated.mercenaries and not mercenaries.IsLocalPlayer and mercenaries.Cash+mercenaries.Resources>9000 then warning = warning..Warning[3] end
	
	if not Annihillated.atreides and atreides.IsLocalPlayer 
	then
		resourcetext = "     Stored resources: " ..tostring(atreides.Cash+atreides.Resources) .. " / " .. HarvestAmmout.."     \n"
		pcolor = atreides.Color
	elseif not Annihillated.ordos and ordos.IsLocalPlayer
	then
		resourcetext = "     Stored resources: " ..tostring(ordos.Cash+ordos.Resources).. " / " .. HarvestAmmout.."     \n"
		pcolor = ordos.Color
	elseif not Annihillated.mercenaries and mercenaries.IsLocalPlayer
	then
		resourcetext = "     Stored resources: " .. tostring(mercenaries.Cash+mercenaries.Resources) .. " / " .. HarvestAmmout.."     \n"
		pcolor = mercenaries.Color
	end
	UserInterface.SetMissionText(resourcetext..warning, pcolor)
end

function ActorsAddedToWorld(newlist,register)
	local new_actor_list={}
	for key,act in pairs(newlist)
	do
		if not register[tostring(act)]
		then
			register[tostring(act)]=true
			table.insert(new_actor_list,act)
		end
	end
	return new_actor_list
end

function annihillate(player)
	if player == atreides then Annihillated.atreides=true
	elseif player == mercenaries then Annihillated.mercenaries=true
	elseif player == ordos then Annihillated.ordos=true end

	for _,act in pairs(player.GetActors())
	do 
		if act.HasProperty("Kill") then act.Kill() end
	end
	
	--annihilation victory check
	if Annihillated.atreides and Annihillated.ordos then mercenaries.MarkCompletedObjective(ObjectiveM) end
	if Annihillated.atreides and Annihillated.mercenaries then ordos.MarkCompletedObjective(ObjectiveO) end
	if Annihillated.mercenaries and Annihillated.ordos then atreides.MarkCompletedObjective(ObjectiveA) end
end

function getMapEdge(posB,posA)
	local bnds = {}
	bnds.Top=mapbounds.Top
	bnds.Bottom=mapbounds.Top+mapbounds.Height
	bnds.Left=mapbounds.Left
	bnds.Right=mapbounds.Left+mapbounds.Width
	--catch zero devision errors
	if posB.X-posA.X == 0 
	then 
		if posB.Y<posA.Y then return CPos.New(posA.X,bnds.Top)
		else return CPos.New(posA.X,bnds.Bottom)
		end
	elseif posB.Y-posA.Y == 0 
	then 
		if posB.X<posA.X then return CPos.New(bnds.Left,posA.Y)
		else return CPos.New(bnds.Right,posA.Y)
		end
	end
	
	--compute all boundary intersections
	local slope = (posB.Y-posA.Y)/(posB.X-posA.X)
	local topX   = posA.X - (posA.Y-bnds.Top)/slope
	local bottomX= posA.X + (bnds.Bottom-posA.Y)/slope
	local rightY = posA.Y + (bnds.Right-posA.X)*slope
	local leftY =  posA.Y - (posA.X-bnds.Left)*slope
	
	local top = CPos.New(math.floor(topX),bnds.Top)
	local bottom = CPos.New(math.floor(bottomX),bnds.Bottom)
	local right = CPos.New(bnds.Right, math.floor(rightY))
	local left = CPos.New(bnds.Left, math.floor(leftY))	
	
	--decide which of them is reasonable
	local positiveDelX = 0 < (posB.X-posA.X)
	local positiveSlope= 0 < slope 
	
	if positiveDelX and positiveSlope
	then 
		if bottom.X<=bnds.Right then return bottom
		else return right
		end
	elseif positiveDelX and not positiveSlope
	then
		if top.X<=bnds.Right then return top
		else return right
		end
	elseif not positiveDelX and positiveSlope
	then
		if top.X>=bnds.Left then return top
		else return left
		end
	elseif not positiveDelX and not positiveSlope
	then
		if bottom.X>=bnds.Left then return bottom
		else return left
		end
	end
	Media.DisplayMessage(" in Function getMapEdge, no Edge matched, returning default. (0,0)","Error")
	return CPos.New(0,0)
end

function dropAirReinforcements(location,dummy)
	local squad
	if dummy.Type=="waypoint_dummy_a" then squad=1
	elseif dummy.Type=="waypoint_dummy_h" then squad=2
	elseif dummy.Type=="waypoint_dummy_o" then squad=3 
	end
	--Carryall reinforcements
	local base = dummy.Owner.GetActorsByType("outpost")[1]
	local edge = getMapEdge(base.Location, location)
	local path = {edge,location}
	local units = Reinforcements.ReinforceWithTransport(dummy.Owner, "carryall.controllable", ReinforcementSquads[squad], path, {path[2], path[1]})
	local carryall = units[1]
	Trigger.OnPassengerExited(carryall,
		function(carry, pass) 
			if not carry.HasPassengers 
			then 
				carry.Move(path[1]) 
				carry.Destroy() 
			end
		end
	)
end

function replace_silos(player)
	local res = player.Resources
	for _, actor in pairs(player.GetActorsByType("silo")) do
		local loc=actor.Location
		actor.Destroy()
		Actor.Create("advanced_silo", true, { Owner = player, Location = loc })
	end
	--give the game time to contemplate consequences of rapid player.ResourceCapacity changes, then correct.
	Trigger.AfterDelay(DateTime.Seconds(0.1),
					function() 
						player.Resources = res
					end
				)
end