PlayerNames = {'Multi0', 'Multi1', 'Multi2', 'Multi3'}
PlayerObjects = {}
PlayerObjectives = {}
PlayerState = {}
PlayerSquads = {}
PlayerStarts = {}

Squads = {
	{
		name = 'the Rocket Crew',
		units = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1',
			'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3',
			'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3',
			'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3',
			'e3', 'e3', 'e3', 'e3'
		}
	},{
		name = 'the Rifle Squad',
		units = {
			'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1','e1', 'e1', 'e1', 'e1',
			'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1',
			'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1',
			'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1',
			'e1', 'e1', 'e1', 'e1'
		}
	},{
		name = 'the Civilian Wanderers',
		units = {
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'c10',
			'mnly'
		}
	},{
		name = 'Tanya',
		units = {
			'e7', 'jeep'
		}
	},{
		name = 'the Soviet Infantry Mixup',
		units = {
			'hijacker', 'hijacker', 'e4', 'e4', 'e4', 'e4', 'e4', 'dog','dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 
			'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'dog', 'shok', 'shok', 'shok', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2'
		}
	},{
		name = 'MAMMOTH TANKS',
		units = {
			'4tnk', '4tnk', '4tnk',
		}
	},{
		name = 'Chronos and a Mammoth',
		units = {
			'4tnk', 'ctnk', 'ctnk', 'ctnk',
		}
	},{
		name = 'Arty Spam',
		units = {
			'arty', 'arty', 'arty', 'arty', 'jeep', 'jeep'
		}
	},{
		name = 'the V2 Cleanup Crew',
		units = {
			'v2rl', 'v2rl', 'v2rl', 'v2rl', 'ftrk', 'ftrk'
		}
	},{
		name = 'Tesla V2s',
		units = {
			'v2rl', 'v2rl', 'ttnk', 'ttnk'
		}
	},{
		name = 'a little suprise',
		units = {
			'apc', 'apc', 'apc', 'dtrk'
		}
	}
}

Starts = {
	{
		taken = false,
		path = {CPos.New(1,1), CPos.New(10,10)},
		name = 'Top Left'
	},{
		taken = false,
		path = {CPos.New(48,48), CPos.New(39,39)},
		name = 'Bottom Right'
	},{
		taken = false,
		path = {CPos.New(48,1), CPos.New(39,10)},
		name = 'Top Right'
	},{
		taken = false,
		path = {CPos.New(1,48), CPos.New(10,39)},
		name = 'Bottom Left'
	}
}

function SpawnDefences(line_list, cycle)
	local start_pos_x
	local start_pos_y
	local end_pos_x
	local end_pos_y
	local mod_x
	local mod_y
	local x
	local y
	local creeps = Player.GetPlayer('Creeps')
	local cycle_i = 1
	local cycle_length = #cycle
	local cycle_current
	for i,v in ipairs(line_list) do
		start_pos_x = v[1]
		start_pos_y = v[2]
		end_pos_x = v[3]
		end_pos_y = v[4]
		
		if start_pos_x <= end_pos_x then
			mod_x = 1
		else
			mod_x = -1
		end
		
		if start_pos_y <= end_pos_y then
			mod_y = 1
		else
			mod_y = -1
		end

		x = start_pos_x
		y = start_pos_y
		while true do
			cycle_current = cycle[cycle_i]
			cycle_i = cycle_i + 1
			if cycle_i > cycle_length then
				cycle_i = 1
			end
			
			Actor.Create(cycle_current, true, {
				Owner = creeps,
				Location = CPos.New(x,y)
			})
			-- maybe should work out a ratio and use that to get a nice even slope but for now just add 1 each time
			if x == end_pos_x and y == end_pos_y then
				break
			end
			if x ~= end_pos_x then
				x = x + mod_x
			end
			if y ~= end_pos_y then
				y = y + mod_y
			end
		end
	end

end

-- A bit fiddly so in its own function until I find a cleaner way
function RandomiseStarts()
	local available
	local spawn_id
	for i,v in ipairs(PlayerNames) do
		-- Get available start_ids
		available = {}
		for j,w in ipairs(Starts) do
			if w.taken == false then
				available[#available + 1] = j
			end
		end
		spawn_id = available[Utils.RandomInteger(1, #available + 1)]
		Starts[spawn_id].taken = true
		PlayerStarts[i] = spawn_id
	end
end

function PlayerIdFromPlayer(player)
	local name = player.InternalName
	for i,v in ipairs(PlayerNames) do
		if v == name then
			return i
		end
	end
end

function OnPlayerLostCallback(player)
	local i = PlayerIdFromPlayer(player)
	PlayerState[i] = 'dead'
end

function WorldLoaded()
RandomiseStarts()
  Media.DisplayMessage('Welcome to squish v0.1!', 'Briefing')  
  Media.DisplayMessage('It\'s a fight to the death. Last man standing wins the game.', 'Briefing')
  Media.DisplayMessage('Collect the crates for power-ups.', 'Briefing')
  Media.DisplayMessage('Defences will spawn from the outside in, so get control of the middle to win!', 'Briefing')

  for i,v in ipairs(PlayerNames) do
    local player = Player.GetPlayer(v)
	if player == nill then
		PlayerState[i] = 'dead'
	else
		PlayerObjects[i] = player
		PlayerObjectives[i] = player.AddPrimaryObjective("Kill all enemy units.")
		PlayerState[i] = 'alive'
		
		Trigger.OnPlayerLost(player, OnPlayerLostCallback)
		
		local squad_id = Utils.RandomInteger(1, #Squads + 1)
		PlayerSquads[i] = squad_id
		Media.DisplayMessage(player.Name .. ' has started with ' .. Squads[squad_id].name .. ' in the ' .. Starts[PlayerStarts[i]].name, 'Game')
		Reinforcements.Reinforce(player, Squads[squad_id].units, Starts[PlayerStarts[i]].path, 3)
	  end
	end
end

-- 25 ticks per second

OuterWarningTime = 30 * 25
InnerWarningTime = 90 * 25
OuterWarning = false
InnerWarning = false

OuterEngageTime = 60 * 25
InnerEngageTime = 120 * 25
OuterEngaged = false
InnerEngaged = false
DefenceCycle = {'pbox','tsla'} -- ,'ftur','gun'

Tick = function()
	if DateTime.GameTime > 125 then
		local alive = 0
		for i,v in ipairs(PlayerObjects) do
			if PlayerState[i] == 'alive' then
				if next(v.GetGroundAttackers()) == nil then
				Media.DisplayMessage(v.Name .. ' has been squished.', 'Briefing')
					v.MarkFailedObjective(PlayerObjectives[i])
					PlayerState[i] = 'dead'
				else
					alive = alive + 1
				end
			end
		end
		if alive <= 1 then
			for i,v in ipairs(PlayerObjects) do
				if PlayerState[i] == 'alive' then
					Media.DisplayMessage(v.Name .. ' is victorious!', 'Briefing')
					v.MarkCompletedObjective(PlayerObjectives[i])
					PlayerState[i] = 'winner'
				end
			end
		end
	end
	
	
	if DateTime.GameTime > OuterEngageTime and OuterEngaged == false then
		OuterEngaged = true
		SpawnDefences({
			{8,1,43,1},
			{6,48,43,48},
			{1,7,1,42},
			{48,9,48,42}
		},DefenceCycle)
	end
	
	if DateTime.GameTime > InnerEngageTime and InnerEngaged == false then
		InnerEngaged = true	
		SpawnDefences({
			{14,19,14,14},
			{15,14,19,14},
			{30,14,35,14},
			{35,15,35,19},
			{14,30,14,35},
			{15,35,19,35},
			{30,35,35,35},
			{35,34,35,30},
		},DefenceCycle)
	end
	
	if DateTime.GameTime > OuterWarningTime and OuterWarning == false then
		OuterWarning = true
		Media.DisplayMessage('Outer defences will be engaged in 30 seconds!', 'Warning')
	end
	
	if DateTime.GameTime > InnerWarningTime and InnerWarning == false then
		InnerWarning = true
		Media.DisplayMessage('Inner defences will be engaged in 30 seconds!', 'Warning')
	end
end