ThopterDiscovered=false
TroopCrawlerDiscovered=false
mapbounds= {Left=2,Top=2,Width=92,Height=81} --ADJUST for new maps!!
ActorRegister={}
TrackedPairs = {}
Upgrade_Producers = {}
ReinforcementSquads = {
	{"vet_light_inf","vet_light_inf","vet_light_inf","vet_trooper","vet_trooper"},
	{"quad","quad","sardaukar","sardaukar"},
	{"trooper","trooper","trooper","trooper", "trooper"}
	}
AtreidesBaseAdvice={"Sovereign, we have to establish a BASE here first. Deploy the MOBILE CRANE, we can pack it back up later.",
"Sovereign, we should recruit some MORE TROOPS, our savings allow it.",
"Your Highness, to unlock UPGRADES for advanced troops build an OUTPOST.",
"Sire, if we UPGRADE the OUTPOST now we can get reinforcements later.",
"We are well established, Sire. We should un-deploy the CRANE and TAKE NEW TERRITORY.",
"Your Highness, I propose we  build silos and upgrade them. It pays off in the long term."}
AtreidesMapAdvice={"Sire, our Fremen friends are somewhere in the North. CAPTURE one of their cliff SIETCHes to grant us powerful Fremen troops.",
"Sire, to the East SMUGGLER carryalls have been sighted. They might have a BASE there.",
"Sire, before us are the remnants of the former Ordos city. CAPTURE as much TECHNOLOGY and PRODUCTION as we can get.",
"Sire! The Harkonnen base! Be careful, it is well fortified!",
"Your Highness, those are Harkonnen ORNITHOPTERS. We should shoot them down quickly with our missile tanks.",
"Sire, those are Harkonnen troop transports. Beware, they might carry a squad of sardaukar!"}
HarkonnenBaseAdvice={"Sire, this cheap leased base doesn't have any building construction. Fortunately we can build defenses with the PALACE and purchase upgrades from the OUTPOST.",
"Also I, as your humble Advisor, propose we use our STARPORT to call in high tech troops the nasty Atreides can't deal with.\nWe should also scout the area wih our two LIGHT THOPTERS.",
"Your Highness! Our funds are dwindling - please order more HARVESTERS."}
HarkonnenMapAdvice={"Ah, the Smugglers, our friends! We could SEND ENGINEERS to take over their spice production, Sire.",
"Fremen Scum! Their SKYHUNTER INFANTRY can shoot down your Ornithopters, Milord. We might want to destroy all their cave Sietches.",
"There lie the remnants of the Ordos in ruin. You could order some of your ENGINEERS to CAPTURE valuable TECHNOLOGY, Milord.",
"Milord, the Atreides base! They seem to only have a LEIGHTWEIGHT MCV with them - and so, are restricted to basic technology."}
	
	
WorldLoaded = function()
ordos    = Player.GetPlayer("Ordos")
atreides = Player.GetPlayer("Atreides")
harkonnen = Player.GetPlayer("Harkonnen")
fremen 	=	Player.GetPlayer("Fremen")

--wither ordos walls
for iter, act in pairs(ordos.GetActors()) 
	do
		if act.Type == "wall" then act.Health = 0.2*act.MaxHealth 
		end
end
--kill automatic ordos carryalls
Trigger.AfterDelay(DateTime.Seconds(0.1),function()
		for _,act in pairs(ordos.GetActors())
		do 
			if act.Type=="carryall.reinforce" then act.Kill() end
		end
	end)
--set starting cash (rules:	PlayerResources: DefaultCashLocked: True currently bugged -> prevents players from joining)
harkonnen.Cash=10000
atreides.Cash =10000	
	
--Introductory text	
if atreides and atreides.IsLocalPlayer
	then
		Media.DisplayMessage("Spread Atreides influence and destroy all Harkonnen forces!","Your Mission",HSLColor.LawnGreen)
end
if harkonnen and harkonnen.IsLocalPlayer
	then
		Media.DisplayMessage("Destroy all Atreides forces!","Your Mission",HSLColor.Red)
end

--Set up part one of the mission-text triggers (Mentat Advisor help text)
summonAtreidesMentat()
summonHarkonnenMentat()

--victory messages
Trigger.OnObjectiveCompleted(atreides, 
	function(p,id) 
		Media.DisplayMessage("The Atreides have liberated the territory!","Mission Success",HSLColor.Blue) 
		Media.DisplayMessage("The Harkonnen are fleeing!","Mission Failure",HSLColor.Red)
	end)
Trigger.OnObjectiveCompleted(harkonnen, 
	function(p,id) 
		Media.DisplayMessage("The Harkonnen strengthened their grip on the area!","Mission Success",HSLColor.Red)
		Media.DisplayMessage("The Atreides were driven back!","Mission Failure",HSLColor.Blue)
	end)
end

Tick = function()
	--check register for new actors and only call act.Type=="whatever" when neccessary since it is expensive
	local new_actors = ActorsAddedToWorld(Map.ActorsInWorld,ActorRegister)

	for _,act in pairs(new_actors) 
	do
	--ACTOR TYPE CHECKS
		local T=act.Type
		--needed for airdrop powers
		if (T=="waypoint_dummy_a" or T=="waypoint_dummy_h" or T=="waypoint_dummy_o")
		then
			dropAirReinforcements(act.Location,act)
		--...handle advanced_silo upgrade
		elseif T=="construction_yard" or T=="outpost" 
		then
			table.insert(Upgrade_Producers,act)
			--for each new producer set a trigger
			Trigger.OnProduction(act, 
				function(producer, produced)		
					if produced.Type=="upgrade.silo"
					then --advanced silo upgrade trigger
						replace_silos(act.Owner)
					end
				end)
		--...Handle saboteur entering a harvester which is getting picked up by a carryall before the Demolition charge explodes (Both will die)
		elseif (T == "harvester" or T == "advanced_harvester_h"  or T == "advanced_harvester_a" or T == "advanced_harvester_o" or T == "harvester.starport") and TrackedPairs[tostring(act)]==nil
		then
			TrackedPairs[tostring(act)]='NoCarryall'
			Trigger.OnKilled(act, 
				function(harvester,killer)
					local MaybeCarryall = TrackedPairs[tostring(harvester)]
					if MaybeCarryall~='NoCarryall' and MaybeCarryall~=nil
					then
						if MaybeCarryall.HasProperty('Kill') 
						then 
							MaybeCarryall.Kill()
							Media.PlaySound('EXPLLG2.WAV')
						end
					else
					end
				end
			)
			Trigger.OnRemovedFromWorld(act, 
				function(harv)
					local carryalls = Map.ActorsInCircle(harv.CenterPosition, WDist.New(1), 
						function(carry) 
							if (carry.Type=="carryall" or carry.Type=="carryall.starport") then return carry else return nil end 
						end
					)
					if carryalls[1]~=nil 
					then 
						TrackedPairs[tostring(harv)]=carryalls[1]
					end
				end 
			)
			Trigger.OnAddedToWorld(act,function(harv)
					local carryalls = Map.ActorsInCircle(harv.CenterPosition, WDist.New(1), 
						function(carry) 
							if (carry.Type=="carryall" or carry.Type=="carryall.starport") then return carry else return nil end 
						end
					)
					if carryalls[1]~=nil
					then 
						TrackedPairs[tostring(harv)]='NoCarryall'
					end
				end 
			)
		--...and Atreides Mentat "Troop Transport discovered" message check (requires AnnounceOnSeen: on unit and Player: EnemyWatcher in map.yaml)
		elseif not TroopCrawlerDiscovered and act.Type=="troop_crawler"
		then
			Trigger.OnDiscovered(act,function(discoveringAct,owner)
				if owner==atreides 
				then
					TroopCrawlerDiscovered=true
					sayTo(atreides, AtreidesMapAdvice[6])
					AtreidesMapAdvice[6]=nil
				end
			end)
		--...and Atreides Mentat "Ornithopter discovered" message check (requires AnnounceOnSeen: on unit and Player: EnemyWatcher in map.yaml)
		elseif not ThopterDiscovered and act.Type=="light_thopter"
		then
			Trigger.OnDiscovered(act, function(discoveringAct, owner)
				if owner==atreides 
				then
					ThopterDiscovered=true
					sayTo(atreides, AtreidesMapAdvice[5])
					AtreidesMapAdvice[5]=nil
				end
			end)
		end	
	end

--Set up part two of the mission-text triggers (Mentat Advisor help text)
taskAtreidesMentat()
taskHarkonnenMentat()
end

function ActorsAddedToWorld(newlist,register)
	local new_actor_list={}
	for key,act in pairs(newlist)
	do
		if not register[tostring(act)]
		then
			register[tostring(act)]=true
			table.insert(new_actor_list,act)
		end
	end
	return new_actor_list
end

function summonAtreidesMentat()
--common/standard triggers used for mentat advice
Trigger.AfterDelay(DateTime.Seconds(10),function()
	sayTo(atreides, AtreidesBaseAdvice[1])
	end)
Trigger.AfterDelay(DateTime.Minutes(6),function()
		if atreides.HasPrerequisites({"crane"}) 
		then
			sayTo(atreides, AtreidesBaseAdvice[6]) 
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(2,47,37,47),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[1])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)

Trigger.OnEnteredFootprint(getCPossesInRectangle(46,63,46,82),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[2])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(36,35,44,49),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[3])
			AtreidesMapAdvice[3]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(68,47,71,52),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[3])
			AtreidesMapAdvice[3]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(78,19,92,37),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[4])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
end

function summonHarkonnenMentat()
--common/standard triggers used for mentat advice
Trigger.AfterDelay(DateTime.Seconds(10),function()
	sayTo(harkonnen,HarkonnenBaseAdvice[1])
	end)
Trigger.AfterDelay(DateTime.Seconds(35),function()
	sayTo(harkonnen,HarkonnenBaseAdvice[2])
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(76,50,93,50),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[1])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)	
Trigger.OnEnteredFootprint(getCPossesInRectangle(65,13,70,49),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[3])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(44,7,51,14),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[2])
			HarkonnenMapAdvice[2]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(12,30,18,35),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[2])
			HarkonnenMapAdvice[2]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(3,68,18,80),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[4])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
end
	
function taskAtreidesMentat()
--custom triggers used for mentat advice
if AtreidesBaseAdvice[2] and Utils.Any({{"barracks"},{"light_factory"},{"heavy_factory"}},atreides.HasPrerequisites)
then
	sayTo(atreides, AtreidesBaseAdvice[2])
	AtreidesBaseAdvice[2] = nil
end
if AtreidesBaseAdvice[3] and Utils.Any({{"barracks","light_factory"},{"barracks", "heavy_factory"},{"light_factory","heavy_factory"}},atreides.HasPrerequisites ) and atreides.HasPrerequisites({"crane"})
then
	if atreides.HasPrerequisites({"outpost"}) then AtreidesBaseAdvice[3] = nil end
	sayTo(atreides, AtreidesBaseAdvice[3])
	AtreidesBaseAdvice[3] = nil
end
if AtreidesBaseAdvice[4] and atreides.HasPrerequisites({"outpost"}) 
then
	sayTo(atreides, AtreidesBaseAdvice[4])
	AtreidesBaseAdvice[4] = nil
end
if AtreidesBaseAdvice[5] and atreides.HasPrerequisites({"refinery","barracks","light_factory","heavy_factory","outpost"}) and atreides.HasPrerequisites({"crane"})
then
	sayTo(atreides, AtreidesBaseAdvice[5])
	AtreidesBaseAdvice[5] = nil
end
end

function taskHarkonnenMentat()
--custom triggers used for mentat advice
if HarkonnenBaseAdvice[3] and harkonnen.Resources+harkonnen.Cash<3300
then 
	sayTo(harkonnen, HarkonnenBaseAdvice[3])
	HarkonnenBaseAdvice[3]=nil
end

--Air units unfortunately don't trigger Trigger.OnEnteredFootprint so...
local Advice = 0
for _,thopter in pairs(harkonnen.GetActorsByType("light_thopter")) do
	local x = thopter.Location.X
	local y = thopter.Location.Y
	if y>=60 and x>=69
	then
		Advice = 1
	elseif 49>=y and y>=14 and x<=71
	then
		Advice = 3
	elseif 38>=y and y>=25 and 18>=x and x>=10 --this entry is somehow bugged
	then 
		Advice = 2
	elseif 14>=y and y>=7 and 51>=x and x>=44
	then
		Advice = 2
	elseif x<=18 and y>=68
	then
		Advice = 4
	end
end
if Advice>0
then
	sayTo(harkonnen,HarkonnenMapAdvice[Advice])
	HarkonnenMapAdvice[Advice]=nil
end
end

function getCPossesInRectangle(left,top,right,bottom)
	local Cposses={}
	local length=right-left+1
	for i=top,bottom do 
		for j=left,right do 
			Cposses[(i-top)*length+(j+1-left)]=CPos.New(j,i)
		end
	end
	--for debugging
	--[[
	 for idx,cpos in pairs(Cposses) do
		Beacon.New(harkonnen,Map.CenterOfCell(cpos))
	 end
	 --]]
	return Cposses
end

function sayTo(player, message)
	if message
	then
		if player==atreides and not harkonnen.IsLocalPlayer 
		then 
			Media.DisplayMessage(message,"Mentat",HSLColor.LawnGreen)
		elseif player==harkonnen and not atreides.IsLocalPlayer 
		then 
			Media.DisplayMessage(message,"Mentat",HSLColor.Red)
		end
	end
end

function dropAirReinforcements(location,dummy)
	local squad
	if dummy.Type=="waypoint_dummy_a" then squad=1
	elseif dummy.Type=="waypoint_dummy_h" then squad=2
	elseif dummy.Type=="waypoint_dummy_o" then squad=3 
	end
	--Carryall reinforcements
	local base = dummy.Owner.GetActorsByType("outpost")[1]
	local edge = getMapEdge(base.Location, location)
	local path = {edge,location}
	local units = Reinforcements.ReinforceWithTransport(dummy.Owner, "carryall.controllable", ReinforcementSquads[squad], path, {path[2], path[1]})
	local carryall = units[1]
	Trigger.OnPassengerExited(carryall,
		function(carry, pass) 
			if not carry.HasPassengers 
			then 
				carry.Move(path[1]) 
				carry.Destroy() 
			end
		end
	)
end

function getMapEdge(posB,posA)
	local bnds = {}
	bnds.Top=mapbounds.Top
	bnds.Bottom=mapbounds.Top+mapbounds.Height
	bnds.Left=mapbounds.Left
	bnds.Right=mapbounds.Left+mapbounds.Width
	--catch zero devision errors
	if posB.X-posA.X == 0 
	then 
		if posB.Y<posA.Y then return CPos.New(posA.X,bnds.Top)
		else return CPos.New(posA.X,bnds.Bottom)
		end
	elseif posB.Y-posA.Y == 0 
	then 
		if posB.X<posA.X then return CPos.New(bnds.Left,posA.Y)
		else return CPos.New(bnds.Right,posA.Y)
		end
	end
	
	--compute all boundary intersections
	local slope = (posB.Y-posA.Y)/(posB.X-posA.X)
	local topX   = posA.X - (posA.Y-bnds.Top)/slope
	local bottomX= posA.X + (bnds.Bottom-posA.Y)/slope
	local rightY = posA.Y + (bnds.Right-posA.X)*slope
	local leftY =  posA.Y - (posA.X-bnds.Left)*slope
	
	local top = CPos.New(math.floor(topX),bnds.Top)
	local bottom = CPos.New(math.floor(bottomX),bnds.Bottom)
	local right = CPos.New(bnds.Right, math.floor(rightY))
	local left = CPos.New(bnds.Left, math.floor(leftY))	
	
	--decide which of them is reasonable
	local positiveDelX = 0 < (posB.X-posA.X)
	local positiveSlope= 0 < slope 
	
	if positiveDelX and positiveSlope
	then 
		if bottom.X<=bnds.Right then return bottom
		else return right
		end
	elseif positiveDelX and not positiveSlope
	then
		if top.X<=bnds.Right then return top
		else return right
		end
	elseif not positiveDelX and positiveSlope
	then
		if top.X>=bnds.Left then return top
		else return left
		end
	elseif not positiveDelX and not positiveSlope
	then
		if bottom.X>=bnds.Left then return bottom
		else return left
		end
	end
	Media.DisplayMessage(" in Function getMapEdge, no Edge matched, returning default. (0,0)","Error")
	return CPos.New(0,0)
end

function replace_silos(player)
	local res = player.Resources
	for _, actor in pairs(player.GetActorsByType("silo")) do
		local loc=actor.Location
		actor.Destroy()
		Actor.Create("advanced_silo", true, { Owner = player, Location = loc })
	end
	--give the game time to contemplate consequences of rapid player.ResourceCapacity changes, then correct.
	Trigger.AfterDelay(DateTime.Seconds(0.1),
					function() 
						player.Resources = res
					end
				)
end

function noDuplicate(actor, actorlist)
  for _, value in pairs(actorlist) do
    if value == actor then
      return false
    end
  end
  return true
end