SovietAttackPoints = {AttackDest1,AttackDest2,AttackDest3}
ChronoshiftLocations = {ChronoshiftLocation1,ChronoshiftLocation2,ChronoshiftLocation3,ChronoshiftLocation4}

if DateTime.IsHalloween then
	UnitTypes = { "ant", "ant", "ant" }
	BeachUnitTypes = { "ant", "ant" }
	ProxyType = "powerproxy.parazombies"
	ProducedUnitTypes =
	{
		{ factory = AlliedBarracks1, types = { "e1", "e3" } },
		{ factory = AlliedBarracks2, types = { "e1", "e3" } },
		{ factory = SovietBarracks1, types = { "ant" } },
		{ factory = SovietBarracks2, types = { "ant" } },
		{ factory = SovietBarracks3, types = { "ant" } },
		{ factory = AlliedWarFactory1, types = { "jeep", "1tnk", "2tnk", "arty", "ctnk" } },
		{ factory = SovietWarFactory1, types = { "3tnk", "4tnk", "v2rl", "ttnk", "apc.loaded" } }
	}
else
	UnitTypes = { "3tnk", "ftrk", "ttnk", "apc.loaded" }
	BeachUnitTypes = { "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4", "e1", "e2", "e3", "e4" }
	ProxyType = "powerproxy.paratroopers"
	ProducedUnitTypes =
	{
		{ factory = AlliedBarracks1, types = { "e1", "e3" } },
		{ factory = AlliedBarracks2, types = { "e1", "e3" } },
		{ factory = SovietBarracks1, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
		{ factory = SovietBarracks2, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
		{ factory = SovietBarracks3, types = { "dog", "e1", "e2", "e3", "e4", "shok" } },
		{ factory = AlliedWarFactory1, types = { "jeep", "1tnk", "2tnk", "arty", "ctnk" } },
		{ factory = SovietWarFactory1, types = { "3tnk", "4tnk", "v2rl", "ttnk", "apc.loaded" } }
	}
end

ShipUnitTypes = { "1tnk", "1tnk", "jeep", "2tnk", "2tnk" }
SovietShipUnitTypes = { "e1", "e1", "e1", "e2", "e2" }
HelicopterUnitTypes = { "e1", "e1", "e1", "e1", "e3", "e3" };

ParadropWaypoints = { Paradrop1, Paradrop2, Paradrop3, Paradrop4, Paradrop5, Paradrop6, Paradrop7, Paradrop8, Paradrop9 }

BindActorTriggers = function(a)
	if a.HasProperty("Hunt") then
		if a.Owner == allies then
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.Hunt()
				end
			end)
		else
		-- AlliedTechnologyCenter.Location
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					local atkdest = Utils.Random(SovietAttackPoints)
					a.AttackMove(atkdest.Location)
				end
			end)
		end
	end

	if a.HasProperty("HasPassengers") then
		Trigger.OnDamaged(a, function()
			if a.HasPassengers then
				a.Stop()
				a.UnloadPassengers()
			end
		end)
	end
end

SendSovietUnits = function(entryCell, unitTypes, interval)
	local units = Reinforcements.Reinforce(soviets, unitTypes, { entryCell }, interval)
	Utils.Do(units, function(unit)
		BindActorTriggers(unit)
	end)
	--ProducedUnitTypes[2346]
	local alldeadtest = (SovietBarracks1.IsDead and 
		SovietBarracks2.IsDead and 
		SovietBarracks3.IsDead and 
		SovietWarFactory1.IsDead)
	
	if alldeadtest then
		Media.DisplayMessage("Soviet Land Reinforcements Stopped")
	else
		Trigger.OnAllKilled(units, function() SendSovietUnits(entryCell, unitTypes, interval) end)
	end
end

ShipAlliedUnits = function(unloadCell,interval)
	local units = Reinforcements.ReinforceWithTransport(allies, "lst",
		ShipUnitTypes, { LstEntry.Location, unloadCell }, { LstEntry.Location })[2]

	Utils.Do(units, function(unit)
		BindActorTriggers(unit)
	end)
	if not AlliedShipyard.IsDead then
		Trigger.AfterDelay(DateTime.Seconds(interval), function() ShipAlliedUnits(unloadCell,interval) end)
	else
		Media.DisplayMessage("Allied Naval Reinforcements Stopped")
	end
end

ShipSovietUnits = function(unloadCell,interval)
	local units = Reinforcements.ReinforceWithTransport(soviets, "lst",
		SovietShipUnitTypes, { SovietLstEntry.Location, unloadCell }, { SovietLstEntry.Location })[2]

	Utils.Do(units, function(unit)
		BindActorTriggers(unit)
	end)
	if not SovietSubPen.IsDead then
		Trigger.AfterDelay(DateTime.Seconds(interval), function() ShipSovietUnits(unloadCell,interval) end)
	else
		Media.DisplayMessage("Soviet Naval Reinforcements Stopped")
	end
end

InsertAlliedChinookReinforcements = function(entry, hpad)
	if not hpad.IsDead then
		local units = Reinforcements.ReinforceWithTransport(allies, "tran",
			HelicopterUnitTypes, { entry.Location, hpad.Location + CVec.New(1, 2) }, { entry.Location })[2]

		Utils.Do(units, function(unit)
			BindActorTriggers(unit)
		end)

		Trigger.AfterDelay(DateTime.Seconds(60), function() InsertAlliedChinookReinforcements(entry, hpad) end)
	else
		Media.DisplayMessage("Allied Chinook Reinforcements Stopped")
	end
end

ParadropSovietUnits = function()
	local lz = Utils.Random(ParadropWaypoints)
	local units = powerproxy.SendParatroopers(lz.CenterPosition)

	Utils.Do(units, function(a)
		BindActorTriggers(a)
	end)

	local alldeadtest = (SovietBarracks1.IsDead and 
		SovietBarracks2.IsDead and 
		SovietBarracks3.IsDead and 
		SovietWarFactory1.IsDead)
	
	if alldeadtest then
		Media.DisplayMessage("Soviet Paradrop Reinforcements Stopped")
	else
		Trigger.AfterDelay(DateTime.Seconds(35), ParadropSovietUnits)
	end
end

ProduceUnits = function(t)
	local factory = t.factory
	if not factory.IsDead then
		local unitType = t.types[Utils.RandomInteger(1, #t.types + 1)]
		factory.Wait(Actor.BuildTime(unitType))
		factory.Produce(unitType)
		factory.CallFunc(function() ProduceUnits(t) end)
	end
end

SetupAlliedUnits = function()
	Utils.Do(Map.NamedActors, function(a)
		if a.Owner == allies and a.HasProperty("AcceptsCondition") and a.AcceptsCondition("baseguard") then
			a.GrantCondition("baseguard")
			a.Stance = "Defend"
		end
	end)
end

SetupFactories = function()
	Utils.Do(ProducedUnitTypes, function(production)
		Trigger.OnProduction(production.factory, function(_, a) BindActorTriggers(a) end)
	end)
end

ChronoForceUnits = {"2tnk.chrono","jeep.chrono","arty.chrono","1tnk.chrono","stnk.chrono"}

ChronoshiftAlliedUnits = function(chronoloc)
	local chronodest = Utils.Random(ChronoshiftLocations)
	local cells = Utils.ExpandFootprint({ chronoloc }, false)
	local units = { }
	if not Chronosphere.IsDead then
	
		for i = 1, #cells do
			local selectchronounit = Utils.Random(ChronoForceUnits)
			local unit = Actor.Create(selectchronounit, true, { Owner = allies, Facing = 0 })
			BindActorTriggers(unit)
			units[unit] = cells[i]
		end
		Chronosphere.Chronoshift(units)
		Trigger.AfterDelay(DateTime.Seconds(60), function() ChronoshiftAlliedUnits(chronodest.Location) end)
	else
		Media.DisplayMessage("Allied Chrono Reinforcements Stopped")
	end
end
--[[
ticks = 0
speed = 5

Tick = function()
	ticks = ticks + 1

	local t = (ticks + 45) % (360 * speed) * (math.pi / 180) / speed;
	Camera.Position = viewportOrigin + WVec.New(19200 * math.sin(t), 20480 * math.cos(t), 0)
end
--]]
WorldLoaded = function()
	allies = Player.GetPlayer("Allies2")
	soviets = Player.GetPlayer("Soviets2")
	viewportOrigin = Camera.Position

	SetupAlliedUnits()
	SetupFactories()
	ShipAlliedUnits(LstUnload1.Location,60)
	ShipAlliedUnits(LstUnload2.Location,120)
--	ShipAlliedUnits(LstUnload3.Location,180)
	ShipSovietUnits(SovietLstUnload.Location,60)
	InsertAlliedChinookReinforcements(Chinook1Entry, HeliPad1)
	InsertAlliedChinookReinforcements(Chinook2Entry, HeliPad2)
	powerproxy = Actor.Create(ProxyType, false, { Owner = soviets })
	ParadropSovietUnits()
	Trigger.AfterDelay(DateTime.Seconds(5), function() ChronoshiftAlliedUnits(ChronoshiftLocation1.Location) end)
	Utils.Do(ProducedUnitTypes, ProduceUnits)

	SendSovietUnits(Entry1.Location, UnitTypes, 50)
	SendSovietUnits(Entry2.Location, UnitTypes, 50)
	SendSovietUnits(Entry3.Location, UnitTypes, 50)
	SendSovietUnits(Entry4.Location, UnitTypes, 50)
	SendSovietUnits(Entry5.Location, UnitTypes, 50)
	SendSovietUnits(Entry6.Location, UnitTypes, 50)
	SendSovietUnits(Entry7.Location, BeachUnitTypes, 15)
end
