
Sniper = { MissionAccomplished }
EggMonsterEntryPoints = { MonsterWaypoint }
EggSpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve", "reve" }
	Imp = { "imp" }
	Impx2 = { "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve" }
	Imp = { "imp" }
	Impx2 = { "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc" }
elseif Map.LobbyOption("difficulty") == "easy" then
	Mutants = { "pvice" }
	Mutantsx2 = {  }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "pvice" }
	Reve = { "reve" }
	Revex2 = { "pvice" }
	Imp = { "imp" }
	Impx2 = { "pvice"  }
	Demon = { "pinky" }
	Demonx2 = { "pvice"  }
	Mancubus = { "manc" }
	Mancubusx2 = { "pvice" }
end

EggWave = 0
EggWaves =
{
	{ delay = 1, units = {  } },--40
	{ delay = 1, units = { Mutants } },--1:20
	{ delay = 1, units = { Mutants, Mutants, Mutantsx2 } },--2:00
	{ delay = 1, units = { Mutants, Mutants, Mutantsx2 } },--240
	{ delay = 1, units = { Mutants, Arachnotron, Mutantsx2 } },--320
	{ delay = 1, units = {  } },--400
	{ delay = 1, units = { Mutantsx2, Arachnotron, Arachnotron, Arachnotron, Arachnotron, Mutants, Mutants, } },--440
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Mutantsx2, Arachnotronx2, Arachnotronx2, Reve, Arachnotron, Mutants } },--420
	{ delay = 1, units = { Mutants, Mutants, Arachnotron, Reve, Mutants, Reve, Mutantsx2 } },--500
	{ delay = 1, units = { Arachnotronx2, Mutantsx2, Revex2, Reve, Mutants, Mutants } },--540
	{ delay = 1, units = { Revex2, Revex2, Arachnotronx2, Arachnotronx2, Mutantsx2, Mutantsx2, Mutantsx2 } },--620
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Imp, Imp, Imp, Imp, Imp, Mutantsx2, Mutantsx2, Revex2 } },--700
	{ delay = 1, units = { Impx2, Impx2, Impx2, Mutantsx2, Mutantsx2, Mutantsx2, Revex2 } },--740
	{ delay = 1, units = { Impx2, Revex2, Arachnotronx2,Mutantsx2 } },--820
	{ delay = 1, units = { Demon, Demon, Demon, Demon, Reve, Reve,  } },--920
	{ delay = 1, units = {  } },--1000
	{ delay = 1, units = { Demonx2, Demon, Demon, Impx2, Revex2 } },--10:40
	{ delay = 1, units = { Demon, Demon, Mutantsx2 } },--11:20
	{ delay = 1, units = { Mutants, Mutants, Mancubus, Mutantsx2, Reve, Reve, Reve, Reve } },--240
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mancubus, Mancubus, Reve } }
}

SendUnits = function(entryCell, unitTypes, targetCell)
	Reinforcements.Reinforce(Monsters, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		a.AttackMove(targetCell)
		Trigger.OnIdle(a, function(a)
			a.Hunt()
		end)
	end)
end

EggIncreaseDifficulty = function()
	local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
	Utils.Do(EggWaves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

EggSendWave = function()
	if Egg.IsDead then
		return
	end
	EggWave = EggWave + 1
	local wave = EggWaves[EggWave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(EggMonsterEntryPoints).Location
			local target = Utils.Random(EggSpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (EggWave < #EggWaves) then
			delayFirstTeam = 40
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				EggSendWave()
				Trigger.AfterDelay(DateTime.Minutes(17), EggIncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg1
Egg1MonsterEntryPoints = { MonsterWaypoint1 }
Egg1SpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice", "pvice", "pvice", "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi", "bspi", "bspi", "bspi", "bspi",  }
	Reve = { "reve" }
	Revex2 = { "reve", "reve", "reve", "reve", "reve", "reve", "reve",  }
	Imp = { "imp" }
	Impx2 = { "imp", "imp", "imp", "imp", "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky", "pinky",  }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve", "reve" }
	Imp = { "imp" }
	Impx2 = { "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "easy" then
	Mutants = { "pvice" }
	Mutantsx2 = {  }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "pvice" }
	Reve = { "reve" }
	Revex2 = { "pvice" }
	Imp = { "imp" }
	Impx2 = { "pvice"  }
	Demon = { "pinky" }
	Demonx2 = { "pvice"  }
	Mancubus = { "manc" }
	Mancubusx2 = { "pvice" }
end

Egg1Wave = 0
Egg1Waves =
{
	{ delay = 1, units = {  } },--1:00
	{ delay = 1, units = { Mutants } },--2:00
	{ delay = 1, units = { Mutants, Mutants, Arachnotron, Mutants } },--3
	{ delay = 1, units = { Arachnotron, Arachnotron, Arachnotron, Mutantsx2, Arachnotron, Mutantsx2 } },--4
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Arachnotronx2, Reve, Reve, Reve, Mutantsx2, Reve } },--5
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Mutantsx2, Revex2, Revex2 } },--6
	{ delay = 1, units = { Imp, Mutantsx2, Imp, Revex2, Imp, Arachnotronx2, Reve } },--7
	{ delay = 1, units = {  } },--8
	{ delay = 1, units = { Impx2, Mutantsx2, Arachnotronx2, Demon, Mutantsx2, Revex2 } },--9
	{ delay = 1, units = { Mutantsx2, Demonx2, Arachnotronx2, Mutantsx2, Revex2 } },--9
	{ delay = 1, units = { Mancubus, Mutantsx2, Arachnotronx2, Mutantsx2 } },--10
	{ delay = 1, units = {  } },--8
	{ delay = 1, units = { Mancubus, Revex2 } }--11
}

Egg1IncreaseDifficulty = function()
	local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
	Utils.Do(Egg1Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg1SendWave = function()
	if Egg1.IsDead then
		return
	end
	Egg1Wave = Egg1Wave + 1
	local wave = Egg1Waves[Egg1Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg1MonsterEntryPoints).Location
			local target = Utils.Random(Egg1SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg1Wave < #Egg1Waves) then
			delayFirstTeam = 60
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg1SendWave()
				Trigger.AfterDelay(DateTime.Minutes(17), Egg1IncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg2
Egg2MonsterEntryPoints = { MonsterWaypoint2 }
Egg2SpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve", "reve" }
	Imp = { "imp" }
	Impx2 = { "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve" }
	Imp = { "imp" }
	Impx2 = { "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc" }
elseif Map.LobbyOption("difficulty") == "easy" then
	Mutants = { "pvice" }
	Mutantsx2 = {  }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "pvice" }
	Reve = { "reve" }
	Revex2 = { "pvice" }
	Imp = { "imp" }
	Impx2 = { "pvice"  }
	Demon = { "pinky" }
	Demonx2 = { "pvice"  }
	Mancubus = { "manc" }
	Mancubusx2 = { "pvice" }
end

Egg2Wave = 0
Egg2Waves =
{
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mutants } },
	{ delay = 1, units = { Arachnotron, Mutantsx2 } },
	{ delay = 1, units = { Arachnotron, Mutantsx2, Reve } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Arachnotronx2, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Arachnotronx2, Reve, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = { Mutantsx2, Revex2, Mutantsx2, Arachnotronx2 } },
	{ delay = 1, units = { Imp, Imp, Imp, Imp, Arachnotronx2, Reve } },
	{ delay = 1, units = { Impx2, Arachnotronx2, Revex2, Mutantsx2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Demon, Impx2, Mutantsx2, Demon, Arachnotronx2, Mutantsx2, Revex2 } },
	{ delay = 1, units = { Demonx2, Demonx2, Impx2, Impx2, Mutantsx2 } },
	{ delay = 1, units = { Mancubus } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mancubusx2, Mancubus } },
}

Egg2IncreaseDifficulty = function()
	local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
	Utils.Do(Egg2Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg2SendWave = function()
	if Egg2.IsDead then
		return
	end
	Egg2Wave = Egg2Wave + 1
	local wave = Egg2Waves[Egg2Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg2MonsterEntryPoints).Location
			local target = Utils.Random(Egg2SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg2Wave < #Egg2Waves) then
			delayFirstTeam = 55
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg2SendWave()
				Trigger.AfterDelay(DateTime.Minutes(17), Egg2IncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg3
Egg3MonsterEntryPoints = { MonsterWaypoint3 }
Egg3SpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve", "reve" }
	Imp = { "imp" }
	Impx2 = { "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve" }
	Imp = { "imp" }
	Impx2 = { "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc" }
elseif Map.LobbyOption("difficulty") == "easy" then
	Mutants = { "pvice" }
	Mutantsx2 = {  }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "pvice" }
	Reve = { "reve" }
	Revex2 = { "pvice" }
	Imp = { "imp" }
	Impx2 = { "pvice"  }
	Demon = { "pinky" }
	Demonx2 = { "pvice"  }
	Mancubus = { "manc" }
	Mancubusx2 = { "pvice" }
end

Egg3Wave = 0
Egg3Waves =
{
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mutants } },
	{ delay = 1, units = { Mutantsx2, Arachnotron, Mutantsx2 } },
	{ delay = 1, units = { Mutantsx2, Arachnotronx2, Mutantsx2, Arachnotron } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Arachnotronx2, Reve, Mutantsx2, Arachnotronx2 } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Arachnotronx2, Arachnotronx2, Revex2 } },
	{ delay = 1, units = { Imp, Mutantsx2, Imp, Arachnotronx2, Imp, Revex2, Reve } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Impx2, Impx2, Demon, Reve } },
	{ delay = 1, units = { Demonx2, Demonx2, Impx2, Revex2 } },
	{ delay = 1, units = { Mancubus, Mutantsx2, Arachnotronx2, Mutantsx2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mancubusx2, Impx2, Revex2 } }
}

Egg3IncreaseDifficulty = function()
	local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
	Utils.Do(Egg3Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg3SendWave = function()
	if Egg3.IsDead then
		return
	end
	Egg3Wave = Egg3Wave + 1
	local wave = Egg2Waves[Egg2Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg3MonsterEntryPoints).Location
			local target = Utils.Random(Egg3SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg3Wave < #Egg3Waves) then
			delayFirstTeam = 65
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg3SendWave()
				Trigger.AfterDelay(DateTime.Minutes(20), Egg3IncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg4
Egg4MonsterEntryPoints = { MonsterWaypoint4 }
Egg4SpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve", "reve" }
	Imp = { "imp" }
	Impx2 = { "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve" }
	Imp = { "imp" }
	Impx2 = { "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc" }
elseif Map.LobbyOption("difficulty") == "easy" then
	Mutants = { "pvice" }
	Mutantsx2 = {  }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "pvice" }
	Reve = { "reve" }
	Revex2 = { "pvice" }
	Imp = { "imp" }
	Impx2 = { "pvice"  }
	Demon = { "pinky" }
	Demonx2 = { "pvice"  }
	Mancubus = { "manc" }
	Mancubusx2 = { "pvice" }
end

Egg4Wave = 0
Egg4Waves =
{
	{ delay = 1, units = { } },
	{ delay = 1, units = { Mutants } },
	{ delay = 1, units = { Mutantsx2, Mutants, Mutants, Mutantsx2, Arachnotron } },
	{ delay = 1, units = { Mutantsx2, Arachnotronx2, Arachnotronx2, Mutantsx2 } },
	{ delay = 1, units = { } },
	{ delay = 1, units = { Arachnotronx2, Reve, Mutantsx2, Mutantsx2, Arachnotronx2 } },
	{ delay = 1, units = { Mutantsx2, Mutants, Revex2, Revex2, Arachnotronx2 } },
	{ delay = 1, units = { Imp, Imp, Mutantsx2, Mutantsx2, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = { } },
	{ delay = 1, units = { Imp, Revex2, Impx2, Impx2, Revex2, Impx2 } },
	{ delay = 1, units = { Demon, Reve, Arachnotron, Demon } },
	{ delay = 1, units = { Demon, Demon, Demonx2 } },
	{ delay = 1, units = { } },
	{ delay = 1, units = { Mancubus, Mancubusx2 } }
}

Egg4IncreaseDifficulty = function()
	local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
	Utils.Do(Egg4Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg4SendWave = function()
	if Egg4.IsDead then
		return
	end
	Egg4Wave = Egg4Wave + 1
	local wave = Egg4Waves[Egg4Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg4MonsterEntryPoints).Location
			local target = Utils.Random(Egg4SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg4Wave < #Egg4Waves) then
			delayFirstTeam = 70
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg4SendWave()
				Trigger.AfterDelay(DateTime.Minutes(16), Egg4IncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg5
Egg5MonsterEntryPoints = { MonsterWaypoint5 }
Egg5SpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve", "reve" }
	Imp = { "imp" }
	Impx2 = { "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve" }
	Imp = { "imp" }
	Impx2 = { "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc" }
elseif Map.LobbyOption("difficulty") == "easy" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "pvice" }
	Reve = { "reve" }
	Revex2 = { "pvice" }
	Imp = { "imp" }
	Impx2 = { "pvice"  }
	Demon = { "pinky" }
	Demonx2 = { "pvice"  }
	Mancubus = { "manc" }
	Mancubusx2 = { "pvice" }
end

Egg5Wave = 0
Egg5Waves =
{
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mutants } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Mutantsx2, Arachnotron } },
	{ delay = 1, units = { Mutantsx2, Arachnotron, Arachnotronx2, Mutantsx2 } },
	{ delay = 1, units = { Mutantsx2, Arachnotronx2, Mutantsx2, Arachnotronx2, Mutantsx2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Arachnotronx2, Reve, Mutantsx2, Arachnotronx2, Mutantsx2 } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Imp, Arachnotronx2, Arachnotronx2, Revex2, Revex2 } },
	{ delay = 1, units = { Imp, Mutantsx2, Impx2, Arachnotronx2, Imp, Revex2 } },
	{ delay = 1, units = { Impx2, Impx2, Demon, Arachnotronx2, Demon, Revex2, Revex2 } },
	{ delay = 1, units = { Demonx2, Demonx2, Arachnotronx2, Revex2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mancubus, Mutantsx2, Mutantsx2, Revex2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mancubus, Mancubusx2, Impx2 } }
}

Egg5IncreaseDifficulty = function()
	local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
	Utils.Do(Egg5Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg5SendWave = function()
	if Egg5.IsDead then
		return
	end
	Egg5Wave = Egg5Wave + 1
	local wave = Egg5Waves[Egg5Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg5MonsterEntryPoints).Location
			local target = Utils.Random(Egg5SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg5Wave < #Egg5Waves) then
			delayFirstTeam = 75
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg5SendWave()
				Trigger.AfterDelay(DateTime.Minutes(18), Egg5IncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg6
Egg6MonsterEntryPoints = { MonsterWaypoint6 }
Egg6SpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve", "reve" }
	Imp = { "imp" }
	Impx2 = { "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve" }
	Imp = { "imp" }
	Impx2 = { "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc" }
elseif Map.LobbyOption("difficulty") == "easy" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "pvice" }
	Reve = { "reve" }
	Revex2 = { "pvice" }
	Imp = { "imp" }
	Impx2 = { "pvice"  }
	Demon = { "pinky" }
	Demonx2 = { "pvice"  }
	Mancubus = { "manc" }
	Mancubusx2 = { "pvice" }
end

Egg6Wave = 0
Egg6Waves =
{
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mutants } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Mutantsx2, Arachnotron, Arachnotron, Arachnotron } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Mutantsx2, Arachnotronx2, Arachnotronx2, Reve, Arachnotron, Mutants } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Arachnotronx2, Reve, Reve, Reve, Revex2, Mutantsx2, Arachnotron } },
	{ delay = 1, units = { Arachnotronx2, Arachnotronx2, Reve, Reve, Reve, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = { Revex2, Imp, Impx2, Arachnotronx2, Arachnotronx2, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Imp, Imp, Imp, Imp, Demon, Demon, Demon } },
	{ delay = 1, units = { Impx2, Impx2, Demonx2, Impx2, Imp, Mutantsx2, Demonx2, Revex2 } },
	{ delay = 1, units = { Imp, Mutantsx2, Mancubus, Mutantsx2, Revex2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mancubusx2, Mancubusx2, Arachnotronx2, Revex2 } },
	{ delay = 1, units = { Mancubus, Mancubusx2, Arachnotronx2, Revex2 } },
}

Egg6IncreaseDifficulty = function()
	local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
	Utils.Do(Egg6Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg6SendWave = function()
	if Egg6.IsDead then
		return
	end
	Egg6Wave = Egg6Wave + 1
	local wave = Egg6Waves[Egg5Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg6MonsterEntryPoints).Location
			local target = Utils.Random(Egg6SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg6Wave < #Egg6Waves) then
			delayFirstTeam = 80
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg6SendWave()
				Trigger.AfterDelay(DateTime.Minutes(20), Egg6IncreaseDifficulty)
			end)
		end
	end)
end

-----------Egg7
Egg7MonsterEntryPoints = { MonsterWaypoint7 }
Egg7SpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice", "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi", "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve", "reve" }
	Imp = { "imp" }
	Impx2 = { "imp", "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky", "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc", "manc" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "bspi" }
	Reve = { "reve" }
	Revex2 = { "reve" }
	Imp = { "imp" }
	Impx2 = { "imp" }
	Demon = { "pinky" }
	Demonx2 = { "pinky" }
	Mancubus = { "manc" }
	Mancubusx2 = { "manc" }
elseif Map.LobbyOption("difficulty") == "easy" then
	Mutants = { "pvice" }
	Mutantsx2 = { "pvice" }
	Arachnotron = { "bspi" }
	Arachnotronx2 = { "pvice" }
	Reve = { "reve" }
	Revex2 = { "pvice" }
	Imp = { "imp" }
	Impx2 = { "pvice"  }
	Demon = { "pinky" }
	Demonx2 = { "pvice"  }
	Mancubus = { "manc" }
	Mancubusx2 = { "pvice" }
end

Egg7Wave = 0
Egg7Waves =
{
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mutants } },
	{ delay = 1, units = { Mutantsx2, Arachnotron, Mutantsx2 } },
	{ delay = 1, units = { Arachnotron, Arachnotron, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Arachnotronx2, Reve, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = { Mutantsx2, Revex2, Mutantsx2, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = { Mutantsx2, Mutantsx2, Imp, Arachnotronx2, Revex2, Revex2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Impx2, Impx2, Arachnotronx2, Revex2 } },
	{ delay = 1, units = { Impx2, Mutantsx2, Demon, Arachnotronx2, Mutantsx2 } },
	{ delay = 1, units = { Demon, Demonx2, Mutantsx2, Mutantsx2 } },
	{ delay = 1, units = {  } },
	{ delay = 1, units = { Mancubus } },
	{ delay = 1, units = { Mancubus, Mancubusx2, Arachnotronx2, Mutantsx2 } }
}

Egg7IncreaseDifficulty = function()
	local additions = { Mutants, Arachnotron, Reve, Imp, Demon, Mancubus }
	Utils.Do(Egg7Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

Egg7SendWave = function()
	if Egg7.IsDead then
		return
	end
	Egg7Wave = Egg7Wave + 1
	local wave = Egg7Waves[Egg5Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(Egg7MonsterEntryPoints).Location
			local target = Utils.Random(Egg7SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Egg7Wave < #Egg7Waves) then
			delayFirstTeam = 85
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				Egg7SendWave()
				Trigger.AfterDelay(DateTime.Minutes(15), Egg7IncreaseDifficulty)
			end)
		end
	end)
end

-----------AlienSpawns
AlienMonsterEntryPoints = { MotherShipWaypoint }
AlienSpawnPoints = { Waypoint, Waypoint1, Waypoint2, Waypoint3 }

if Map.LobbyOption("difficulty") == "hard" then
	Mechwarrior = { "mechwarrior", "mechwarrior", "mechwarrior", "mechwarrior" }
	Exciter = { "exciter", "exciter", "exciter" }
	Tripod = { "tripod", "tripod", "tripod" }
elseif Map.LobbyOption("difficulty") == "normal" then
	Mechwarrior = { "mechwarrior", "mechwarrior", "mechwarrior", "exciter" }
	Exciter = { "exciter", "exciter", "exciter" }
	Tripod = { "tripod", "tripod" }
end

AlienWave = 0
AlienWaves =
{
	{ delay = 1, units = { Tripod } },
	{ delay = 1, units = { Mechwarrior } },
	{ delay = 1, units = { Exciter, Exciter } },
	{ delay = 1, units = { Exciter, Mechwarrior } }
}

AlienIncreaseDifficulty = function()
	local additions = { ExoMech, Exciter, Tripod }
	Utils.Do(AlienWaves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

AlienSendWave = function()
	if Mothership.IsDead then
		return
	end
	AlienWave = AlienWave + 1
	local wave = AlienWaves[AlienWave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(AlienMonsterEntryPoints).Location
			local target = Utils.Random(AlienSpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (AlienWave < #AlienWaves) then
			delayFirstTeam = 60
			local delay = delayFirstTeam
			Trigger.AfterDelay(DateTime.Seconds(delay), function()
				AlienSendWave()
				Trigger.AfterDelay(DateTime.Minutes(7), AlienIncreaseDifficulty)
			end)
		end
	end)
end

MothershipChrono = function()
	if Map.LobbyOption("difficulty") == "easy" then
		MothershipDestroyed()
	elseif Map.LobbyOption("difficulty") == "normal" or Map.LobbyOption("difficulty") == "hard" then
		Trigger.AfterDelay(DateTime.Seconds(10), function()
			Media.PlaySound("mothershipdeployed.aud")
			Trigger.AfterDelay(DateTime.Seconds(3), function()
				Media.PlaySound("Chrono.wav")
				Trigger.AfterDelay(DateTime.Seconds(4), function()
					LightningFlash()
					local delay = Utils.RandomInteger(20, 10)
					Lighting.Flash("LightningStrike", delay)
					Lighting.Flash("LightningStrike", delay)
					DecoyMothership = Actor.Create(Mothership, true, { Owner = Monsters, Location = MotherShipWaypoint.Location })
					Trigger.AfterDelay(DateTime.Seconds(0.5), function()
						DecoyMothership.Kill()
						AlienMothership = Actor.Create(Mothership, true, { Owner = Monsters, Location = MotherShipWaypoint.Location })
						Trigger.AfterDelay(DateTime.Seconds(1), function()
							Trigger.OnKilled(AlienMothership, MothershipDestroyed)
							Trigger.AfterDelay(DateTime.Seconds(10), function()
								AlienSendWave()
							end)
						end)
					end)
				end)
			end)
		end)
	end
end
--Tick = function()
--	if Monsters.HasNoRequiredUnits() then
--		Multi0.MarkCompletedObjective(VillageRaidObjective)
--	end
--end


MothershipDestroyed = function()
	Utils.Do(Sniper, function(a)
		if not a.IsDead and a.Owner == Monsters then
			a.Destroy()
		end
		if Monsters.HasNoRequiredUnits() then
		Multi0.MarkCompletedObjective(MonsterObjective)
		end
		if Monsters.HasNoRequiredUnits() then
			Multi1.MarkCompletedObjective(MonsterObjective)
		end
		if Monsters.HasNoRequiredUnits() then
			Multi2.MarkCompletedObjective(MonsterObjective)
		end
		if Monsters.HasNoRequiredUnits() then
			Multi3.MarkCompletedObjective(MonsterObjective)
		end
	end)
end
Tick = function()
	if Multi0.HasNoRequiredUnits() then
		Multi0.MarkFailedObjective(MonsterObjective)
	end
	if Multi1.HasNoRequiredUnits() then
		Multi1.MarkFailedObjective(MonsterObjective)
	end
	if Multi2.HasNoRequiredUnits() then
		Multi2.MarkFailedObjective(MonsterObjective)
	end
	if Multi3.HasNoRequiredUnits() then
		Multi3.MarkFailedObjective(MonsterObjective)
	end
end
Eggs = { Egg, Egg1, Egg2, Egg3, Egg4, Egg5, Egg6, Egg7 }
Mothership = "mothership"
WorldLoaded = function()
	Neutral = Player.GetPlayer("Neutral")
	Creeps = Player.GetPlayer("Creeps")
	Monsters = Player.GetPlayer("Monsters")
	Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	players = { }

	MonsterObjective = Multi0.AddPrimaryObjective("Destroy the Eggs in the middle!")
	MonsterObjective = Multi1.AddPrimaryObjective("Destroy the Eggs in the middle!")
	MonsterObjective = Multi2.AddPrimaryObjective("Destroy the Eggs in the middle!")
	MonsterObjective = Multi3.AddPrimaryObjective("Destroy the Eggs in the middle!")
	Trigger.OnPlayerLost(Multi0, function()
		Media.PlaySpeechNotification(Multi0, "Lose")
	end)
	Trigger.OnPlayerWon(Multi0, function()
		Media.PlaySpeechNotification(Multi0, "Win")
	end)

	Trigger.OnPlayerLost(Multi1, function()
		Media.PlaySpeechNotification(Multi1, "Lose")
	end)
	Trigger.OnPlayerWon(Multi1, function()
		Media.PlaySpeechNotification(Multi1, "Win")
	end)

	Trigger.OnPlayerLost(Multi2, function()
		Media.PlaySpeechNotification(Multi2, "Lose")
	end)
	Trigger.OnPlayerWon(Multi2, function()
		Media.PlaySpeechNotification(Multi2, "Win")
	end)

	Trigger.OnPlayerLost(Multi3, function()
		Media.PlaySpeechNotification(Multi3, "Lose")
	end)
	Trigger.OnPlayerWon(Multi3, function()
		Media.PlaySpeechNotification(Multi3, "Win")
	end)

	Media.DisplayMessage("Destroy the Egg Spawns in the middle!")
	Trigger.OnAllRemovedFromWorld(Eggs, function()
		MothershipChrono()
	end)

	EggSendWave()
	Egg1SendWave()
	Egg2SendWave()
	Egg3SendWave()
	Egg4SendWave()
	Egg5SendWave()
	Egg6SendWave()
	Egg7SendWave()
	--MothershipChrono()
	--if Map.Difficulty == "Mutants On" then
	Media.PlaySound("thunder3.aud")
end

Scorch = function()
	Lighting.Red = 0.9
	Lighting.Green = 0.9
	Lighting.Blue = 1
	Lighting.Ambient = 1.2
 	--Lighting.Ambient = Light
	--if Light < 1.311 then
	--	if Light < 1.20 then
	--		return
	--	else
	--		Light = Light + 0.1
	--		Trigger.AfterDelay(10, function()
	--			Scorch()
	--		end)
	--	end
	--end
end

LightningFlash = function() 
	local delay = Utils.RandomInteger(20, 10)
	Lighting.Flash("LightningStrike", delay)
	Lighting.Flash("LightningStrike", delay)
	Tick = function()
		if (Utils.RandomInteger(1, 200) == 10) then
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Trigger.AfterDelay(delay, function()
				Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
			end)
		end
		if (Utils.RandomInteger(1, 200) == 10) then
			Media.PlaySound("thunder-ambient.aud")
		end
	end
end