Target = {}
local Target	= Target

local Set		= assert(Set, "Invalid module.")

Target.actors = {}

Target.isTarget = function(actor)
	return not not Target.actors[actor]
end

Target.makeTarget = function(actor, func)
	assert(actor, "Invalid actor argument.")
	assert(func, "Invalid func argument.")
	assert(actor.HasProperty("HasPassengers"), "Actor is not transport.")
	Target.actors[actor] = assert(not Target.actors[actor], "Actor is already a target")
	Trigger.OnPassengerEntered(actor, func)
end

Target.makeTargets = function(actors, func)
	assert(actors, "Invalid actors argument.")
	assert(func, "Invalid func argument.") 
	for _, actor in pairs(actors) do
		Target.makeTarget(actor, func)
	end
end

Target.removeTarget = function(actor)
	assert(actor, "Invalid actor argument")
	assert(Target.actors[actor], "Actor is not a target.")
	Trigger.Clear(actor, "OnPassengerEntered")
	Target.actors[actor] = nil
end

Target.removeTargets = function(actors)
	assert(actors, "Invalid actors argument")
	for _, actor in pairs(actors) do
		Target.removeTarget(actor)
	end
end

Target.getTargets = function()
	return Set.toArray(Target.actors)
end
