Tesla = {}
local Tesla = Tesla

local Set = Set

Tesla.hitTrigger = function(actor, n)
	assert(actor, "Invalid actor argument.")
	assert(n and n > 0, "Invalid n argument.")
	local validTypes = Set.toArray(Config.waveTypes)
	local actors = Utils.Shuffle(Map.ActorsInCircle(actor.CenterPosition, WDist.New(4096), function(a)
			return actor ~= a and Utils.Any(validTypes, function(t)
				return t == a.Type
			end)
		end))
	if (#actors > 0) then
		local lim = math.min(n, #actors)
		for i = 1, lim do
			local dummy = Actor.Create("dummy.tesla", true, {Owner = Config.neutral, Location = actor.Location})
			dummy.Attack(table.remove(actors, 1), false, true)
			Trigger.AfterDelay(1, function()
				dummy.Stop()
				dummy.Destroy()
			end)
		end
	end	
end

Tesla.addTriggers = function(actors, n)
	assert(actors, "Invalid actors argument.")
	assert(n and n > 0, "Invalid n argument.")
	for _, a in ipairs(actors) do
		Trigger.OnDamaged(a, function(attacked, attacker)
			Trigger.AfterDelay(1, function()
				if (not attacked.IsDead and (attacker.Type == "tower.tesla")) then
					Tesla.hitTrigger(attacked, n)
				end
			end)
		end)
	end
end
