Spawn = {}
local Spawn = Spawn

local Set		= assert(Set, "Invalid module.")
local Target	= assert(Target, "Invalid module.")

Spawn.actors = {}
Spawn.targets = {}

Spawn.isSpawn = function(actor)
	assert(actor, "Invalid actor argument.")
	return Spawn.actors[actor]
end

Spawn.makeSpawn = function(actor, targets)
	assert(actor, "Invalid actor argument.")
	assert(not Spawn.actors[actor], "Actor is already spawn.")
	targets = targets or Target.getTargets()
	assert(next(targets), "Invalid targets argument.")
	Spawn.actors[actor] = true
	Spawn.targets[actor] = targets
end

Spawn.makeSpawns = function(actors, targets)
	assert(actors, "Invalid actors argument.")
	for _, actor in pairs(actors) do
		Spawn.makeSpawn(actor, targets)
	end
end

Spawn.removeSpawn = function(actor)
	assert(actor, "Invalid actor argument.")
	assert(Spawn.actors[actor], "Actor is not a spawn.")
	Spawns.actors[actor] = nil
	Spawns.targets[actor] = nil
end

Spawn.removeSpawns = function(actors)
	assert(actors, "Invalid actors argument.")
	for _, actor in pairs(actors) do
		Spawn.removeSpawn(actor)
	end
end

Spawn.getSpawns = function()
	return Set.toArray(Spawn.actors)
end

Spawn.getSpawnTargets = function(actor)
	assert(actor, "Invalid actor argument.")
	assert(Spawn.actors[actor], "Actor is not a spawn.")
	return Spawn.targets[actor]
end
