Controller = {}
local Controller = Controller
local Config = Config

Controller.init = function(mode, func)
	assert(mode, "Invalid mode argument.")
	assert(func, "Invalid func argument.")
	Controller.actor = Actor.Create("controller", true, {Owner = Config.player, Location = CPos.New(1, 1)})
	Controller.mode = mode
	Trigger.OnProduction(Controller.actor, function(_, produced)
		func(produced)
	end)
	return Controller.actor
end

Controller.getMode = function()
	return assert(Controller.mode, "Controller uninitialised.")
end

Controller.setMode = function(mode)
	assert(Controller.mode, "Controller uninitialised.")
	Controller.mode.Destroy()
	Controller.mode = assert(mode, "Invalid mode argument.")
end
