WaveMaker = {}
local WaveMaker = WaveMaker

local WaveManager = assert(WaveManager, "wave-maker.lua requires wave-manager.lua.")

WaveMaker.types		= {}
WaveMaker.costs		= {}
WaveMaker.shares	= {}
WaveMaker.minWaves	= {}
WaveMaker.maxWaves	= {}

WaveMaker.getTypes = function()
	return WaveMaker.types
end

WaveMaker.addType = function(type, cost, shares, minWave, maxWave)
	assert(type, "Invalid type argument.")
	assert(cost, "Invalid cost argument.")
	assert(shares, "Invalid shares argument.")
	WaveMaker.types[type] = true
	WaveMaker.costs[type] = cost
	WaveMaker.shares[type] = shares
	WaveMaker.minWaves[type] = minWave
	WaveMaker.maxWaves[type] = maxWave
end

WaveMaker.addTypes = function(types, cost, shares, minWave, maxWave)
	assert(types, "Invalid types argument.")
	assert(cost, "Invalid cost argument.")
	assert(shares, "Invalid shares argument.")
	for _, type in ipairs(types) do
		WaveMaker.addType(type, cost, shares, minWave, maxWave)
	end
end

WaveMaker.removeType = function(type)
	assert(type, "Invalid type argument.")
	WaveMaker.types[type] = nil
	WaveMaker.costs[type] = nil
	WaveMaker.shares[type] = nil
	WaveMaker.minWave[type] = nil
	WaveMaker.maxWave[type] = nil
end

WaveMaker.removeTypes = function(types)
	assert(types, "Invalid types argument.")
	for _, type in ipairs(types) do
		WaveMaker.removeType(type)
	end
end

WaveMaker.clear = function()
	WaveMaker.types		= {}
	WaveMaker.costs		= {}
	WaveMaker.shares	= {}
	WaveMaker.minWaves	= {}
	WaveMaker.maxWaves	= {}
end

WaveMaker.getCost = function(type)
	assert(type, "Invalid type parameter.")
	assert(WaveMaker.types[type], "Type has not been added.")
	return WaveMaker.costs[type]
end

WaveMaker.getShares = function(type)
	assert(type, "Invalid type parameter.")
	assert(WaveMaker.types[type], "Type has not been added.")
	return WaveMaker.shares[type]
end

WaveMaker.getMinWave = function(type)
	assert(type, "Invalid type parameter.")
	assert(WaveMaker.types[type], "Type has not been added.")
	return WaveMaker.minWave[type]
end

WaveMaker.getMaxWave = function(type)
	assert(type, "Invalid type parameter.")
	assert(WaveMaker.types[type], "Type has not been added.")
	return WaveMaker.maxWave[type]
end

WaveMaker.createWave = function(budget)
	assert(budget and budget >= 0, "Invalid budget argument.")
	assert(next(WaveMaker.types), "No types have been added to WaveMaker.")
	local waveNum = WaveManager.getWaveNum()
	local wave = {}
	while (budget > 0) do
		local candidates = {}
		for type in pairs(WaveMaker.types) do
			if (WaveMaker.costs[type] <= budget and (not WaveMaker.minWaves[type] or WaveMaker.minWaves[type] <= waveNum) and (not WaveMaker.maxWaves[type] or WaveMaker.maxWaves[type] >= waveNum)) then
				for i = 1, WaveMaker.shares[type] do table.insert(candidates, type) end
			end
		end
		local choice = Utils.Random(candidates)
		table.insert(wave, choice)
		budget = budget - WaveMaker.costs[choice]
	end
	return wave
end
