local Array			= Array
local Camera		= Camera
local Config		= Config
local Controller	= Controller
local Interface		= Interface
local Lives			= Lives
local MapUtility	= MapUtility
local Target		= Target
local Path			= Path
local Set			= Set
local Spawn			= Spawn
local Target		= Target
local Tesla			= Tesla
local Utility		= Utility
local WaveMaker		= WaveMaker
local WaveManager	= WaveManager

local initObjective = function()
	if (Config.wavesToSurvive) then
		return Config.player.AddPrimaryObjective("Survive " .. Config.wavesToSurvive .. " waves.")
	end
	return Config.player.AddPrimaryObjective("Survive as long as possible.")
end


local initSpawns = function()
	Spawn.makeSpawns(Utils.Where(Map.ActorsInWorld, function(a)
		return a.Type == "spawn"
	end))
end

local initTargets = function()
	Target.makeTargets(Utils.Where(Map.ActorsInWorld, function(a)
		return a.Type == "target"
	end), function(_, a)
		a.Kill()
		Lives.decLives(1)
	end)
end

local initLives = function(id)
	Lives.init(Config.lives, Config.maxLives)
	Lives.setToStringFunc(function(v, m)
		return Array.foldl(Array.concat({Utility.replicate(v, "|")}, {Utility.replicate(m - v, " ")}), function(s1, s2) return s1 .. s2 end, "Lives: ")
	end)
	Lives.setDecFunc(function()
		Interface.update()
	end)
	Lives.setDeathFunc(function()
		if (Config.wavesToSurvive) then
			Config.player.MarkFailedObjective(id)
		else
			Config.player.MarkCompletedObjective(id)
		end
	end)
end

local initPath = function()
	Path.setPathEnabled(true)
	Path.setBorderEnabled(false)
end

local createWave = function(typeMap, budget)
	local w = {}
	while (budget > 0) do
		typeMap = Set.filter(typeMap, function(v) return typeMap[v] <= budget end)
		if (Set.size(typeMap) == 0) then break end
		local type = Utils.Random(Set.toArray(typeMap))
		budget = budget - typeMap[type]
		table.insert(w, type)
	end
	return w
end

local waveEnd = function(id)
	return function()
		if (Config.wavesToSurvive and WaveManager.getWaveNum() == Config.wavesToSurvive) then
			Config.player.MarkCompletedObjective(id)		
		end
		Path.setPathEnabled(true)
		Path.setBorderEnabled(false)
		local a = Actor.Create("mode_build", true, {Owner = Config.player, Location = CPos.New(1, 1)})
		Controller.setMode(a)
		WaveManager.incWaveNum()
		Interface.update()
		Config.player.Cash = Config.player.Cash + (math.log(WaveManager.getWaveNum() + 2) * 50)
	end
end

local initController = function(id)
	Controller.init(Actor.Create("mode_build", true, {Owner = Config.player, Location = CPos.New(1,1)}), function(a)
		if (a.Type == "mode_wave") then
			Controller.setMode(a)
			Path.setBorderEnabled(true)
			Path.setPathEnabled(false)
			local wave = WaveMaker.createWave(math.pow(WaveManager.getWaveNum(), 2) + 8)
			local actors = WaveManager.sendWave(wave, nil, waveEnd(id))
			Tesla.addTriggers(actors, 2)
		end
	end)
end

local initConfig = function()
	if (Config.waveTypes) then
		for type, info in pairs(Config.waveTypes) do
			WaveMaker.addType(type, info.cost, info.shares, info.minWave, info.maxWave)
		end
	end
end

local initInterface = function()
	Interface.setOutputFunc(function()
		return "[ Tower Defence v2.0 Showcase | Wave: " .. WaveManager.getWaveNum() .. " | " .. Lives.toString() .. " ]"
	end)
	Interface.update()
end

WorldLoaded = function()
	local id = initObjective()
	initTargets()
	initSpawns()
	initLives(id)
	initPath()
	initController()
	initConfig()
	initInterface()
	Camera.centre()
end
